import java.awt.*;
import java.awt.geom.*;
import java.awt.Graphics2D;
import java.awt.event.*;
import javax.swing.*;

public class GamePanel extends JPanel implements MouseMotionListener,MouseListener, KeyListener{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private AffineTransform Maffine;
    public Board board;
    private Timer timer;
    public static int PANEL_WIDTH;
    public static int PANEL_HEIGHT;
    public double currentMoveX = 0;
    public double currentMoveY = 0;
    private double currentZoom = 1;
    private CellPanel cellPanel;

    private Point currentPoint;
    private Point startCell;
    private Point endCell;

    private boolean pasteState = false;
    private AffineTransform getMaffine()
    {
	AffineTransform ScaleTransform = AffineTransform.getScaleInstance(currentZoom, currentZoom);
	ScaleTransform.translate(currentMoveX, currentMoveY);
	return ScaleTransform;
    }
    
    public GamePanel(CellPanel cpanel)
    {
	Maffine = getMaffine();
	board = new Board(16,16);
	PANEL_WIDTH = Board.CELL_WIDTH * 16;
	PANEL_HEIGHT = Board.CELL_HEIGHT * 16;
	cellPanel = cpanel;
	setPreferredSize(new Dimension(Board.CELL_WIDTH * 16,
				       Board.CELL_HEIGHT * 16));
	this.addMouseListener(this);
	this.addMouseMotionListener(this);
	this.setFocusable(true);
	this.addKeyListener(this);
    }
	

    public void zoom()
    {
	currentZoom *= 2;
	Maffine = getMaffine();
    }
    public void unzoom()
    {
	currentZoom *= 0.5;
	Maffine = getMaffine();
    }

    @Override
	public void paintComponent(Graphics g)
    {
	Graphics2D g2d = (Graphics2D)g;
	super.paintComponent(g);
	g2d.transform(Maffine);
	board.draw(g);
	g.setColor(Color.BLUE);
	if(startCell != null && endCell != null) {
		g.drawRect(Board.CELL_WIDTH * startCell.x,
			   Board.CELL_HEIGHT * startCell.y,
			   Board.CELL_WIDTH * (endCell.x - startCell.x + 1) - 1,
			   Board.CELL_HEIGHT * (endCell.y - startCell.y + 1) - 1);
	    }
    }
	
    @Override
	public void mouseClicked(MouseEvent e)
    {
			
    }
		
    @Override
	public void mouseEntered(MouseEvent e) {}
	
    @Override
	public void mouseExited(MouseEvent e) {}
	
    @Override
	public void mousePressed(MouseEvent e) {
	int mouse_x = e.getX();
	int mouse_y = e.getY();
	Point worldMapPoint = transformMousePoint(mouse_x, mouse_y);
	int cell_x = worldMapPoint.x / Board.CELL_WIDTH;
	int cell_y = worldMapPoint.y / Board.CELL_HEIGHT;
	if(pasteState == true) {
	    this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
	    board.paste(new Point(cell_x, cell_y));
	    pasteState = false;
	}
	else if(SwingUtilities.isRightMouseButton(e)) {
	     startCell = new Point(cell_x, cell_y);
	 }
	 else if(SwingUtilities.isLeftMouseButton(e)) {
	     board.setCell(cell_x, cell_y, cellPanel.getCurrentIcon());
	 }
	 repaint();
    }
	
    @Override
	public void mouseReleased(MouseEvent e) {
    }
    
    public Point transformMousePoint(int x, int y) {
	Point start = new Point(x, y);
	Point dist = new Point(0, 0);
	try {
	    Maffine.createInverse().transform((Point2D)start, (Point2D)dist);
	} catch(java.awt.geom.NoninvertibleTransformException e) {
	    e.printStackTrace();
	}
	return dist;
    }

    public void keyTyped(KeyEvent e) {}
    public void keyPressed(KeyEvent e) 
    {
	int keyCode = e.getKeyCode();
	switch(keyCode) {
	case KeyEvent.VK_UP:
	    currentMoveY +=5;
	    break;
	case KeyEvent.VK_DOWN:
	    currentMoveY -=5;
	    break;
	case KeyEvent.VK_RIGHT:
	    currentMoveX -=5;
	    break;
	case KeyEvent.VK_LEFT:
	    currentMoveX +=5;
	    break;
	default:
	    break;
	}
	if(currentMoveX * -1 < 0) {
	    currentMoveX = 0;
	}
	if(currentMoveY * -1 < 0) {
	    currentMoveY = 0;
	}
	Maffine = getMaffine();
	repaint();
    }
    @Override
	public void mouseDragged(MouseEvent e) {
	Point endPoint = transformMousePoint(e.getX(), e.getY());
	endCell = new Point(endPoint.x / Board.CELL_WIDTH,
			    endPoint.y / Board.CELL_HEIGHT);
	repaint();
    }
    @Override
	public void mouseMoved(MouseEvent e) {
	int mouse_x = e.getX();
	int mouse_y = e.getY();
	currentPoint = transformMousePoint(mouse_x, mouse_y);
    }
    public void keyReleased(KeyEvent e) {}
    
    public void copy() {
	board.save(startCell, endCell);
    }
    
    public void cut() {
	board.cut(startCell, endCell);
	repaint();
    }

    public void paste() {
	this.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	pasteState = true;
    }

}

