using System;
using System.IO;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.ui.mainframe;
using nft.ui.command;
using nft.framework.drawing;

namespace nft.contributions.ui
{
	/// <summary>
	/// CtbMenuItem ̊Tv̐łB
	/// </summary>
	public class CtbToolButton : Contribution
	{
		
		/// <summary>
		/// Contributes a menu and submenu items to mainmenu.
		/// 
		/// This contribution can add several items at once.
		/// </summary>
        public CtbToolButton(Plugin p, XmlElement e)
            : base(p, e) {
            XmlElement bar = (XmlElement)XmlUtil.SelectSingleNode(e, "bar");
            parseNode(bar);
        }

        protected void parseNode(XmlElement ebar)
		{
            string barname = XmlUtil.GetAttribute(ebar, "name", "MAIN");
            XmlUtil.SetAttribute(ebar, "parent", barname);
            XmlUtil.SetAttribute(ebar, "id", ""); // set dummy id to parse successfuly
            CommandPathHint hint = new CommandPathHint(ebar);
            foreach (XmlNode cn in ebar.ChildNodes)
			{
				if(!cn.Name.Equals("button")) continue;
				//ButtonCreationInfo info = parseButton(cn);
				//Main.mainFrame.AddToolButton(info,barname,after,before);
                hint.ID = XmlUtil.GetAttribute(cn, "bid", "").Trim();
                CommandUI cui = parseButton(cn);
                CommandManager.TheInstance.RegisterCommand(this, cui, null, hint);

			}
		
		}

        protected CommandUI parseButton(XmlNode item)
		{
			string _img = XmlUtil.GetAttribute(item,"image").Trim();
            ImageRef iref = PluginImageManager.GetBundledImageRef(this, _img);
            string _cap = XmlUtil.GetAttribute(item, "caption", "").Trim();
            TriggerCommandUI cui = new TriggerCommandUI(_cap, item.InnerText, iref);
            XmlAttribute aidx = item.Attributes["index"];
            if (aidx != null) {
                cui.IconIndex = int.Parse(aidx.InnerText);
            }
            return cui;
		}
	}
}
