﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.ui.command {
    public interface ICommandEntity {
        bool Enable { get; }
        event EventHandler EnableChanged;
    }

    public interface ITriggerCommandEntity : ICommandEntity {
        void Execute();
    }

    public delegate void ListModelventHandler(ISingleSelectCommandEntity sender, EventArgs e);

    public interface ISingleSelectCommandEntity : ICommandEntity {
        void Select(string name);
        string Current { get; set; }
        event ListModelventHandler SelectionChanged;
        void SelectNext();
        void SelectPrev();
    }
}
