﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Globalization;

namespace nft.util {
    public static class StringParseUtil {
        #region System.Drawing.Color
        public static String ToHexString(Color c) {
            return string.Format("#{0:X6}", c.ToArgb() & 0xffffff);
        }
        public static String ToHexStringAlpha(Color c) {
            return string.Format("#{0:X8}", c.ToArgb());
        }
        public static String ToCsvString(Color c) {
            return string.Format("{0},{1},{2}", c.R, c.G, c.B);
        }
        public static String ToCsvStringAlpha(Color c) {
            return string.Format("{0},{1},{2},{3}", c.A, c.R, c.G, c.B);
        }

        public static Color CreateColor(string s) {
            try {
                s = s.Trim();
                if (s.StartsWith("#")) {
                    int v = int.Parse(s.Substring(1), NumberStyles.AllowHexSpecifier);
                    if (s.Length <= 7)
                        v = (int)((uint)v | 0xff000000);
                    return Color.FromArgb(v);
                } else {
                    int[] v = CsvToArray(s);
                    if (v.Length > 3) {
                        return Color.FromArgb(v[0], v[1], v[2], v[3]);
                    } else {
                        return Color.FromArgb(v[0], v[1], v[2]);
                    }
                }
            } catch (Exception e) {
                throw new ArgumentException("cannot parse", s, e);
            }
        }

        public static Color CreateColor(string s, Color _default) {
            try {
                return CreateColor(s);
            } catch (Exception) {
                return _default;
            }
        }
        #endregion

        #region System.Drawing.Rectangle
        public static String ToCsvString(Rectangle r) {
            return string.Format("{0},{1},{2},{3}", r.X, r.Y, r.Width, r.Height);
        }
        public static Rectangle CreateRectangle(string s) {
            try {
                int[] v = CsvToArray(s);
                return new Rectangle(v[0], v[1], v[2], v[3]);
            } catch (Exception e) {
                throw new ArgumentException("cannot parse", s, e);
            }
        }
        public static Rectangle CreateRectangle(string s, Rectangle _default) {
            try {
                return CreateRectangle(s);
            } catch (Exception) {
                return _default;
            }
        }
        #endregion

        #region System.Drawing.Point
        public static String ToCsvString(Point p) {
            return string.Format("{0},{1}", p.X, p.Y);
        }
        public static Point CreatePoint(string s) {
            try {
                int[] v = CsvToArray(s);
                return new Point(v[0], v[1]);
            } catch (Exception e) {
                throw new ArgumentException("cannot parse", s, e);
            }
        }
        public static Point CreatePoint(string s, Point _default) {
            try {
                return CreatePoint(s);
            } catch (Exception) {
                return _default;
            }
        }
        #endregion

        #region System.Drawing.Size
        public static String ToCsvString(Size p) {
            return string.Format("{0},{1}", p.Width, p.Height);
        }
        public static Size CreateSize(string s) {
            try {
                int[] v = CsvToArray(s);
                return new Size(v[0], v[1]);
            } catch (Exception e) {
                throw new ArgumentException("cannot parse", s, e);
            }
        }
        public static Size CreateSize(string s, Size _default) {
            try {
                return CreateSize(s);
            } catch (Exception) {
                return _default;
            }
        }
        #endregion

        static private int[] CsvToArray(string s) {
            string[] a = s.Split(',');
            int n = a.Length;
            int[] v = new int[n];
            for (int i = 0; i < n; i++)
                v[i] = int.Parse(a[i]);
            return v;
        }
    }
}
