using System;
using System.Windows.Forms;

namespace nft.ui.command
{
	/// <summary>
	/// CommandTriggerFactory ̊Tv̐łB
	/// </summary>
	public class CommandTriggerFactory
	{
        public static ICommandTrigger Create(ToolStripMenuItem item)
		{ return new MenuItemTrigger(item); }
		public static ICommandTrigger Create( Button item )
		{ return new ButtonTrigger(item); }
		public static ICommandTrigger Create( CheckBox item )
		{ return new CheckBoxTrigger(item); }
		public static ICommandTrigger Create( ToolStripButton item )
		{ return new ToolBarItemTrigger(item); }
		public static ICommandTrigger Create( ToolBarButton item )
		{ return new ToolBarButtonTrigger(item); }
		public static ICommandTrigger Create( Control item )
		{ return new ControlTrigger(item); }
	}
}
