#region File Description
//-----------------------------------------------------------------------------
// GraphicsDeviceService.cs
//
// Microsoft XNA Community Game Platform
// Copyright (C) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------
#endregion

#region Using Statements
using System;
using System.Threading;
using Microsoft.Xna.Framework.Graphics;
using System.IO;
using System.Windows.Forms;
#endregion

// IGraphicsDeviceService C^[tFCX́ADeviceCreated CxgKvƂ܂A
// ɃRXgN^[ŃfoCX쐬邾Ȃ̂ŁÃCxg𔭐
// ꏊ܂BC# RpCACxggpĂȂAƌx܂A
// ł͐SzȂ̂ŁAPɂ̌x𖳌ɂ܂B
#pragma warning disable 67

namespace WinFormsGraphicsDevice
{
    /// <summary>
    /// GraphicsDevice ̍쐬ƊǗSwp[ NXB
    /// ׂĂ GraphicsDeviceControl CX^X́A GraphicsDeviceService 
    /// L̂ŁÃRg[݂ꍇłAw GraphicsDevice  
    /// 1 ݂܂B̃wp[͕W IGraphicsDeviceService 
    /// C^[tFCX܂B̃C^[tFCX́AfoCXZbg܂
    /// jꂽƂɂɊւʒmCxg𐶐܂B
    /// </summary>
    class GraphicsDeviceService : IGraphicsDeviceService
    {
        #region Fields


        // VOg foCX T[rX CX^XB
        static GraphicsDeviceService singletonInstance;


        // singletonInstance LĂRg[̐ǐՂ܂B
        static int referenceCount;

        static ServiceContainer services = new ServiceContainer();

        #endregion


        /// <summary>
        /// VOg NXȂ̂ŃRXgN^[̓vCx[głB
        /// NCAg Rg[́AɃpubN AddRef \bh
        /// gpKv܂B
        /// </summary>
        GraphicsDeviceService(IntPtr windowHandle, int width, int height)
        {
            parameters = new PresentationParameters();

            parameters.BackBufferWidth = Math.Max(width, 1);
            parameters.BackBufferHeight = Math.Max(height, 1);
            parameters.BackBufferFormat = SurfaceFormat.Color;
            parameters.DepthStencilFormat = DepthFormat.Depth24;
            parameters.DeviceWindowHandle = windowHandle;
            parameters.PresentationInterval = PresentInterval.Immediate;
            //parameters.RenderTargetUsage = RenderTargetUsage.DiscardContents;
            parameters.IsFullScreen = false;

            graphicsDevice = new GraphicsDevice(GraphicsAdapter.DefaultAdapter,
                                                GraphicsProfile.HiDef,
                                                parameters);
            InitGraphicsDevice(graphicsDevice);
        }

        private void InitGraphicsDevice(GraphicsDevice dev) {
            // ڂ₯Ȃ: disable texture smoothing
            dev.SamplerStates[0] = SamplerState.PointClamp;
            // [xobt@L: enable depth buffer
            dev.DepthStencilState = DepthStencilState.Default;
        }

        /// <summary>
        /// VOg CX^Xɑ΂QƂ擾܂B
        /// </summary>
        public static GraphicsDeviceService AddRef(IntPtr windowHandle,
                                                   int width, int height)
        {
            // "foCXLĂRg[̐" JE^[𑝂₵܂B
            if (Interlocked.Increment(ref referenceCount) == 1)
            {                
                if (windowHandle == IntPtr.Zero) {
                    int i = 0;
                    int c = Application.OpenForms.Count;
                    while (c > 0) {
                        windowHandle = Application.OpenForms[i++].Handle;
                        c--;
                        if (windowHandle != IntPtr.Zero)
                            break;
                    }
                }
                // ꂪAfoCXgpn߂ŏ̃Rg[̏ꍇA
                // VOg CX^X쐬Kv܂B
                singletonInstance = new GraphicsDeviceService(windowHandle,
                                                              width, height);

                // ContentManager Ȃǂ̃R|[lg猟oł悤ɁA
                // T[rXo^܂B
                // GraphicDeviceContorlɂɈړ c477
                services.AddService<IGraphicsDeviceService>(singletonInstance);
            }

            return singletonInstance;
        }

        /// <summary>
        /// ̃Tv IGraphicsDeviceService ܂ IServiceProvider 擾܂B
        /// ́AContentManager Ȃǂ̃R|[lgŎgpł܂B
        /// R|[lg͂̃T[rXgpāAGraphicsDevice 擾܂B
        /// GraphicDeviceContorlɂ\bhɈړ c477
        /// </summary>
        public static ServiceContainer Services {
            get { return services; }
        }

        /// <summary>
        /// VOg CX^Xɑ΂QƂ܂B
        /// </summary>
        public void Release(bool disposing)
        {
            // "foCXLRg[" JE^[炵܂B
            if (Interlocked.Decrement(ref referenceCount) == 0)
            {
                // ꂪAfoCXgpIŌ̃Rg[̏ꍇA
                // VOg CX^XjKv܂B
                if (disposing)
                {
                    if (DeviceDisposing != null)
                        DeviceDisposing(this, EventArgs.Empty);

                    graphicsDevice.Dispose();
                }

                graphicsDevice = null;
            }
        }

        /// <summary>
        /// BeginDraw ɂgpwp[B́AOtBbN foCX̃Xe[^X
        /// `FbNāÃ݂Rg[̕`ɏ\傫AfoCXXgĂȂ
        /// ƂmF܂BfoCXZbgłȂꍇAG[Ԃ܂B
        /// GraphicDeviceContorlɂ\bhɈړ c477
        /// </summary>
        public bool PrepareDrawing(int width, int height, out Viewport viewport) 
        {
            bool deviceNeedsReset = false;

            switch (graphicsDevice.GraphicsDeviceStatus)
            {
                case GraphicsDeviceStatus.Lost:
                    // OtBbN foCXXgĂꍇ́A܂gpł܂B
                    throw new IOException("Graphics device lost");

                case GraphicsDeviceStatus.NotReset:
                    // foCXZbgĂȂԂ̏ꍇ́AZbg݂Kv܂B
                    deviceNeedsReset = true;
                    break;

                default:
                    // foCX̏ԂȂꍇA\ɑ傫ǂ`FbN܂B
                    PresentationParameters pp = graphicsDevice.PresentationParameters;

                    deviceNeedsReset = (width > pp.BackBufferWidth) || (height > pp.BackBufferHeight);
                    break;
            }

            // foCXZbgKv܂B
            if (deviceNeedsReset)
            {
                try
                {
                    ResetDevice(width, height);
                }
                catch (Exception e)
                {
                    throw new IOException("Graphics device reset failed",e);
                }
            }

            //  GraphicsDeviceControl CX^XA GraphicsDevice 
            // Lł܂BfoCX obNobt@[́Âő̃Rg[
            // ɍ킹ăTCYύX܂Bł́A݂菬ȃRg[
            // `悵Ăꍇ͂ǂł傤BsvɈL΂邱Ƃ邽߁A
            // t obNobt@[̍㕔gp悤ɁAr[|[gݒ肵܂B
            viewport = new Viewport();

            viewport.X = 0;
            viewport.Y = 0;

            viewport.Width = width;
            viewport.Height = height;

            viewport.MinDepth = 0;
            viewport.MaxDepth = 1;

            //graphicsDevice.Viewport = viewport;
            
            return deviceNeedsReset;
        }

        /// <summary>
        /// OtBbN foCXAw肵𑜓x܂͌ݕۗLĂ
        /// Rg[ TCY̑傫ɍ킹ăZbg܂B̓́A
        /// foCXAׂĂ GraphicsDeviceControl NCAĝ
        /// ő̂̂ɉđ傫Ȃ邱ƂӖ܂B
        /// </summary>
        public void ResetDevice(int width, int height)
        {
            if (DeviceResetting != null)
                DeviceResetting(this, EventArgs.Empty);

            parameters.BackBufferWidth = Math.Max(parameters.BackBufferWidth, width);
            parameters.BackBufferHeight = Math.Max(parameters.BackBufferHeight, height);

            graphicsDevice.Reset(parameters);

            if (DeviceReset != null)
                DeviceReset(this, EventArgs.Empty);
        }

        
        /// <summary>
        /// ݂̃OtBbN foCX擾܂B
        /// </summary>
        public GraphicsDevice GraphicsDevice
        {
            get { return graphicsDevice; }
        }

        GraphicsDevice graphicsDevice;


        // ݂̃foCXݒi[܂B
        PresentationParameters parameters;


        // IGraphicsDeviceService CxgB
        public event EventHandler<EventArgs> DeviceCreated;
        public event EventHandler<EventArgs> DeviceDisposing;
        public event EventHandler<EventArgs> DeviceReset;
        public event EventHandler<EventArgs> DeviceResetting;
    }
}
