#region File Description
//-----------------------------------------------------------------------------
// GraphicsDeviceControl.cs
//
// Microsoft XNA Community Game Platform
// Copyright (C) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------
#endregion

#region Using Statements
using System;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Xna.Framework.Graphics;
#endregion

namespace WinFormsGraphicsDevice
{
    // System.Drawing  XNA Framework ̗ŁAColor ^ Rectangle ^
    // `Ă܂B邽߂ɁAǂgp邩mɎw肵܂B
    using Color = System.Drawing.Color;
    using Rectangle = Microsoft.Xna.Framework.Rectangle;


    /// <summary>
    /// ̃JX^ Rg[́AXNA Framework GraphicsDevice gpāA
    /// Windows tH[Ƀ_O܂BhNX́AInitialize \bh 
    /// Draw \bhI[o[ChāAƎ̕`R[hǉł܂B
    /// </summary>
    abstract public class GraphicsDeviceControl : Control
    {
        #region Fields


        // gp GraphicsDeviceControl CX^X̐Ɋ֌WȂAwł́A
        // ׂẴwp[ T[rXŊǗ铯 GraphicsDevice L܂B
        GraphicsDeviceService graphicsDeviceService;


        #endregion

        #region Properties


        /// <summary>
        /// ̃Rg[ւ̕`Ɏgpł GraphicsDevice 擾܂B
        /// </summary>
        public GraphicsDevice GraphicsDevice
        {
            get { return graphicsDeviceService.GraphicsDevice; }
        }


        /// <summary>
        /// ̃Tv IGraphicsDeviceService ܂ IServiceProvider 擾܂B
        /// ́AContentManager Ȃǂ̃R|[lgŎgpł܂B
        /// R|[lg͂̃T[rXgpāAGraphicsDevice 擾܂B
        /// </summary>
        public ServiceContainer Services
        {
            get { return services; }
        }

        ServiceContainer services = new ServiceContainer();


        #endregion

        #region Initialization


        /// <summary>
        /// Rg[܂B
        /// </summary>
        protected override void OnCreateControl()
        {
            // fUCi[ŎsĂꍇ́AOtBbN foCX܂B
            if (!DesignMode)
            {
                graphicsDeviceService = GraphicsDeviceService.AddRef(Handle,
                                                                     ClientSize.Width,
                                                                     ClientSize.Height);

                // ContentManager Ȃǂ̃R|[lg猟oł悤ɁA
                // T[rXo^܂B
                services.AddService<IGraphicsDeviceService>(graphicsDeviceService);

                // hNXɎg@^܂B
                Initialize();
            }

            base.OnCreateControl();
        }


        /// <summary>
        /// Rg[j܂B
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (graphicsDeviceService != null)
            {
                graphicsDeviceService.Release(disposing);
                graphicsDeviceService = null;
            }

            base.Dispose(disposing);
        }


        #endregion

        #region Paint


        /// <summary>
        /// WinForms yCg bZ[WɉăRg[ĕ`悵܂B
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            string beginDrawError = BeginDraw();

            if (string.IsNullOrEmpty(beginDrawError))
            {
                // GraphicsDevice gpăRg[`悵܂B
                Draw();
                EndDraw();
            }
            else
            {
                // BeginDraw sꍇASystem.Drawing gp
                // G[ bZ[W\܂B
                PaintUsingSystemDrawing(e.Graphics, beginDrawError);
            }
        }


        /// <summary>
        /// Rg[̕`Jn悤Ƃ܂BOtBbN foCXXgĂA
        /// tH[ fUCi[ŎsĂꍇɊJnłȂƂ܂A
        /// ̏ꍇ́AG[ bZ[WԂ܂B
        /// </summary>
        string BeginDraw()
        {
            // OtBbN foCXȂꍇ́AfUCi[ŎsĂ܂B
            if (graphicsDeviceService == null)
            {
                return Text + "\n\n" + GetType();
            }

            // OtBbN foCX\ɑ傫AXgĂȂƂmF܂B
            string deviceResetError = HandleDeviceReset();

            if (!string.IsNullOrEmpty(deviceResetError))
            {
                return deviceResetError;
            }

            //  GraphicsDeviceControl CX^XA GraphicsDevice 
            // Lł܂BfoCX obNobt@[́Âő̃Rg[
            // ɍ킹ăTCYύX܂Bł́A݂菬ȃRg[
            // `悵Ăꍇ͂ǂł傤BsvɈL΂邱Ƃ邽߁A
            // t obNobt@[̍㕔gp悤ɁAr[|[gݒ肵܂B
            Viewport viewport = new Viewport();

            viewport.X = 0;
            viewport.Y = 0;

            viewport.Width = ClientSize.Width;
            viewport.Height = ClientSize.Height;

            viewport.MinDepth = 0;
            viewport.MaxDepth = 1;

            GraphicsDevice.Viewport = viewport;

            return null;
        }


        /// <summary>
        /// Rg[̕`I܂B́AhNX Draw \bhI
        /// ɌĂяoAC[Wʏɕ\S܂B
        /// K؂ WinForms Rg[ nhgpāAʒu
        /// \悤ɂ܂B
        /// </summary>
        void EndDraw()
        {
            try
            {
                Rectangle sourceRectangle = new Rectangle(0, 0, ClientSize.Width,
                                                                ClientSize.Height);

                GraphicsDevice.Present(sourceRectangle, null, this.Handle);
            }
            catch
            {
                // Present ́AfoCX`撆ɎꂽꍇɃX[ꍇ܂B
                // XgfoCX́A BeginDraw ŏ̂ŁAO͎󂯓
                // ŁAʂȏ͂܂B
            }
        }


        /// <summary>
        /// BeginDraw ɂgpwp[B́AOtBbN foCX̃Xe[^X
        /// `FbNāÃ݂Rg[̕`ɏ\傫AfoCXXgĂȂ
        /// ƂmF܂BfoCXZbgłȂꍇAG[Ԃ܂B
        /// </summary>
        string HandleDeviceReset()
        {
            bool deviceNeedsReset = false;

            switch (GraphicsDevice.GraphicsDeviceStatus)
            {
                case GraphicsDeviceStatus.Lost:
                    // OtBbN foCXXgĂꍇ́A܂gpł܂B
                    return "Graphics device lost";

                case GraphicsDeviceStatus.NotReset:
                    // foCXZbgĂȂԂ̏ꍇ́AZbg݂Kv܂B
                    deviceNeedsReset = true;
                    break;

                default:
                    // foCX̏ԂȂꍇA\ɑ傫ǂ`FbN܂B
                    PresentationParameters pp = GraphicsDevice.PresentationParameters;

                    deviceNeedsReset = (ClientSize.Width > pp.BackBufferWidth) ||
                                       (ClientSize.Height > pp.BackBufferHeight);
                    break;
            }

            // foCXZbgKv܂B
            if (deviceNeedsReset)
            {
                try
                {
                    graphicsDeviceService.ResetDevice(ClientSize.Width,
                                                      ClientSize.Height);
                }
                catch (Exception e)
                {
                    return "Graphics device reset failed\n\n" + e;
                }
            }

            return null;
        }


        /// <summary>
        /// LȃOtBbN foCXȂꍇ (Ƃ΁AfoCXĂA
        /// tH[ fUCi[ŎsĂꍇ)Aʏ System.Drawing 
        /// \bhgpāAXe[^X bZ[W\Kv܂B
        /// </summary>
        protected virtual void PaintUsingSystemDrawing(Graphics graphics, string text)
        {
            graphics.Clear(Color.CornflowerBlue);

            using (Brush brush = new SolidBrush(Color.Black))
            {
                using (StringFormat format = new StringFormat())
                {
                    format.Alignment = StringAlignment.Center;
                    format.LineAlignment = StringAlignment.Center;

                    graphics.DrawString(text, Font, brush, ClientRectangle, format);
                }
            }
        }


        /// <summary>
        /// wi̕`wAWinForms ̃bZ[W𖳎܂B̎ł́A
        /// Rg[݂̔wiFŃNA܂B OnPaint  XNA 
        /// Framework  GraphicsDevice gpĒɕʂ̐Fd˂ĕ`悷̂ŁA
        /// ʂĂ܂܂B
        /// </summary>
        protected override void OnPaintBackground(PaintEventArgs pevent)
        {
        }


        #endregion

        #region Abstract Methods


        /// <summary>
        /// hNX́AI[o[ChāA`R[h܂B
        /// </summary>
        protected abstract void Initialize();


        /// <summary>
        /// hNX́AI[o[ChāAGraphicsDevice gpĎg`悵܂B
        /// </summary>
        protected abstract void Draw();


        #endregion
    }
}
