﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SysColor = System.Drawing.Color;
using XnaColor = Microsoft.Xna.Framework.Color;
using SysRect = System.Drawing.Rectangle;
using XnaRect = Microsoft.Xna.Framework.Rectangle;
using nft.framework.drawing;
using Microsoft.Xna.Framework;

namespace nft.xna
{
    internal class XnaUtil
    {
        public static SysColor ToSysColor(XnaColor src)
        {
            return SysColor.FromArgb(src.A,src.R,src.G,src.B);
        }

        public static XnaColor ToXnaColor(SysColor src)
        {
            return new XnaColor(src.R, src.G, src.B, src.A);
        }

        public static SysRect ToSysRect(XnaRect src)
        {
            return new SysRect(src.X, src.Y, src.Width, src.Height);
        }

        public static XnaRect ToXnaRect(SysRect src)
        {
            return new XnaRect(src.X, src.Y, src.Width, src.Height);
        }

        public static PointF3D ToPointF(Vector3 src)
        {
            return new PointF3D(src.X, src.Y, src.Z);
        }

        public static Vector3 ToVector3(PointF3D src)
        {
            return new Vector3(src.X, src.Y, src.Z);
        }

        public static Vector3 ToVector3(Point3D src)
        {
            return new Vector3(src.X, src.Y, src.Z);
        }
    }
}
