﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using System.Xml;
using System.Drawing;
using nft.core.geometry;
using nft.framework.drawing;
using System.IO;
using System.Drawing.Imaging;
using System.Diagnostics;

namespace nft.contributions.terrain {
    public class CtbSimpleGroundTexture : Contribution {
        protected static Dictionary<Color, SimpleGroundImgSet> registerdSet = new Dictionary<Color,SimpleGroundImgSet>();
        protected static string CacheDirRoot;
        public readonly Color BaseColor;
        protected SimpleGroundImgSet imgSet;

        public CtbSimpleGroundTexture(Plugin p, CtbGroundTextureFactory factory, XmlElement ctb)
            : base(p, ctb) {
            if (SimpleGroundImgSet.textureFactory == null) {
                SimpleGroundImgSet.textureFactory = factory;
            }
            string text = XmlUtil.GetSingleNodeText(ctb, "basecolor", null);
            BaseColor = ColorUtil.To12BitColor(StringParseUtil.CreateColor(text));
            CreateAndRegister(BaseColor, out imgSet);
        }

        //protected override InitCompleteEventHandler Initialize() {
        //    return null;
        //}

        //public ITexture GetTexture(Scaler scale, GroundPolygon poly, Point3DV hint) {
        //    return imgSet.GetTexture(scale, poly, hint);
        //}

        public ITerrainImageSet<GroundPolygon> TextureSet {
            get { return imgSet; }
        }

        protected static bool CreateAndRegister(Color basecol, out SimpleGroundImgSet imgSet) {
            if (registerdSet.ContainsKey(basecol)) {
                imgSet = registerdSet[basecol];
                return false; // already registerd
            }
            string subdir = string.Format("{0:X6}", basecol.ToArgb() & 0xffffff);
            string path = Path.Combine(SimpleGroundImgSet.textureFactory.DataDirectory, subdir);
            if (!Directory.Exists(path))
                Directory.CreateDirectory(path);
            imgSet = new SimpleGroundImgSet(path, basecol);
            registerdSet.Add(basecol, imgSet);
            return true;
        }

        public override void PrepareCacheData(bool forceUpdate) {
            SimpleGroundImgSet imgSet;
            if (!CreateAndRegister(BaseColor, out imgSet) && forceUpdate) {
                imgSet.DeleteCache();
            }
            imgSet.PrepareCache();
        }
    }

    public class SimpleGroundImgSet : AbstractGroundImgSet {
        protected internal static CtbGroundTextureFactory textureFactory;
        public readonly Color BaseColor;
        internal protected SimpleGroundImgSet(string imageCacheDir, Color basecol) 
            : base(imageCacheDir) {
            this.BaseColor = basecol;
        }

        protected override Bitmap CreateBitmap(Scaler sc, GroundPolygon polygon, Point3DV hint) {
            Point[] pts = polygon.GetVerticis(sc);
            Rectangle bounds = polygon.GetBounds(sc);
            Debug.Assert(bounds.Width * bounds.Height>0,"id="+polygon.ID);
            Bitmap bmp = new Bitmap(bounds.Width, bounds.Height, PixelFormat.Format24bppRgb);
            Color col = ColorUtil.GetDarker(BaseColor, polygon.Brightness);
            Bitmap img = textureFactory.GetTextureBitmap(sc, polygon.ID, hint) as Bitmap;
            using (Graphics g = Graphics.FromImage(bmp)) {
                using (Brush br = new SolidBrush(col)) {
                    g.FillRectangle(br, 0, 0, bounds.Width, bounds.Height);
                }
                if (img != null) {
                    img.MakeTransparent(CtbGroundTextureFactory.texFGColor);
                    g.DrawImage(img, 0, 0);
                    img.Dispose();
                }
            }
            return bmp;
        }
    }

}
