using System;
using System.Collections;
using System.Drawing;
using nft.core.geometry;
using nft.core.structure;
using nft.util;

namespace nft.core.game
{
	/// <summary>
	/// The map 
	/// </summary>
	public interface ITerrainMap : IDisposable
	{
		/// <summary>
		/// Size in grids.
        /// the value 'sz' is maximum value of height in the map.
		/// </summary>
        Size3D Size { get; }
		
		/// <summary>
        /// Returns height at specified grid location.
        /// the returned value shold be representative or average height of the area
        /// (x &lt;= X &lt; x+1, y &lt;= Y &lt; y+1)
		/// </summary>
        /// <param name="x">from 0 to Size.sx</param>
        /// <param name="y">from 0 to Size.sy</param>
		/// <param name="d"></param>
		/// <returns></returns>
		int Height(int x,int y);

        /// <summary>
        /// returns height at specified location.
        /// If <see cref="IsDetaledHeight">IsDetailedHeight</see> is false,
        /// this method returns the same value for each point contained in the same grid.
        /// If <see cref="IsDetaledHeight">IsDetailedHeight</see> is true,
        /// this method may returns different values even for the points in the same grid.
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns></returns>
        int DetailedHeight(double x, double y);

		/// <summary>
		/// true means that <see cref="Height">Height</see> will returns different value
		/// for the same location, according to direction 'd'.
		/// </summary>
		bool IsDetailedHeight { get; }
		// depth of water. positive value means the location is ander the water.
		int WaterDepth(int x, int y);
		// the array of rectangles each represent an district of map.
		//Rectangle[] Districts { get; set; }

        /// <summary>
        /// Height offset value which should be added to each height returned by Height(x,y) function.
        /// </summary>
        int HeightOffset { get; }

        bool IsCliffedBounds(Direction4 direction4, int x, int y);
    }

}
