using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using nft.ui.mainframe;
using System.Drawing.Drawing2D;
using System.Diagnostics;

namespace nft.framework.drawing
{
	/// <summary>
    /// LDrawableControl bv[U[Rg[B
    /// a UserControl which wraps valid DrawableControl.
	/// </summary>
	public class DrawablePanel : System.Windows.Forms.UserControl, IView
	{
        protected static readonly IViewDrawer nullDrawer = new NullDrawer();
        /// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		private DrawableControl canvas;
        private IViewDrawer drawer = nullDrawer;
        private Region dirtyRegion = null;

		public DrawablePanel()
		{
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();
			InitializeCanvas();            
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
                if (drawer != null) {
                    drawer.Dispose();
                }
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// a DrawableControl wrapped by this panel
		/// </summary>
        public DrawableControl Canvas { get { return canvas; } }

		/// <summary>
		/// Primary surface (Short cut to this.Canvas.Surface )
		/// </summary>
        public ISurface ScreenSurface { get { return canvas.Surface; } }

        /// <summary>
        /// ViewDrawer can be null because you can draw directory 
        /// by accessing this.Surface
        /// </summary>
        public IViewDrawer ViewDrawer {
            get { return (drawer == nullDrawer) ? null : drawer; }
            set {
                if (drawer != nullDrawer) {
                    if (drawer == value) return;
                    drawer.Dispose();
                }
                Point newPos;
                if (value != null) {
                    drawer = value;
                    drawer.Attach(this);
                    canvas.AutoScroll = true;
                    Size sz = drawer.ContentSize;
                    newPos = new Point(sz.Width >> 1, sz.Height >> 1);
                } else {
                    drawer = nullDrawer;
                    canvas.AutoScroll = false;
                    newPos = new Point();
                }
                SetScrollSizeForDrawer();
                ViewPosition = newPos;
                Invalidate();
            }
        }

        protected virtual void SetScrollSizeForDrawer(){
            canvas.AutoScrollMinSize = drawer.ContentSize;
            Size sz = drawer.ScrollUnit;
            if (sz.Height > 0) {
                canvas.VerticalScroll.SmallChange = sz.Height;
            }
            if (sz.Width > 0) {
                canvas.HorizontalScroll.SmallChange = sz.Width;
            }
        }

        /// <summary>
        /// topleft position of visible area in the view content
        /// </summary>
        public Point ViewPosition {
            get { 
                // Be aware that AutoScrollPosition returns negative coordination.
                Point pt = Canvas.AutoScrollPosition;
                // To avoid complexity, returns positive coordination.
                return new Point(-pt.X, -pt.Y);
            }
            set {
                Size sz = drawer.ContentSize - ClientSize;
                Point pt = ViewPosition;
                int nx = Math.Max(0, Math.Min(sz.Width, value.X));
                int ny = Math.Max(0, Math.Min(sz.Height, value.Y));
                if (pt.X != nx || pt.Y != ny) {
                    pt.X = nx;
                    pt.Y = ny;
                    // Be aware that we must set positive coordination for AutoScrollPosition,
                    // even though it returns negative coordination.
                    Canvas.AutoScrollPosition = pt;
                    Invalidate();
                }
            }
        }

        /// <summary>
        /// returns visible client rectangle of drawable control by screen coordination
        /// </summary>
        public Rectangle DrawableScreenRect {
            get {
                Rectangle rect = canvas.ClientRectangle;
                rect.Location = canvas.PointToScreen(rect.Location);
                return rect;
            }
        }

        #region IView o
        public Rectangle VisibleSourceRect {
            get {
                Rectangle cl = canvas.ClientRectangle;
                Size sz = drawer.ContentSize;
                cl.Location = ViewPosition;
                Rectangle rt = new Rectangle(cl.X, cl.Y,
                    Math.Min(sz.Width, cl.Width), Math.Min(sz.Height, cl.Height));
                return rt;
            }
        }

        public void NotifyUpdate(Region srcUpdated, bool callbackImmediately) {
            if (callbackImmediately) {
                using (Graphics g = CreateGraphics()) {
                    drawer.Draw(g, this, DrawableScreenRect, srcUpdated);
                }
            } else if (srcUpdated == null) {
                Rectangle rt = canvas.Bounds;
                Invalidate(rt); 
            } else {
                using (Graphics g = CreateGraphics()) {
                    Point pt = canvas.PointToScreen(ViewPosition);
                    pt = PointToClient(pt);
                    Region rgn = new Region(VisibleSourceRect);
                    Debug.Write("update:" + rgn.GetBounds(g));
                    rgn.Intersect(srcUpdated);
                    Matrix mtrx = new Matrix();
                    mtrx.Translate(pt.X, pt.Y);
                    rgn.Transform(mtrx);
                    Debug.WriteLine(", translate:" + rgn.GetBounds(g));
                    if (dirtyRegion != null) {
                        dirtyRegion.Union(rgn);
                    } else {
                        dirtyRegion = rgn;
                    }
                    Invalidate(rgn);
                }
            }
        }

        public void NotifyContentSizeChanged(Point newPos) {
            Size sz = canvas.AutoScrollMinSize;
            Point pt = canvas.AutoScrollPosition;
            SetScrollSizeForDrawer();
            ViewPosition = newPos;
            Invalidate();
        }

        #endregion

		#region R|[lg fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
            this.SuspendLayout();
            // 
            // DrawablePanel
            // 
            this.BackColor = System.Drawing.SystemColors.Window;
            this.Name = "DrawablePanel";
            this.Size = new System.Drawing.Size(88, 88);
            this.ResumeLayout(false);

		}
		#endregion
		private void InitializeCanvas() {
			this.SuspendLayout();
			try{
				this.canvas = GlobalModules.GraphicManager.CreateDrawableControl();
				// 
				// canvas
				// 
				this.canvas.Dock = System.Windows.Forms.DockStyle.Fill;
				this.canvas.Location = new System.Drawing.Point(0, 0);
				this.canvas.Name = "canvas";
				this.canvas.TabIndex = 0;
                this.canvas.BackColor = Color.Transparent; // Transparent can cause repaint wrapper panel.
                //this.canvas.Paint += new System.Windows.Forms.PaintEventHandler(this.DrawablePanel_Paint);
                // 
				// DrawablePanel
				// 
				this.Controls.Add(this.canvas);
			}catch {
			}
			this.ResumeLayout(false);
        }
        #region Control override
        protected override void OnPaintBackground(PaintEventArgs pevent) {
            if (drawer == nullDrawer) {
                base.OnPaintBackground(pevent);
            } else {
                // if client size is larger than content size, fill margin.
                Size sz = drawer.ContentSize;
                Point pt = ViewPosition;
                int cw = sz.Width + pt.X;
                int ch = sz.Height + pt.Y;
                Size sz2 = ClientSize;
                Brush br = null;
                if (sz2.Width > cw) {
                    cw = Math.Max(cw,0);
                    br = new SolidBrush(BackColor);
                    int w2 = sz2.Width - cw;
                    pevent.Graphics.FillRectangle(br, cw, 0, w2, sz2.Height);
                    sz2.Width -= w2;
                }
                if (sz2.Height > ch) {
                    ch = Math.Max(ch, 0);
                    if (br == null) {
                        br = new SolidBrush(BackColor);
                    }
                    pevent.Graphics.FillRectangle(br, 0, ch, sz2.Width, sz2.Height-ch);
                }
                if (br != null) {
                    br.Dispose();
                }
            }
        }

        protected override void OnPaint(PaintEventArgs pe) {
            if (drawer != nullDrawer) {
                Rectangle rect = Rectangle.Round(pe.Graphics.ClipBounds);
                rect.Intersect(canvas.Bounds);
                rect.Location = canvas.PointToScreen(rect.Location);
                if (dirtyRegion != null) {
                    drawer.Draw(pe.Graphics, this, rect, dirtyRegion);
                    dirtyRegion.Dispose();
                    dirtyRegion = null;
                } else {
                    Region rgn = new Region(VisibleSourceRect);
                    drawer.Draw(pe.Graphics, this, rect, rgn);
                    rgn.Dispose();
                }
            }
            base.OnPaint(pe);
        }
        #endregion
        #region NullDrawer class
        class NullDrawer : IViewDrawer {
            public void Attach(IView view) {
            }

            public void Detach(IView view) {
            }

            public void Draw(Graphics g, IView owner, Rectangle destArea, Region requestSrc) {
            }

            public Size ContentSize {
                get { return new Size(); }
            }

            public Size ScrollUnit {
                get { return new Size(); }
            }

            public void Dispose() {
            }
        }
        #endregion
    }
}
