﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using nft.util;
using nft.framework.plugin;
using nft.core.game;

namespace nft.ui.core {
    /// <summary>
    /// Base class for use in designer and wildcald treatment.
    /// </summary>
    public partial class MapGeneratorListBase : UserControl {
        public MapGeneratorListBase() {
            InitializeComponent();
        }

        protected virtual void comboList_SelectedIndexChanged(object sender, EventArgs e) {
        }
        
        public virtual IMapGenerator SelectedGenerator {
            get {
                return null;
            }
        }

        public virtual void UpdateView(ParamSet param) {
        }

        public virtual void RequestCurrentParams(ref ParamSet param) {
        }
    }

    public class MapGeneratorListPanel<T> : MapGeneratorListBase, IMapGeneSetupPanel
                                                where T : CtbMapGenerator {
        private ContribListControlHelper<T> helper;
        private IMapGeneSetupPanel setupUI;

        public MapGeneratorListPanel () {
            helper = new ContribListControlHelper<T>();
        }

        protected override void OnCreateControl() {
            base.OnCreateControl();
            CreateComboList();
            this.Disposed += new EventHandler(OnDisposed);
        }

        protected void OnDisposed(object sender, EventArgs e) {
            comboList.Items.Clear();
            setupUI = null;
            helper = null;
        }

        private void CreateComboList() {
            if (!DesignMode) {
                if (helper.Set(comboList, true) > 0) {
                    comboList.SelectedIndex = 0;
                }
            }
        }

        protected override void comboList_SelectedIndexChanged(object sender, EventArgs e) {
            CtbMapGenerator c = SelectedContribution;
            if (setupUI != null) {
                panelSetup.Controls.Remove(setupUI as Control);
                setupUI = null;
            }
            if (c == null) {
                txtDescript.Text = "";
            } else {
                txtDescript.Text = c.Description;
                if (c.IsSetupEnable) {
                    setupUI = c.GetSetupPanel();
                    panelSetup.Controls.Add(setupUI as Control);
                }
            }
        }

        public override IMapGenerator SelectedGenerator {
            get {
                T sel = SelectedContribution;
                if (sel != null) {
                    return sel.GetGenerator();
                } else {
                    return null;
                }
            }
        }

        public T SelectedContribution {
            get { return helper.GetContribution(comboList, comboList.SelectedIndex); }
            set { helper.SelectContribution(comboList, value); }
        }

        public void SelectContribByID(string id) {
            helper.SelectContribution(comboList, id);
        }


        #region IMapGeneSetupPanel メンバ

        public override void UpdateView(ParamSet param) {
            if (setupUI != null) {
                setupUI.UpdateView(param);
            }
        }

        public override void RequestCurrentParams(ref ParamSet param) {
            if (setupUI != null) {
                setupUI.RequestCurrentParams(ref param);
            }
        }

        #endregion
    }
}
