using System;
using nft.contributions.terrain;
using nft.impl.game;

namespace nft.core.geometry
{
	/// <summary>
	/// TerrainPiece ̊Tv̐łB
	/// </summary>
	public interface ITerrainPiece 
	{

        /// <summary>
		/// minimum height between the each vertices.
		/// </summary>
        int BaseHeight { get; set; }

        int MeanHeight { get; }

        int MaxHeight { get; }

        // Each bit shows occupation area by dividing each 4 corner into 4 angle.
        ushort OccupationMask { get; }

        // represents the slope shape above BaseHeight.
        TerrainPieceTemplate Template { get; }

		/// <summary>
		/// returns vertex height at specified direction.
		/// </summary>
		/// <param name="dir"></param>
		/// <returns></returns>
        int GetHeightAt(InterCardinalDirection dir);

		/// <summary>
		/// returns vertex offset height at specified direction.
		/// the value is offset from BaseHeight
		/// </summary>
		/// <param name="dir"></param>
		/// <returns></returns>
        int GetOffsetHeightAt(InterCardinalDirection dir);
	}
}
