using System;
using System.Diagnostics;
using System.Drawing;
using System.Xml;
using nft.framework.drawing;
//using DxVBLib;

namespace nft.drawing.ddraw7
{
	/// <summary>
	/// Draw an image in the picture as-is.
	/// </summary>
	[Serializable]
	public class DD7Sprite : ISprite {
		protected ITexture texture;
		//protected IPixelFilter filter;
		protected Point location;
        protected object tag;

		internal protected DD7Sprite(ITexture texture){
			this.texture = texture;
			location = new Point(0,0);
            tag = null;
		}

		#region ISprite o

        public bool HitTest(Point loc) {
			Point pt = new Point(loc.X - location.X, loc.Y - location.Y);
			return texture.HitTest(pt);
		}

		public ITexture Texture {
			get { return texture; }
			set { 
				Debug.Assert(value!=null);
				texture = value; 
			}
		}

		public Point Location {
			get { return location; }
			set { location = value;	}
		}


        public object Tag {
            get { return tag; }
            set { tag = value; }
        }

        /*
		public IPixelFilter Filter {
			get { return filter; }
			set { filter = value; }
		}
        */

		#endregion

        protected DrawParams Adjust(DrawParams orig) {
            DrawParams dp = orig.Clone();
            dp.Location.X += location.X;
            dp.Location.Y += location.Y;
            return dp;
        }

		#region IDrawable o
        public void Draw(DrawParams drawparam) {
            DrawParams dp = Adjust(drawparam);
            /*
            if(filter!=null)
                texture.DrawEx(dest, pt, scale, filter, frame);
            else
            */
            texture.Draw(dp);
        }

        public void DrawEx(DrawParams drawparam, ISurfaceDrawer drawer) {
            DrawParams dp = Adjust(drawparam);
            texture.DrawEx(dp, drawer);
        }

        public void DrawEx(DrawParams drawparam, IPixelFilter f) {
            DrawParams dp = Adjust(drawparam);
            texture.DrawEx(dp, f);
        }
        /*
        [Obsolete]
        public void Draw(ISurface dest, Point pos, Scaler scale, int frame) {
            Point pt = new Point(pos.X + location.X, pos.Y + location.Y);
            texture.Draw(dest, pt, scale, frame);
        }

        [Obsolete]
        public void DrawEx(ISurface dest, Point pos, Scaler scale, ISurfaceDrawer drawer, int frame) {
			Point pt = new Point(pos.X+location.X,pos.Y+location.Y);
            texture.DrawEx(dest, pt, scale, drawer, frame);
		}

        [Obsolete]
        public void DrawEx(ISurface dest, Point pos, Scaler scale, IPixelFilter f, int frame) {
			Point pt = new Point(pos.X+location.X,pos.Y+location.Y);
            texture.DrawEx(dest, pt, scale, f, frame);
		}
        */
		#endregion

		#region IDisposable o

		public void Dispose() {
			if(texture!=null){
				texture.Dispose();
				texture=null;
			}
		}

		#endregion
	}
}
