﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using nft.framework.drawing;
using nft.framework;
using System.Diagnostics;

namespace nft.debug {
    public partial class TestGDIDrawingForm : Form {
        protected ISurface bg;
        protected ISurface buffer;
        protected ISprite cursor;
        protected IGraphicManager graphic { get { return GlobalModules.GraphicManager; } }

        public TestGDIDrawingForm() {
            InitializeComponent();
            drawable.Canvas.Paint += new PaintEventHandler(Canvas_Paint);
            drawable.Canvas.MouseMove += new MouseEventHandler(TestGDIDrawingForm_MouseMove);
            prepareDrawing();
            Test t = new Test(new Point(123, 456));
            Point[] p = t.V;
            p[0] = new Point(789,111);
            p[1].X = 999;
            Debug.WriteLine(t.V[0]);
            Debug.WriteLine(t.V[1]);
        }

        void Canvas_Paint(object sender, PaintEventArgs e) {
            drawSceneImage();
        }

        private void prepareDrawing() {
            string path = Path.Combine(Directories.AppBaseDir, @"res\grid_sample.gif");
            bg = graphic.CreateSurfaceFromBitmap(new Bitmap(path));
            buffer = graphic.CreateOffscreenSurface(drawable.Canvas.Size);
            //drawable.Canvas.MouseMove += new MouseEventHandler(drawableControl1_MouseMove);
            QuaterViewRect rect = new QuaterViewRect(16, 32, 16, 64, 32);
            ITexture tex = PrimitiveTextrueFactory.CreateCellBoundsTexture(rect, this.Font, "テスト", Color.Green);
            cursor = GlobalModules.GraphicManager.CreateSprite(tex);
        }

        private void drawSceneImage() {
            if (bg != null) {
                DrawParams param = new DrawParams(drawable.ScreenSurface, drawable.PointToScreen(new Point(0)));
                bg.Draw(param);
                drawable.ScreenSurface.ColorKey = Color.FromArgb(0x00, 0x72, 0xbc);
                Point pt = MousePosition;
                pt.X -= 24;
                pt.Y -= 24;
                param.Location = pt;
                cursor.Draw(param);
                //drawable.Surface.
            }
        }

        private void TestGDIDrawingForm_MouseMove(object sender, MouseEventArgs e) {
            drawSceneImage();
        }

    }

    class Test {
        private Point[] v;
        public Test(Point p) {
            v = new Point[]{ p, new Point(0,0)};
        }

        public Point[] V {
            get { return (Point[])v.Clone(); }
        }
    }
}
