# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#

__version__ = '1.1'

import sys
from ftg.flow_table import FlowTable
from ftg.flow_priority import FlowPriority
from ftg.flow_entry import FlowEntry
from ftg.config.description_list import DescriptionList
from ftg.utils.common import CommonUtils


class BaseFormatter(object):
    HEADER_FORMAT = ""
    FOOTER_FORMAT = ""
    formatter_name = "base"

    def __init__(self, util=CommonUtils(), title=""):
        self._tables = []
        self.util = util
        self._title = title
        self._description_list = {}
        self._description_list_file = ""
        self._groupid = 1
        self.output_summary = True
        self.output_resubmit_loop = True
        self.output_target_tables = []
        self.util.debug_out(self.formatter_name + " formatter initialized")

    def format(self):
        return "FORMATTED STRINGS"

    def get_header(self):
        header = self.HEADER_FORMAT
        return header

    def get_footer(self):
        footer = self.FOOTER_FORMAT
        return footer

    def set_tables(self, tables):
        self._tables = tables

    def set_description_list_file(self, description_list_file):
        self._description_list_file = description_list_file
        self.util.debug_out("SET DESCRIPTION_LIST: \'" + self._description_list_file + "\'")

    def load_description_list(self):
        self._description_list = DescriptionList(self.util, self._description_list_file)
        read_config_result = self._description_list.parse_config()
        if read_config_result == DescriptionList.CONFIG_FILE_READ_SUCCESS:
            self.util.debug_out("LOAD DESCRIPTION_LIST: \'" + self._description_list_file + "\' SUCCESS")
        elif read_config_result == DescriptionList.CONFIG_FILE_READ_FAILED:
            self.util.error_out("LOAD DESCRIPTION_LIST: \'" + self._description_list_file + "\' FAILED")
            sys.exit(1)

    def get_table_descriptions(self):
        if self._description_list == {}:
            return {}

        table_descriptions = self._description_list.get_items_as_dict("table")
        if table_descriptions is not None:
            self.util.debug_out("GET TABLE_DESCRIPTIONS: SUCCESS")
        elif table_descriptions == DescriptionList.CONFIG_FILE_READ_FAILED:
            self.util.error_out("GET TABLE_DESCRIPTIONS: FAILED")
        return table_descriptions

    def get_table_description_as_string(self, table_no):
        table_description = self.get_table_descriptions()
        if table_description is None or table_description == {}:
            return ""
        
        if table_description.has_key("TABLE_" + str(table_no)):
            return table_description["TABLE_" + str(table_no)]
        else:
            return ""

    def set_output_target_tables(self, output_target_tables):
        if output_target_tables is not None:
            self.output_target_tables = output_target_tables

    def set_output_summary(self, output_summary):
        self.output_summary = output_summary

    def set_output_resubmit_loop(self, output_resubmit_loop):
        self.output_resubmit_loop = output_resubmit_loop
