﻿/*
 *	Fugashi Project
 *
 *	This software is distributed under a BSD-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace Fugashi
{
    public partial class BitSwitches4 : UserControl
    {
        #region fields
        private int startBit;
        #endregion

        #region constructor

        public BitSwitches4()
        {
            InitializeComponent();
        }
        #endregion

        #region properties
        [CategoryAttribute("Data")]
        [DefaultValue(typeof(int), "-1")]
        public int StartBit
        {
            get
            {
                return startBit;
            }
            set
            {
                startBit = value;
                Coordinate();
            }
        }

        public BitSwitch B0
        {
            get 
            {
                return b0;
            }
        }

        public BitSwitch B1
        {
            get
            {
                return b1;
            }
        }

        public BitSwitch B2
        {
            get
            {
                return b2;
            }
        }

        public BitSwitch B3
        {
            get
            {
                return b3;
            }
        }
        #endregion

        #region private methods
        private void Coordinate()
        {
            int y = startBit < 32 ? label.Size.Height : 0;
            table.Location = new Point(table.Location.X, y);
            int labelY = startBit < 32 ? 0 : b0.Size.Height;
            label.Location = new Point(label.Location.X, labelY);
            label.Text = startBit.ToString();
            PerformAutoScale();
            PerformLayout();
        }

        private void BitSwitches4_SizeChanged(object sender, EventArgs e)
        {
            table.Width = Width - Margin.Left - Margin.Right;
            table.Height = Height - label.Height - Margin.Bottom - Margin.Top;
            int y = startBit < 32 ? label.Size.Height : 0;
            table.Location = new Point(table.Location.X, y);
        }
        #endregion
    }
}
