#!/usr/bin/perl

use strict;
use Fcntl;
use GDBM_File;
use URI::Escape;
use Encode;

my $file = '/var/www/lib/wiliki/wikidata.dbm';
my %db;
tie (%db, 'GDBM_File' , $file, O_RDONLY, 640) or die;

foreach my $k (sort keys %db) {
	next if $k eq ' %recent-changes';
	my $f = uri_escape($k);
	open(OF, "> $f") or die "can not open $f";
	my $o = $db{$k};
	$o =~ s/^\([^)]+\)//;
	print OF $o;
}

untie(%db);

1;
