package com.shin1ogawa.entity;

import java.io.Serializable;

import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;

/**
 * Keyの値(long)を自前で設定する必要があるEntity.
 * <p>
 * {@link Key#getId()}を使ってコード値を取得できる。
 * </p>
 * 
 * @author shin1ogawa
 */
@SuppressWarnings("serial")
@PersistenceCapable(identityType = IdentityType.APPLICATION)
public class OtherB implements Serializable {
	@PrimaryKey
	@Persistent
	private Key key;

	@Persistent
	private String value;

	public Key getKey() {
		return key;
	}

	public void setKey(Key key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public OtherB setValue(String value) {
		this.value = value;
		return this;
	}

	/**
	 * 指定された値を利用したKeyを作成し、永続化する。
	 * <p>
	 * 重複していた場合はエラーとする。
	 * </p>
	 * 
	 * @param pm
	 * @param code
	 * @return
	 */
	public OtherB save(PersistenceManager pm, long code) {
		String name = "code=" + String.valueOf(code);
		this.key = KeyFactory.createKey(OtherB.class.getSimpleName(), name);
		try {
			OtherB check = pm.getObjectById(OtherB.class, name);
			throw new RuntimeException(check.toString());
		} catch (JDOObjectNotFoundException e) {
			return pm.makePersistent(this);
		}
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
