package com.shin1ogawa.entity;

import javax.jdo.PersistenceManager;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.junit.Test;

import com.shin1ogawa.AbstractRelasionShipTest;

public class OtherBTest extends AbstractRelasionShipTest {

	@Test
	public void test01() {
		PersistenceManager pm = getFactory().getPersistenceManager();
		OtherB entity1 = new OtherB().setValue("あいうえお").save(pm, 1);
		OtherB entity2 = new OtherB().setValue("かきくけこ").save(pm, 2);
		pm.close();

		pm = getFactory().getPersistenceManager();
		System.out.println(ToStringBuilder.reflectionToString(pm.getObjectById(
				OtherB.class, entity1.getKey())));
		System.out.println(ToStringBuilder.reflectionToString(pm.getObjectById(
				OtherB.class, entity2.getKey())));
		pm.close();
	}

	@Test(expected = RuntimeException.class)
	public void test02() {
		PersistenceManager pm = getFactory().getPersistenceManager();
		try {
			new OtherB().setValue("あいうえお").save(pm, 1);
			new OtherB().setValue("かきくけこ").save(pm, 1);
		} finally {
			pm.close();
		}
	}
}
