/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionStackImpl
implements TransactionStack {
    private final ThreadLocalTransactionStack stack;

    public TransactionStackImpl() {
        this(new ThreadLocalTransactionStack.StaticMember());
    }

    TransactionStackImpl(ThreadLocalTransactionStack stack) {
        this.stack = stack;
    }

    @Override
    public void push(Transaction txn) {
        this.getStack().addFirst(txn);
    }

    @Override
    public Transaction pop() {
        try {
            return this.getStack().removeFirst();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void remove(Transaction txn) {
        if (!this.getStack().remove(txn)) {
            throw new IllegalStateException("Attempted to deregister a transaction that is not currently registered.");
        }
    }

    @Override
    public Transaction peek() {
        try {
            return this.getStack().getFirst();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Transaction peek(Transaction returnedIfNoTxn) {
        LinkedList<Transaction> stack = this.getStack();
        Transaction txn = stack.isEmpty() ? null : this.getStack().peek();
        return txn == null ? returnedIfNoTxn : txn;
    }

    @Override
    public Collection<Transaction> getAll() {
        return new ArrayList<Transaction>(this.getStack());
    }

    LinkedList<Transaction> getStack() {
        return this.stack.get();
    }

    @Override
    public void clearAll() {
        this.getStack().clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ThreadLocalTransactionStack {
        public LinkedList<Transaction> get();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class StaticMember
        implements ThreadLocalTransactionStack {
            private static final ThreadLocal<LinkedList<Transaction>> STACK = new ThreadLocal<LinkedList<Transaction>>(){

                @Override
                protected LinkedList<Transaction> initialValue() {
                    return new LinkedList<Transaction>();
                }
            };

            @Override
            public LinkedList<Transaction> get() {
                return STACK.get();
            }
        }
    }
}

