/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.ReferenceType;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.ReferenceCache;
import com.google.common.annotations.GoogleInternal;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public abstract class ExpiringReferenceCache<K, V>
extends ReferenceCache<K, V> {
    private static final long serialVersionUID = 0L;

    public ExpiringReferenceCache(long expirationTimeInMs) {
        this(ReferenceType.STRONG, ReferenceType.STRONG, expirationTimeInMs);
    }

    public ExpiringReferenceCache(ReferenceType keyReferenceType, ReferenceType valueReferenceType, long expirationTimeInMs) {
        super(new MapMaker().expiration(expirationTimeInMs, TimeUnit.MILLISECONDS), keyReferenceType, valueReferenceType);
    }

    public static <K, V> ExpiringReferenceCache<K, V> of(ReferenceType keyReferenceType, ReferenceType valueReferenceType, long expirationTimeInMs, final Function<? super K, ? extends V> function) {
        Preconditions.checkNotNull(function);
        return new ExpiringReferenceCache<K, V>(keyReferenceType, valueReferenceType, expirationTimeInMs){
            private static final long serialVersionUID = 0L;

            @Override
            protected V create(K key) {
                return function.apply(key);
            }
        };
    }

    public static <K, V> ExpiringReferenceCache<K, V> of(ReferenceType valueReferenceType, long expirationTimeInMs, Function<? super K, ? extends V> function) {
        return ExpiringReferenceCache.of(ReferenceType.STRONG, valueReferenceType, expirationTimeInMs, function);
    }

    public static <K, V> ExpiringReferenceCache<K, V> of(long expirationTimeInMs, Function<? super K, ? extends V> function) {
        return ExpiringReferenceCache.of(ReferenceType.STRONG, expirationTimeInMs, function);
    }
}

