/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.apphosting.api.ApiBasePb;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.ssl.SslSecurityLevel;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class DatastorePb {
    private DatastorePb() {
    }

    public static final class DatastoreService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("DatastoreService", params));
            }
        };

        private DatastoreService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("DatastoreService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("DatastoreService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            DatastoreService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Get", (ProtocolMessage)new GetRequest(), (ProtocolMessage)new GetResponse(), null, config.Get_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.get(rpc, (GetRequest)rpc.internalRequest(), (GetResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Put", (ProtocolMessage)new PutRequest(), (ProtocolMessage)new PutResponse(), null, config.Put_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.put(rpc, (PutRequest)rpc.internalRequest(), (PutResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Delete", (ProtocolMessage)new DeleteRequest(), (ProtocolMessage)new DeleteResponse(), null, config.Delete_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.delete(rpc, (DeleteRequest)rpc.internalRequest(), (DeleteResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "RunQuery", (ProtocolMessage)new Query(), (ProtocolMessage)new QueryResult(), null, config.RunQuery_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.runQuery(rpc, (Query)rpc.internalRequest(), (QueryResult)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Next", (ProtocolMessage)new NextRequest(), (ProtocolMessage)new QueryResult(), null, config.Next_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.next(rpc, (NextRequest)rpc.internalRequest(), (QueryResult)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Count", (ProtocolMessage)new Query(), (ProtocolMessage)new ApiBasePb.Integer64Proto(), null, config.Count_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.count(rpc, (Query)rpc.internalRequest(), (ApiBasePb.Integer64Proto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Explain", (ProtocolMessage)new Query(), (ProtocolMessage)new QueryExplanation(), null, config.Explain_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.explain(rpc, (Query)rpc.internalRequest(), (QueryExplanation)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteCursor", (ProtocolMessage)new Cursor(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.DeleteCursor_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.deleteCursor(rpc, (Cursor)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "BeginTransaction", (ProtocolMessage)new ApiBasePb.VoidProto(), (ProtocolMessage)new Transaction(), null, config.BeginTransaction_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.beginTransaction(rpc, (ApiBasePb.VoidProto)rpc.internalRequest(), (Transaction)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Commit", (ProtocolMessage)new Transaction(), (ProtocolMessage)new CommitResponse(), null, config.Commit_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.commit(rpc, (Transaction)rpc.internalRequest(), (CommitResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "Rollback", (ProtocolMessage)new Transaction(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.Rollback_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.rollback(rpc, (Transaction)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "GetSchema", (ProtocolMessage)new ApiBasePb.StringProto(), (ProtocolMessage)new Schema(), null, config.GetSchema_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.getSchema(rpc, (ApiBasePb.StringProto)rpc.internalRequest(), (Schema)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "CreateIndex", (ProtocolMessage)new OnestoreEntity.CompositeIndex(), (ProtocolMessage)new ApiBasePb.Integer64Proto(), null, config.CreateIndex_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.createIndex(rpc, (OnestoreEntity.CompositeIndex)rpc.internalRequest(), (ApiBasePb.Integer64Proto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "UpdateIndex", (ProtocolMessage)new OnestoreEntity.CompositeIndex(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.UpdateIndex_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.updateIndex(rpc, (OnestoreEntity.CompositeIndex)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "GetIndices", (ProtocolMessage)new ApiBasePb.StringProto(), (ProtocolMessage)new CompositeIndices(), null, config.GetIndices_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.getIndices(rpc, (ApiBasePb.StringProto)rpc.internalRequest(), (CompositeIndices)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteIndex", (ProtocolMessage)new OnestoreEntity.CompositeIndex(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.DeleteIndex_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.deleteIndex(rpc, (OnestoreEntity.CompositeIndex)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return DatastoreService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            DatastoreService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "Get", (ProtocolMessage)new GetRequest(), (ProtocolMessage)new GetResponse(), null, config.Get_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public GetResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.get(rpc, (GetRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Put", (ProtocolMessage)new PutRequest(), (ProtocolMessage)new PutResponse(), null, config.Put_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public PutResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.put(rpc, (PutRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Delete", (ProtocolMessage)new DeleteRequest(), (ProtocolMessage)new DeleteResponse(), null, config.Delete_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public DeleteResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.delete(rpc, (DeleteRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "RunQuery", (ProtocolMessage)new Query(), (ProtocolMessage)new QueryResult(), null, config.RunQuery_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public QueryResult handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.runQuery(rpc, (Query)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Next", (ProtocolMessage)new NextRequest(), (ProtocolMessage)new QueryResult(), null, config.Next_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public QueryResult handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.next(rpc, (NextRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Count", (ProtocolMessage)new Query(), (ProtocolMessage)new ApiBasePb.Integer64Proto(), null, config.Count_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.Integer64Proto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.count(rpc, (Query)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Explain", (ProtocolMessage)new Query(), (ProtocolMessage)new QueryExplanation(), null, config.Explain_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public QueryExplanation handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.explain(rpc, (Query)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteCursor", (ProtocolMessage)new Cursor(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.DeleteCursor_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.deleteCursor(rpc, (Cursor)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "BeginTransaction", (ProtocolMessage)new ApiBasePb.VoidProto(), (ProtocolMessage)new Transaction(), null, config.BeginTransaction_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public Transaction handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.beginTransaction(rpc, (ApiBasePb.VoidProto)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Commit", (ProtocolMessage)new Transaction(), (ProtocolMessage)new CommitResponse(), null, config.Commit_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public CommitResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.commit(rpc, (Transaction)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "Rollback", (ProtocolMessage)new Transaction(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.Rollback_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.rollback(rpc, (Transaction)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "GetSchema", (ProtocolMessage)new ApiBasePb.StringProto(), (ProtocolMessage)new Schema(), null, config.GetSchema_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public Schema handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.getSchema(rpc, (ApiBasePb.StringProto)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "CreateIndex", (ProtocolMessage)new OnestoreEntity.CompositeIndex(), (ProtocolMessage)new ApiBasePb.Integer64Proto(), null, config.CreateIndex_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.Integer64Proto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.createIndex(rpc, (OnestoreEntity.CompositeIndex)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "UpdateIndex", (ProtocolMessage)new OnestoreEntity.CompositeIndex(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.UpdateIndex_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.updateIndex(rpc, (OnestoreEntity.CompositeIndex)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "GetIndices", (ProtocolMessage)new ApiBasePb.StringProto(), (ProtocolMessage)new CompositeIndices(), null, config.GetIndices_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public CompositeIndices handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.getIndices(rpc, (ApiBasePb.StringProto)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "DeleteIndex", (ProtocolMessage)new OnestoreEntity.CompositeIndex(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.DeleteIndex_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.deleteIndex(rpc, (OnestoreEntity.CompositeIndex)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return DatastoreService.exportBlockingService(impl, registry);
                }
            };
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("DatastoreService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters Get_parameters_ = new RpcServerParameters();
            final RpcServerParameters Put_parameters_ = new RpcServerParameters();
            final RpcServerParameters Delete_parameters_ = new RpcServerParameters();
            final RpcServerParameters RunQuery_parameters_ = new RpcServerParameters();
            final RpcServerParameters Next_parameters_ = new RpcServerParameters();
            final RpcServerParameters Count_parameters_ = new RpcServerParameters();
            final RpcServerParameters Explain_parameters_ = new RpcServerParameters();
            final RpcServerParameters DeleteCursor_parameters_ = new RpcServerParameters();
            final RpcServerParameters BeginTransaction_parameters_ = new RpcServerParameters();
            final RpcServerParameters Commit_parameters_ = new RpcServerParameters();
            final RpcServerParameters Rollback_parameters_ = new RpcServerParameters();
            final RpcServerParameters GetSchema_parameters_ = new RpcServerParameters();
            final RpcServerParameters CreateIndex_parameters_ = new RpcServerParameters();
            final RpcServerParameters UpdateIndex_parameters_ = new RpcServerParameters();
            final RpcServerParameters GetIndices_parameters_ = new RpcServerParameters();
            final RpcServerParameters DeleteIndex_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("DatastoreService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_Get(t);
                this.setRpcRunner_Put(t);
                this.setRpcRunner_Delete(t);
                this.setRpcRunner_RunQuery(t);
                this.setRpcRunner_Next(t);
                this.setRpcRunner_Count(t);
                this.setRpcRunner_Explain(t);
                this.setRpcRunner_DeleteCursor(t);
                this.setRpcRunner_BeginTransaction(t);
                this.setRpcRunner_Commit(t);
                this.setRpcRunner_Rollback(t);
                this.setRpcRunner_GetSchema(t);
                this.setRpcRunner_CreateIndex(t);
                this.setRpcRunner_UpdateIndex(t);
                this.setRpcRunner_GetIndices(t);
                this.setRpcRunner_DeleteIndex(t);
            }

            public void setRpcRunner_Get(Executor t) {
                this.Get_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Put(Executor t) {
                this.Put_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Delete(Executor t) {
                this.Delete_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_RunQuery(Executor t) {
                this.RunQuery_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Next(Executor t) {
                this.Next_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Count(Executor t) {
                this.Count_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Explain(Executor t) {
                this.Explain_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_DeleteCursor(Executor t) {
                this.DeleteCursor_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_BeginTransaction(Executor t) {
                this.BeginTransaction_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Commit(Executor t) {
                this.Commit_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_Rollback(Executor t) {
                this.Rollback_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_GetSchema(Executor t) {
                this.GetSchema_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_CreateIndex(Executor t) {
                this.CreateIndex_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_UpdateIndex(Executor t) {
                this.UpdateIndex_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_GetIndices(Executor t) {
                this.GetIndices_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_DeleteIndex(Executor t) {
                this.DeleteIndex_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_Get(int t) {
                this.Get_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Put(int t) {
                this.Put_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Delete(int t) {
                this.Delete_parameters_.setServerLogging(t);
            }

            public void setServerLogging_RunQuery(int t) {
                this.RunQuery_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Next(int t) {
                this.Next_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Count(int t) {
                this.Count_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Explain(int t) {
                this.Explain_parameters_.setServerLogging(t);
            }

            public void setServerLogging_DeleteCursor(int t) {
                this.DeleteCursor_parameters_.setServerLogging(t);
            }

            public void setServerLogging_BeginTransaction(int t) {
                this.BeginTransaction_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Commit(int t) {
                this.Commit_parameters_.setServerLogging(t);
            }

            public void setServerLogging_Rollback(int t) {
                this.Rollback_parameters_.setServerLogging(t);
            }

            public void setServerLogging_GetSchema(int t) {
                this.GetSchema_parameters_.setServerLogging(t);
            }

            public void setServerLogging_CreateIndex(int t) {
                this.CreateIndex_parameters_.setServerLogging(t);
            }

            public void setServerLogging_UpdateIndex(int t) {
                this.UpdateIndex_parameters_.setServerLogging(t);
            }

            public void setServerLogging_GetIndices(int t) {
                this.GetIndices_parameters_.setServerLogging(t);
            }

            public void setServerLogging_DeleteIndex(int t) {
                this.DeleteIndex_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_Get(SslSecurityLevel t) {
                this.Get_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Put(SslSecurityLevel t) {
                this.Put_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Delete(SslSecurityLevel t) {
                this.Delete_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_RunQuery(SslSecurityLevel t) {
                this.RunQuery_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Next(SslSecurityLevel t) {
                this.Next_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Count(SslSecurityLevel t) {
                this.Count_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Explain(SslSecurityLevel t) {
                this.Explain_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_DeleteCursor(SslSecurityLevel t) {
                this.DeleteCursor_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_BeginTransaction(SslSecurityLevel t) {
                this.BeginTransaction_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Commit(SslSecurityLevel t) {
                this.Commit_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_Rollback(SslSecurityLevel t) {
                this.Rollback_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_GetSchema(SslSecurityLevel t) {
                this.GetSchema_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_CreateIndex(SslSecurityLevel t) {
                this.CreateIndex_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_UpdateIndex(SslSecurityLevel t) {
                this.UpdateIndex_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_GetIndices(SslSecurityLevel t) {
                this.GetIndices_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_DeleteIndex(SslSecurityLevel t) {
                this.DeleteIndex_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_Get(RpcCancelCallback t) {
                this.Get_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Put(RpcCancelCallback t) {
                this.Put_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Delete(RpcCancelCallback t) {
                this.Delete_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_RunQuery(RpcCancelCallback t) {
                this.RunQuery_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Next(RpcCancelCallback t) {
                this.Next_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Count(RpcCancelCallback t) {
                this.Count_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Explain(RpcCancelCallback t) {
                this.Explain_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_DeleteCursor(RpcCancelCallback t) {
                this.DeleteCursor_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_BeginTransaction(RpcCancelCallback t) {
                this.BeginTransaction_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Commit(RpcCancelCallback t) {
                this.Commit_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_Rollback(RpcCancelCallback t) {
                this.Rollback_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_GetSchema(RpcCancelCallback t) {
                this.GetSchema_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_CreateIndex(RpcCancelCallback t) {
                this.CreateIndex_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_UpdateIndex(RpcCancelCallback t) {
                this.UpdateIndex_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_GetIndices(RpcCancelCallback t) {
                this.GetIndices_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_DeleteIndex(RpcCancelCallback t) {
                this.DeleteIndex_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void get(RPC rpc, GetRequest req, GetResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Get_method_, "Get", req, reply, cb, this.Get_parameters_);
            }

            public void put(RPC rpc, PutRequest req, PutResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Put_method_, "Put", req, reply, cb, this.Put_parameters_);
            }

            public void delete(RPC rpc, DeleteRequest req, DeleteResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Delete_method_, "Delete", req, reply, cb, this.Delete_parameters_);
            }

            public void runQuery(RPC rpc, Query req, QueryResult reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.RunQuery_method_, "RunQuery", req, reply, cb, this.RunQuery_parameters_);
            }

            public void next(RPC rpc, NextRequest req, QueryResult reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Next_method_, "Next", req, reply, cb, this.Next_parameters_);
            }

            public void count(RPC rpc, Query req, ApiBasePb.Integer64Proto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Count_method_, "Count", req, reply, cb, this.Count_parameters_);
            }

            public void explain(RPC rpc, Query req, QueryExplanation reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Explain_method_, "Explain", req, reply, cb, this.Explain_parameters_);
            }

            public void deleteCursor(RPC rpc, Cursor req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.DeleteCursor_method_, "DeleteCursor", req, reply, cb, this.DeleteCursor_parameters_);
            }

            public void beginTransaction(RPC rpc, ApiBasePb.VoidProto req, Transaction reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.BeginTransaction_method_, "BeginTransaction", req, reply, cb, this.BeginTransaction_parameters_);
            }

            public void commit(RPC rpc, Transaction req, CommitResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Commit_method_, "Commit", req, reply, cb, this.Commit_parameters_);
            }

            public void rollback(RPC rpc, Transaction req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.Rollback_method_, "Rollback", req, reply, cb, this.Rollback_parameters_);
            }

            public void getSchema(RPC rpc, ApiBasePb.StringProto req, Schema reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.GetSchema_method_, "GetSchema", req, reply, cb, this.GetSchema_parameters_);
            }

            public void createIndex(RPC rpc, OnestoreEntity.CompositeIndex req, ApiBasePb.Integer64Proto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.CreateIndex_method_, "CreateIndex", req, reply, cb, this.CreateIndex_parameters_);
            }

            public void updateIndex(RPC rpc, OnestoreEntity.CompositeIndex req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.UpdateIndex_method_, "UpdateIndex", req, reply, cb, this.UpdateIndex_parameters_);
            }

            public void getIndices(RPC rpc, ApiBasePb.StringProto req, CompositeIndices reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.GetIndices_method_, "GetIndices", req, reply, cb, this.GetIndices_parameters_);
            }

            public void deleteIndex(RPC rpc, OnestoreEntity.CompositeIndex req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.DeleteIndex_method_, "DeleteIndex", req, reply, cb, this.DeleteIndex_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void get(RPC var1, GetRequest var2, GetResponse var3, RpcCallback var4);

            public void put(RPC var1, PutRequest var2, PutResponse var3, RpcCallback var4);

            public void delete(RPC var1, DeleteRequest var2, DeleteResponse var3, RpcCallback var4);

            public void runQuery(RPC var1, Query var2, QueryResult var3, RpcCallback var4);

            public void next(RPC var1, NextRequest var2, QueryResult var3, RpcCallback var4);

            public void count(RPC var1, Query var2, ApiBasePb.Integer64Proto var3, RpcCallback var4);

            public void explain(RPC var1, Query var2, QueryExplanation var3, RpcCallback var4);

            public void deleteCursor(RPC var1, Cursor var2, ApiBasePb.VoidProto var3, RpcCallback var4);

            public void beginTransaction(RPC var1, ApiBasePb.VoidProto var2, Transaction var3, RpcCallback var4);

            public void commit(RPC var1, Transaction var2, CommitResponse var3, RpcCallback var4);

            public void rollback(RPC var1, Transaction var2, ApiBasePb.VoidProto var3, RpcCallback var4);

            public void getSchema(RPC var1, ApiBasePb.StringProto var2, Schema var3, RpcCallback var4);

            public void createIndex(RPC var1, OnestoreEntity.CompositeIndex var2, ApiBasePb.Integer64Proto var3, RpcCallback var4);

            public void updateIndex(RPC var1, OnestoreEntity.CompositeIndex var2, ApiBasePb.VoidProto var3, RpcCallback var4);

            public void getIndices(RPC var1, ApiBasePb.StringProto var2, CompositeIndices var3, RpcCallback var4);

            public void deleteIndex(RPC var1, OnestoreEntity.CompositeIndex var2, ApiBasePb.VoidProto var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public GetResponse get(RPC rpc, GetRequest req) throws RpcException {
                GetResponse reply = new GetResponse();
                this.startBlockingRpc(rpc, this.Get_method_, "Get", req, reply, this.Get_parameters_);
                return reply;
            }

            public PutResponse put(RPC rpc, PutRequest req) throws RpcException {
                PutResponse reply = new PutResponse();
                this.startBlockingRpc(rpc, this.Put_method_, "Put", req, reply, this.Put_parameters_);
                return reply;
            }

            public DeleteResponse delete(RPC rpc, DeleteRequest req) throws RpcException {
                DeleteResponse reply = new DeleteResponse();
                this.startBlockingRpc(rpc, this.Delete_method_, "Delete", req, reply, this.Delete_parameters_);
                return reply;
            }

            public QueryResult runQuery(RPC rpc, Query req) throws RpcException {
                QueryResult reply = new QueryResult();
                this.startBlockingRpc(rpc, this.RunQuery_method_, "RunQuery", req, reply, this.RunQuery_parameters_);
                return reply;
            }

            public QueryResult next(RPC rpc, NextRequest req) throws RpcException {
                QueryResult reply = new QueryResult();
                this.startBlockingRpc(rpc, this.Next_method_, "Next", req, reply, this.Next_parameters_);
                return reply;
            }

            public ApiBasePb.Integer64Proto count(RPC rpc, Query req) throws RpcException {
                ApiBasePb.Integer64Proto reply = new ApiBasePb.Integer64Proto();
                this.startBlockingRpc(rpc, this.Count_method_, "Count", req, reply, this.Count_parameters_);
                return reply;
            }

            public QueryExplanation explain(RPC rpc, Query req) throws RpcException {
                QueryExplanation reply = new QueryExplanation();
                this.startBlockingRpc(rpc, this.Explain_method_, "Explain", req, reply, this.Explain_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto deleteCursor(RPC rpc, Cursor req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.DeleteCursor_method_, "DeleteCursor", req, reply, this.DeleteCursor_parameters_);
                return reply;
            }

            public Transaction beginTransaction(RPC rpc, ApiBasePb.VoidProto req) throws RpcException {
                Transaction reply = new Transaction();
                this.startBlockingRpc(rpc, this.BeginTransaction_method_, "BeginTransaction", req, reply, this.BeginTransaction_parameters_);
                return reply;
            }

            public CommitResponse commit(RPC rpc, Transaction req) throws RpcException {
                CommitResponse reply = new CommitResponse();
                this.startBlockingRpc(rpc, this.Commit_method_, "Commit", req, reply, this.Commit_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto rollback(RPC rpc, Transaction req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.Rollback_method_, "Rollback", req, reply, this.Rollback_parameters_);
                return reply;
            }

            public Schema getSchema(RPC rpc, ApiBasePb.StringProto req) throws RpcException {
                Schema reply = new Schema();
                this.startBlockingRpc(rpc, this.GetSchema_method_, "GetSchema", req, reply, this.GetSchema_parameters_);
                return reply;
            }

            public ApiBasePb.Integer64Proto createIndex(RPC rpc, OnestoreEntity.CompositeIndex req) throws RpcException {
                ApiBasePb.Integer64Proto reply = new ApiBasePb.Integer64Proto();
                this.startBlockingRpc(rpc, this.CreateIndex_method_, "CreateIndex", req, reply, this.CreateIndex_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto updateIndex(RPC rpc, OnestoreEntity.CompositeIndex req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.UpdateIndex_method_, "UpdateIndex", req, reply, this.UpdateIndex_parameters_);
                return reply;
            }

            public CompositeIndices getIndices(RPC rpc, ApiBasePb.StringProto req) throws RpcException {
                CompositeIndices reply = new CompositeIndices();
                this.startBlockingRpc(rpc, this.GetIndices_method_, "GetIndices", req, reply, this.GetIndices_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto deleteIndex(RPC rpc, OnestoreEntity.CompositeIndex req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.DeleteIndex_method_, "DeleteIndex", req, reply, this.DeleteIndex_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public GetResponse get(RPC var1, GetRequest var2) throws RpcException;

            public PutResponse put(RPC var1, PutRequest var2) throws RpcException;

            public DeleteResponse delete(RPC var1, DeleteRequest var2) throws RpcException;

            public QueryResult runQuery(RPC var1, Query var2) throws RpcException;

            public QueryResult next(RPC var1, NextRequest var2) throws RpcException;

            public ApiBasePb.Integer64Proto count(RPC var1, Query var2) throws RpcException;

            public QueryExplanation explain(RPC var1, Query var2) throws RpcException;

            public ApiBasePb.VoidProto deleteCursor(RPC var1, Cursor var2) throws RpcException;

            public Transaction beginTransaction(RPC var1, ApiBasePb.VoidProto var2) throws RpcException;

            public CommitResponse commit(RPC var1, Transaction var2) throws RpcException;

            public ApiBasePb.VoidProto rollback(RPC var1, Transaction var2) throws RpcException;

            public Schema getSchema(RPC var1, ApiBasePb.StringProto var2) throws RpcException;

            public ApiBasePb.Integer64Proto createIndex(RPC var1, OnestoreEntity.CompositeIndex var2) throws RpcException;

            public ApiBasePb.VoidProto updateIndex(RPC var1, OnestoreEntity.CompositeIndex var2) throws RpcException;

            public CompositeIndices getIndices(RPC var1, ApiBasePb.StringProto var2) throws RpcException;

            public ApiBasePb.VoidProto deleteIndex(RPC var1, OnestoreEntity.CompositeIndex var2) throws RpcException;
        }

        private static class BaseStub
        extends RpcStub {
            protected final String Get_method_;
            protected final RPC Get_parameters_ = this.newRpcPrototype(Method.Get);
            protected final String Put_method_;
            protected final RPC Put_parameters_ = this.newRpcPrototype(Method.Put);
            protected final String Delete_method_;
            protected final RPC Delete_parameters_ = this.newRpcPrototype(Method.Delete);
            protected final String RunQuery_method_;
            protected final RPC RunQuery_parameters_ = this.newRpcPrototype(Method.RunQuery);
            protected final String Next_method_;
            protected final RPC Next_parameters_ = this.newRpcPrototype(Method.Next);
            protected final String Count_method_;
            protected final RPC Count_parameters_ = this.newRpcPrototype(Method.Count);
            protected final String Explain_method_;
            protected final RPC Explain_parameters_ = this.newRpcPrototype(Method.Explain);
            protected final String DeleteCursor_method_;
            protected final RPC DeleteCursor_parameters_ = this.newRpcPrototype(Method.DeleteCursor);
            protected final String BeginTransaction_method_;
            protected final RPC BeginTransaction_parameters_ = this.newRpcPrototype(Method.BeginTransaction);
            protected final String Commit_method_;
            protected final RPC Commit_parameters_ = this.newRpcPrototype(Method.Commit);
            protected final String Rollback_method_;
            protected final RPC Rollback_parameters_ = this.newRpcPrototype(Method.Rollback);
            protected final String GetSchema_method_;
            protected final RPC GetSchema_parameters_ = this.newRpcPrototype(Method.GetSchema);
            protected final String CreateIndex_method_;
            protected final RPC CreateIndex_parameters_ = this.newRpcPrototype(Method.CreateIndex);
            protected final String UpdateIndex_method_;
            protected final RPC UpdateIndex_parameters_ = this.newRpcPrototype(Method.UpdateIndex);
            protected final String GetIndices_method_;
            protected final RPC GetIndices_parameters_ = this.newRpcPrototype(Method.GetIndices);
            protected final String DeleteIndex_method_;
            protected final RPC DeleteIndex_parameters_ = this.newRpcPrototype(Method.DeleteIndex);

            protected BaseStub(RpcStubParameters params) {
                super("DatastoreService", params, Method.class);
                this.Get_method_ = this.makeFullMethodName("Get");
                this.Put_method_ = this.makeFullMethodName("Put");
                this.Delete_method_ = this.makeFullMethodName("Delete");
                this.RunQuery_method_ = this.makeFullMethodName("RunQuery");
                this.Next_method_ = this.makeFullMethodName("Next");
                this.Count_method_ = this.makeFullMethodName("Count");
                this.Explain_method_ = this.makeFullMethodName("Explain");
                this.DeleteCursor_method_ = this.makeFullMethodName("DeleteCursor");
                this.BeginTransaction_method_ = this.makeFullMethodName("BeginTransaction");
                this.Commit_method_ = this.makeFullMethodName("Commit");
                this.Rollback_method_ = this.makeFullMethodName("Rollback");
                this.GetSchema_method_ = this.makeFullMethodName("GetSchema");
                this.CreateIndex_method_ = this.makeFullMethodName("CreateIndex");
                this.UpdateIndex_method_ = this.makeFullMethodName("UpdateIndex");
                this.GetIndices_method_ = this.makeFullMethodName("GetIndices");
                this.DeleteIndex_method_ = this.makeFullMethodName("DeleteIndex");
            }
        }

        private static class SimpleStub
        extends RpcStub {
            public SimpleStub(RpcStubParameters params) {
                super("DatastoreService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            Get,
            Put,
            Delete,
            RunQuery,
            Next,
            Count,
            Explain,
            DeleteCursor,
            BeginTransaction,
            Commit,
            Rollback,
            GetSchema,
            CreateIndex,
            UpdateIndex,
            GetIndices,
            DeleteIndex;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommitResponse
    extends ProtocolMessage<CommitResponse> {
        private static final long serialVersionUID = 1L;
        private Cost cost_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final CommitResponse IMMUTABLE_DEFAULT_INSTANCE = new CommitResponse(){
            private static final long serialVersionUID = 1L;

            public CommitResponse clearCost() {
                return this;
            }

            public CommitResponse setCost(Cost x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost getMutableCost() {
                return (Cost)ProtocolSupport.unsupportedOperation();
            }

            public CommitResponse mergeFrom(CommitResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public CommitResponse freeze() {
                return this;
            }

            public CommitResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kcost = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final Cost getCost() {
            if (this.cost_ == null) {
                return Cost.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.cost_;
        }

        public final boolean hasCost() {
            return (this.optional_0_ & 1) != 0;
        }

        public CommitResponse clearCost() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.cost_ != null) {
                this.cost_.clear();
            }
            return this;
        }

        public CommitResponse setCost(Cost x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.cost_ = x;
            return this;
        }

        public Cost getMutableCost() {
            this.optional_0_ |= 1;
            if (this.cost_ == null) {
                this.cost_ = new Cost();
            }
            return this.cost_;
        }

        @Override
        public CommitResponse mergeFrom(CommitResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Cost v = this.cost_;
                if (v == null) {
                    this.cost_ = v = new Cost();
                }
                v.mergeFrom(that.cost_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(CommitResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(CommitResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(CommitResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.cost_.equals(that.cost_, ignoreUninterpreted)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof CommitResponse && this.equals((CommitResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = 1599213495;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.cost_.hashCode() : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0 && (e = this.cost_.findInitializationError()) != null) {
                return e;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.cost_.encodingSize());
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.cost_.maxEncodingSize();
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.cost_ != null) {
                this.cost_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public CommitResponse newInstance() {
            return new CommitResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)10);
                sink.putForeign(this.cost_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        Cost v1 = this.cost_;
                        if (v1 == null) {
                            this.cost_ = v1 = new Cost();
                        }
                        if (!v1.merge(source)) {
                            result = false;
                            break block4;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public CommitResponse freeze() {
            if (this.cost_ != null) {
                this.cost_.freeze();
            }
            return this;
        }

        @Override
        public CommitResponse unfreeze() {
            if (this.cost_ != null) {
                this.cost_.unfreeze();
            }
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.cost_ != null && this.cost_.isFrozen();
        }

        static {
            CommitResponse.text[0] = "ErrorCode";
            CommitResponse.text[1] = "cost";
            types = new int[2];
            Arrays.fill(types, 6);
            CommitResponse.types[0] = 0;
            CommitResponse.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(CommitResponse.class, "Z'apphosting/datastore/datastore_v3.proto\n&apphosting_datastore_v3.CommitResponse\u0013\u001a\u0004cost \u0001(\u00020\u000b8\u0001J\u001capphosting_datastore_v3.Cost\u0014", new ProtocolType.FieldType("cost", "cost", 1, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Cost.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompositeIndices
    extends ProtocolMessage<CompositeIndices> {
        private static final long serialVersionUID = 1L;
        private List<OnestoreEntity.CompositeIndex> index_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final CompositeIndices IMMUTABLE_DEFAULT_INSTANCE = new CompositeIndices(){
            private static final long serialVersionUID = 1L;

            public CompositeIndices clearIndex() {
                return this;
            }

            public OnestoreEntity.CompositeIndex getMutableIndex(int i) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex addIndex() {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex addIndex(OnestoreEntity.CompositeIndex v) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex insertIndex(int i, OnestoreEntity.CompositeIndex v) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex removeIndex(int i) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public CompositeIndices mergeFrom(CompositeIndices that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public CompositeIndices freeze() {
                return this;
            }

            public CompositeIndices unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kindex = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int indexSize() {
            return this.index_ != null ? this.index_.size() : 0;
        }

        public final OnestoreEntity.CompositeIndex getIndex(int i) {
            assert (i >= 0 && i < (this.index_ != null ? this.index_.size() : 0));
            return this.index_.get(i);
        }

        public CompositeIndices clearIndex() {
            if (this.index_ != null) {
                this.index_.clear();
            }
            return this;
        }

        public OnestoreEntity.CompositeIndex getMutableIndex(int i) {
            assert (i >= 0 && this.index_ != null && i < this.index_.size());
            return this.index_.get(i);
        }

        public OnestoreEntity.CompositeIndex addIndex() {
            OnestoreEntity.CompositeIndex v = new OnestoreEntity.CompositeIndex();
            if (this.index_ == null) {
                this.index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.index_.add(v);
            return v;
        }

        public OnestoreEntity.CompositeIndex addIndex(OnestoreEntity.CompositeIndex v) {
            if (this.index_ == null) {
                this.index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.index_.add(v);
            return v;
        }

        public OnestoreEntity.CompositeIndex insertIndex(int i, OnestoreEntity.CompositeIndex v) {
            if (this.index_ == null) {
                this.index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.index_.add(i, v);
            return v;
        }

        public OnestoreEntity.CompositeIndex removeIndex(int i) {
            return this.index_.remove(i);
        }

        public final Iterator<OnestoreEntity.CompositeIndex> indexIterator() {
            if (this.index_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.index_.iterator();
        }

        public final List<OnestoreEntity.CompositeIndex> indexs() {
            return ProtocolSupport.unmodifiableList(this.index_);
        }

        public final List<OnestoreEntity.CompositeIndex> mutableIndexs() {
            if (this.index_ == null) {
                this.index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            return this.index_;
        }

        @Override
        public CompositeIndices mergeFrom(CompositeIndices that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.index_ != null) {
                for (OnestoreEntity.CompositeIndex v : that.index_) {
                    this.addIndex().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(CompositeIndices that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(CompositeIndices that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(CompositeIndices that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.index_ != null ? this.index_.size() : 0;
            if (n != (that.index_ != null ? that.index_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.index_.get(i).equals(that.index_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof CompositeIndices && this.equals((CompositeIndices)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -647753241;
            hash *= 31;
            int n2 = n = this.index_ != null ? this.index_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.index_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.index_ != null) {
                for (OnestoreEntity.CompositeIndex v : this.index_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.index_ != null ? this.index_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.index_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.index_ != null ? this.index_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.index_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.index_ != null) {
                this.index_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public CompositeIndices newInstance() {
            return new CompositeIndices();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.index_ != null ? this.index_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.CompositeIndex v = this.index_.get(i);
                sink.putByte((byte)10);
                sink.putForeign(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.addIndex().merge(source)) {
                            result = false;
                            break block4;
                        }
                        source.pop();
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public CompositeIndices freeze() {
            this.index_ = ProtocolSupport.freezeMessages(this.index_);
            return this;
        }

        @Override
        public CompositeIndices unfreeze() {
            this.index_ = ProtocolSupport.unfreezeMessages(this.index_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.index_);
        }

        static {
            CompositeIndices.text[0] = "ErrorCode";
            CompositeIndices.text[1] = "index";
            types = new int[2];
            Arrays.fill(types, 6);
            CompositeIndices.types[0] = 0;
            CompositeIndices.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(CompositeIndices.class, "Z'apphosting/datastore/datastore_v3.proto\n(apphosting_datastore_v3.CompositeIndices\u0013\u001a\u0005index \u0001(\u00020\u000b8\u0003J\"storage_onestore_v3.CompositeIndex\u0014", new ProtocolType.FieldType("index", "index", 1, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.CompositeIndex.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Schema
    extends ProtocolMessage<Schema> {
        private static final long serialVersionUID = 1L;
        private List<OnestoreEntity.EntityProto> kind_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Schema IMMUTABLE_DEFAULT_INSTANCE = new Schema(){
            private static final long serialVersionUID = 1L;

            public Schema clearKind() {
                return this;
            }

            public OnestoreEntity.EntityProto getMutableKind(int i) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto addKind() {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto addKind(OnestoreEntity.EntityProto v) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto insertKind(int i, OnestoreEntity.EntityProto v) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto removeKind(int i) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public Schema mergeFrom(Schema that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Schema freeze() {
                return this;
            }

            public Schema unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kkind = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int kindSize() {
            return this.kind_ != null ? this.kind_.size() : 0;
        }

        public final OnestoreEntity.EntityProto getKind(int i) {
            assert (i >= 0 && i < (this.kind_ != null ? this.kind_.size() : 0));
            return this.kind_.get(i);
        }

        public Schema clearKind() {
            if (this.kind_ != null) {
                this.kind_.clear();
            }
            return this;
        }

        public OnestoreEntity.EntityProto getMutableKind(int i) {
            assert (i >= 0 && this.kind_ != null && i < this.kind_.size());
            return this.kind_.get(i);
        }

        public OnestoreEntity.EntityProto addKind() {
            OnestoreEntity.EntityProto v = new OnestoreEntity.EntityProto();
            if (this.kind_ == null) {
                this.kind_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.kind_.add(v);
            return v;
        }

        public OnestoreEntity.EntityProto addKind(OnestoreEntity.EntityProto v) {
            if (this.kind_ == null) {
                this.kind_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.kind_.add(v);
            return v;
        }

        public OnestoreEntity.EntityProto insertKind(int i, OnestoreEntity.EntityProto v) {
            if (this.kind_ == null) {
                this.kind_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.kind_.add(i, v);
            return v;
        }

        public OnestoreEntity.EntityProto removeKind(int i) {
            return this.kind_.remove(i);
        }

        public final Iterator<OnestoreEntity.EntityProto> kindIterator() {
            if (this.kind_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.kind_.iterator();
        }

        public final List<OnestoreEntity.EntityProto> kinds() {
            return ProtocolSupport.unmodifiableList(this.kind_);
        }

        public final List<OnestoreEntity.EntityProto> mutableKinds() {
            if (this.kind_ == null) {
                this.kind_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            return this.kind_;
        }

        @Override
        public Schema mergeFrom(Schema that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.kind_ != null) {
                for (OnestoreEntity.EntityProto v : that.kind_) {
                    this.addKind().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Schema that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Schema that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Schema that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.kind_ != null ? this.kind_.size() : 0;
            if (n != (that.kind_ != null ? that.kind_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.kind_.get(i).equals(that.kind_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Schema && this.equals((Schema)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 1963788789;
            hash *= 31;
            int n2 = n = this.kind_ != null ? this.kind_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.kind_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.kind_ != null) {
                for (OnestoreEntity.EntityProto v : this.kind_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.kind_ != null ? this.kind_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.kind_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.kind_ != null ? this.kind_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.kind_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.kind_ != null) {
                this.kind_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public Schema newInstance() {
            return new Schema();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.kind_ != null ? this.kind_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.EntityProto v = this.kind_.get(i);
                sink.putByte((byte)10);
                sink.putForeign(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.addKind().merge(source)) {
                            result = false;
                            break block4;
                        }
                        source.pop();
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public Schema freeze() {
            this.kind_ = ProtocolSupport.freezeMessages(this.kind_);
            return this;
        }

        @Override
        public Schema unfreeze() {
            this.kind_ = ProtocolSupport.unfreezeMessages(this.kind_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.kind_);
        }

        static {
            Schema.text[0] = "ErrorCode";
            Schema.text[1] = "kind";
            types = new int[2];
            Arrays.fill(types, 6);
            Schema.types[0] = 0;
            Schema.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Schema.class, "Z'apphosting/datastore/datastore_v3.proto\n\u001eapphosting_datastore_v3.Schema\u0013\u001a\u0004kind \u0001(\u00020\u000b8\u0003J\u001fstorage_onestore_v3.EntityProto\u0014", new ProtocolType.FieldType("kind", "kind", 1, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.EntityProto.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryResult
    extends ProtocolMessage<QueryResult> {
        private static final long serialVersionUID = 1L;
        private Cursor cursor_ = null;
        private List<OnestoreEntity.EntityProto> result_ = null;
        private boolean more_results_ = false;
        private boolean keys_only_ = false;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final QueryResult IMMUTABLE_DEFAULT_INSTANCE = new QueryResult(){
            private static final long serialVersionUID = 1L;

            public QueryResult clearCursor() {
                return this;
            }

            public QueryResult setCursor(Cursor x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cursor getMutableCursor() {
                return (Cursor)ProtocolSupport.unsupportedOperation();
            }

            public QueryResult clearResult() {
                return this;
            }

            public OnestoreEntity.EntityProto getMutableResult(int i) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto addResult() {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto addResult(OnestoreEntity.EntityProto v) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto insertResult(int i, OnestoreEntity.EntityProto v) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto removeResult(int i) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public QueryResult clearMoreResults() {
                return this;
            }

            public QueryResult setMoreResults(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public QueryResult clearKeysOnly() {
                return this;
            }

            public QueryResult setKeysOnly(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public QueryResult mergeFrom(QueryResult that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public QueryResult freeze() {
                return this;
            }

            public QueryResult unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kcursor = 1;
        public static final int kresult = 2;
        public static final int kmore_results = 3;
        public static final int kkeys_only = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final Cursor getCursor() {
            if (this.cursor_ == null) {
                return Cursor.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.cursor_;
        }

        public final boolean hasCursor() {
            return (this.optional_0_ & 1) != 0;
        }

        public QueryResult clearCursor() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.cursor_ != null) {
                this.cursor_.clear();
            }
            return this;
        }

        public QueryResult setCursor(Cursor x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.cursor_ = x;
            return this;
        }

        public Cursor getMutableCursor() {
            this.optional_0_ |= 1;
            if (this.cursor_ == null) {
                this.cursor_ = new Cursor();
            }
            return this.cursor_;
        }

        public final int resultSize() {
            return this.result_ != null ? this.result_.size() : 0;
        }

        public final OnestoreEntity.EntityProto getResult(int i) {
            assert (i >= 0 && i < (this.result_ != null ? this.result_.size() : 0));
            return this.result_.get(i);
        }

        public QueryResult clearResult() {
            if (this.result_ != null) {
                this.result_.clear();
            }
            return this;
        }

        public OnestoreEntity.EntityProto getMutableResult(int i) {
            assert (i >= 0 && this.result_ != null && i < this.result_.size());
            return this.result_.get(i);
        }

        public OnestoreEntity.EntityProto addResult() {
            OnestoreEntity.EntityProto v = new OnestoreEntity.EntityProto();
            if (this.result_ == null) {
                this.result_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.result_.add(v);
            return v;
        }

        public OnestoreEntity.EntityProto addResult(OnestoreEntity.EntityProto v) {
            if (this.result_ == null) {
                this.result_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.result_.add(v);
            return v;
        }

        public OnestoreEntity.EntityProto insertResult(int i, OnestoreEntity.EntityProto v) {
            if (this.result_ == null) {
                this.result_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.result_.add(i, v);
            return v;
        }

        public OnestoreEntity.EntityProto removeResult(int i) {
            return this.result_.remove(i);
        }

        public final Iterator<OnestoreEntity.EntityProto> resultIterator() {
            if (this.result_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.result_.iterator();
        }

        public final List<OnestoreEntity.EntityProto> results() {
            return ProtocolSupport.unmodifiableList(this.result_);
        }

        public final List<OnestoreEntity.EntityProto> mutableResults() {
            if (this.result_ == null) {
                this.result_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            return this.result_;
        }

        public final boolean isMoreResults() {
            return this.more_results_;
        }

        public final boolean hasMoreResults() {
            return (this.optional_0_ & 2) != 0;
        }

        public QueryResult clearMoreResults() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.more_results_ = false;
            return this;
        }

        public QueryResult setMoreResults(boolean x) {
            this.optional_0_ |= 2;
            this.more_results_ = x;
            return this;
        }

        public final boolean isKeysOnly() {
            return this.keys_only_;
        }

        public final boolean hasKeysOnly() {
            return (this.optional_0_ & 4) != 0;
        }

        public QueryResult clearKeysOnly() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.keys_only_ = false;
            return this;
        }

        public QueryResult setKeysOnly(boolean x) {
            this.optional_0_ |= 4;
            this.keys_only_ = x;
            return this;
        }

        @Override
        public QueryResult mergeFrom(QueryResult that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Cursor v = this.cursor_;
                if (v == null) {
                    this.cursor_ = v = new Cursor();
                }
                v.mergeFrom(that.cursor_);
            }
            if (that.result_ != null) {
                for (OnestoreEntity.EntityProto v : that.result_) {
                    this.addResult().mergeFrom(v);
                }
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.more_results_ = that.more_results_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.keys_only_ = that.keys_only_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(QueryResult that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(QueryResult that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(QueryResult that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFF7) != (that_t0 & 0xFFFFFFF7)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.cursor_.equals(that.cursor_, ignoreUninterpreted)) {
                return false;
            }
            int n = this.result_ != null ? this.result_.size() : 0;
            if (n != (that.result_ != null ? that.result_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.result_.get(i).equals(that.result_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 2) != 0 && this.more_results_ != that.more_results_) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.keys_only_ != that.keys_only_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 8) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof QueryResult && this.equals((QueryResult)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -76248718;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.cursor_.hashCode() : -113);
            hash *= 31;
            int n2 = n = this.result_ != null ? this.result_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.result_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 2) != 0 ? (this.more_results_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? (this.keys_only_ ? 1231 : 1237) : -113);
            if ((this_t0 & 8) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 2) {
                return "missing field: more_results";
            }
            if ((this_t0 & 1) != 0 && (e = this.cursor_.findInitializationError()) != null) {
                return e;
            }
            if (this.result_ != null) {
                for (OnestoreEntity.EntityProto v : this.result_) {
                    String e2 = v.findInitializationError();
                    if (e2 == null) continue;
                    return e2;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 2;
            int m = this.result_ != null ? this.result_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.result_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 5) != 0) {
                if ((this_t0 & 1) != 0) {
                    n += 1 + Protocol.stringSize(this.cursor_.encodingSize());
                }
                if ((this_t0 & 4) != 0) {
                    n += 2;
                }
            }
            return (this_t0 & 8) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 4;
            int m = this.result_ != null ? this.result_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.result_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.cursor_.maxEncodingSize();
            }
            return (this_t0 & 8) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 8;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.cursor_ != null) {
                this.cursor_.clear();
            }
            if (this.result_ != null) {
                this.result_.clear();
            }
            this.more_results_ = false;
            this.keys_only_ = false;
            this.uninterpreted = null;
        }

        @Override
        public QueryResult newInstance() {
            return new QueryResult();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)10);
                sink.putForeign(this.cursor_);
            }
            int n = m = this.result_ != null ? this.result_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.EntityProto v = this.result_.get(i);
                sink.putByte((byte)18);
                sink.putForeign(v);
            }
            sink.putByte((byte)24);
            sink.putBoolean(this.more_results_);
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)32);
                sink.putBoolean(this.keys_only_);
            }
            if ((this_t0 & 8) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block7: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block7;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        Cursor v1 = this.cursor_;
                        if (v1 == null) {
                            this.cursor_ = v1 = new Cursor();
                        }
                        if (!v1.merge(source)) {
                            result = false;
                            break block7;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block7;
                    }
                    case 18: {
                        source.push(source.getVarInt());
                        if (!this.addResult().merge(source)) {
                            result = false;
                            break block7;
                        }
                        source.pop();
                        continue block7;
                    }
                    case 24: {
                        this.more_results_ = source.getBoolean();
                        this_t0 |= 2;
                        continue block7;
                    }
                    case 32: {
                        this.keys_only_ = source.getBoolean();
                        this_t0 |= 4;
                        continue block7;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 8;
                        continue block7;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public QueryResult freeze() {
            if (this.cursor_ != null) {
                this.cursor_.freeze();
            }
            this.result_ = ProtocolSupport.freezeMessages(this.result_);
            return this;
        }

        @Override
        public QueryResult unfreeze() {
            if (this.cursor_ != null) {
                this.cursor_.unfreeze();
            }
            this.result_ = ProtocolSupport.unfreezeMessages(this.result_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.cursor_ != null && this.cursor_.isFrozen() || ProtocolSupport.isFrozenMessages(this.result_);
        }

        static {
            QueryResult.text[0] = "ErrorCode";
            QueryResult.text[1] = "cursor";
            QueryResult.text[2] = "result";
            QueryResult.text[3] = "more_results";
            QueryResult.text[4] = "keys_only";
            types = new int[5];
            Arrays.fill(types, 6);
            QueryResult.types[0] = 0;
            QueryResult.types[1] = 2;
            QueryResult.types[2] = 2;
            QueryResult.types[3] = 0;
            QueryResult.types[4] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(QueryResult.class, "Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.QueryResult\u0013\u001a\u0006cursor \u0001(\u00020\u000b8\u0001J\u001eapphosting_datastore_v3.Cursor\u0014\u0013\u001a\u0006result \u0002(\u00020\u000b8\u0003J\u001fstorage_onestore_v3.EntityProto\u0014\u0013\u001a\fmore_results \u0003(\u00000\b8\u0002\u0014\u0013\u001a\tkeys_only \u0004(\u00000\b8\u0001\u0014", new ProtocolType.FieldType("cursor", "cursor", 1, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Cursor.class), new ProtocolType.FieldType("result", "result", 2, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.EntityProto.class), new ProtocolType.FieldType("more_results", "more_results", 3, 1, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("keys_only", "keys_only", 4, 2, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NextRequest
    extends ProtocolMessage<NextRequest> {
        private static final long serialVersionUID = 1L;
        private Cursor cursor_ = new Cursor();
        private int count_ = 1;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final NextRequest IMMUTABLE_DEFAULT_INSTANCE = new NextRequest(){
            private static final long serialVersionUID = 1L;

            public NextRequest clearCursor() {
                return this;
            }

            public NextRequest setCursor(Cursor x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cursor getMutableCursor() {
                return (Cursor)ProtocolSupport.unsupportedOperation();
            }

            public NextRequest clearCount() {
                return this;
            }

            public NextRequest setCount(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public NextRequest mergeFrom(NextRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public NextRequest freeze() {
                return this;
            }

            public NextRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kcursor = 1;
        public static final int kcount = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final Cursor getCursor() {
            return this.cursor_;
        }

        public final boolean hasCursor() {
            return (this.optional_0_ & 1) != 0;
        }

        public NextRequest clearCursor() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.cursor_.clear();
            return this;
        }

        public NextRequest setCursor(Cursor x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.cursor_ = x;
            return this;
        }

        public Cursor getMutableCursor() {
            this.optional_0_ |= 1;
            return this.cursor_;
        }

        public final int getCount() {
            return this.count_;
        }

        public final boolean hasCount() {
            return (this.optional_0_ & 2) != 0;
        }

        public NextRequest clearCount() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.count_ = 1;
            return this;
        }

        public NextRequest setCount(int x) {
            this.optional_0_ |= 2;
            this.count_ = x;
            return this;
        }

        @Override
        public NextRequest mergeFrom(NextRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Cursor v = this.cursor_;
                v.mergeFrom(that.cursor_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.count_ = that.count_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(NextRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(NextRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(NextRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.cursor_.equals(that.cursor_, ignoreUninterpreted)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.count_ != that.count_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof NextRequest && this.equals((NextRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = -1275574653;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.cursor_.hashCode() : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.count_ : -113);
            if ((this_t0 & 4) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 1) {
                return "missing field: cursor";
            }
            String e1 = this.cursor_.findInitializationError();
            if (e1 != null) {
                return e1;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.cursor_.encodingSize());
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 1 + Protocol.varLongSize(this.count_);
            }
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 17 + this.cursor_.maxEncodingSize();
            int this_t0 = this.optional_0_;
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 4;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.cursor_.clear();
            this.count_ = 1;
            this.uninterpreted = null;
        }

        @Override
        public NextRequest newInstance() {
            return new NextRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putForeign(this.cursor_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)16);
                sink.putVarLong(this.count_);
            }
            if ((this_t0 & 4) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.cursor_.merge(source)) {
                            result = false;
                            break block5;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 16: {
                        this.count_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 4;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public NextRequest freeze() {
            this.cursor_.freeze();
            return this;
        }

        @Override
        public NextRequest unfreeze() {
            this.cursor_.unfreeze();
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.cursor_.isFrozen();
        }

        static {
            NextRequest.text[0] = "ErrorCode";
            NextRequest.text[1] = "cursor";
            NextRequest.text[2] = "count";
            types = new int[3];
            Arrays.fill(types, 6);
            NextRequest.types[0] = 0;
            NextRequest.types[1] = 2;
            NextRequest.types[2] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(NextRequest.class, "Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.NextRequest\u0013\u001a\u0006cursor \u0001(\u00020\u000b8\u0002J\u001eapphosting_datastore_v3.Cursor\u0014\u0013\u001a\u0005count \u0002(\u00000\u00058\u0001B\u00011\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00011\u00a4\u0001\u0014", new ProtocolType.FieldType("cursor", "cursor", 1, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REQUIRED, Cursor.class), new ProtocolType.FieldType("count", "count", 2, 1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteResponse
    extends ProtocolMessage<DeleteResponse> {
        private static final long serialVersionUID = 1L;
        private Cost cost_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final DeleteResponse IMMUTABLE_DEFAULT_INSTANCE = new DeleteResponse(){
            private static final long serialVersionUID = 1L;

            public DeleteResponse clearCost() {
                return this;
            }

            public DeleteResponse setCost(Cost x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost getMutableCost() {
                return (Cost)ProtocolSupport.unsupportedOperation();
            }

            public DeleteResponse mergeFrom(DeleteResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public DeleteResponse freeze() {
                return this;
            }

            public DeleteResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kcost = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final Cost getCost() {
            if (this.cost_ == null) {
                return Cost.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.cost_;
        }

        public final boolean hasCost() {
            return (this.optional_0_ & 1) != 0;
        }

        public DeleteResponse clearCost() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.cost_ != null) {
                this.cost_.clear();
            }
            return this;
        }

        public DeleteResponse setCost(Cost x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.cost_ = x;
            return this;
        }

        public Cost getMutableCost() {
            this.optional_0_ |= 1;
            if (this.cost_ == null) {
                this.cost_ = new Cost();
            }
            return this.cost_;
        }

        @Override
        public DeleteResponse mergeFrom(DeleteResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Cost v = this.cost_;
                if (v == null) {
                    this.cost_ = v = new Cost();
                }
                v.mergeFrom(that.cost_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(DeleteResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(DeleteResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(DeleteResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.cost_.equals(that.cost_, ignoreUninterpreted)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof DeleteResponse && this.equals((DeleteResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -411317989;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.cost_.hashCode() : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0 && (e = this.cost_.findInitializationError()) != null) {
                return e;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.cost_.encodingSize());
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.cost_.maxEncodingSize();
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.cost_ != null) {
                this.cost_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public DeleteResponse newInstance() {
            return new DeleteResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)10);
                sink.putForeign(this.cost_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        Cost v1 = this.cost_;
                        if (v1 == null) {
                            this.cost_ = v1 = new Cost();
                        }
                        if (!v1.merge(source)) {
                            result = false;
                            break block4;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public DeleteResponse freeze() {
            if (this.cost_ != null) {
                this.cost_.freeze();
            }
            return this;
        }

        @Override
        public DeleteResponse unfreeze() {
            if (this.cost_ != null) {
                this.cost_.unfreeze();
            }
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.cost_ != null && this.cost_.isFrozen();
        }

        static {
            DeleteResponse.text[0] = "ErrorCode";
            DeleteResponse.text[1] = "cost";
            types = new int[2];
            Arrays.fill(types, 6);
            DeleteResponse.types[0] = 0;
            DeleteResponse.types[1] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(DeleteResponse.class, "Z'apphosting/datastore/datastore_v3.proto\n&apphosting_datastore_v3.DeleteResponse\u0013\u001a\u0004cost \u0001(\u00020\u000b8\u0001J\u001capphosting_datastore_v3.Cost\u0014", new ProtocolType.FieldType("cost", "cost", 1, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Cost.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteRequest
    extends ProtocolMessage<DeleteRequest> {
        private static final long serialVersionUID = 1L;
        private List<OnestoreEntity.Reference> key_ = null;
        private Transaction transaction_ = null;
        private boolean trusted_ = false;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final DeleteRequest IMMUTABLE_DEFAULT_INSTANCE = new DeleteRequest(){
            private static final long serialVersionUID = 1L;

            public DeleteRequest clearKey() {
                return this;
            }

            public OnestoreEntity.Reference getMutableKey(int i) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference addKey() {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference addKey(OnestoreEntity.Reference v) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference insertKey(int i, OnestoreEntity.Reference v) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference removeKey(int i) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public DeleteRequest clearTransaction() {
                return this;
            }

            public DeleteRequest setTransaction(Transaction x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Transaction getMutableTransaction() {
                return (Transaction)ProtocolSupport.unsupportedOperation();
            }

            public DeleteRequest clearTrusted() {
                return this;
            }

            public DeleteRequest setTrusted(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public DeleteRequest mergeFrom(DeleteRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public DeleteRequest freeze() {
                return this;
            }

            public DeleteRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kkey = 6;
        public static final int ktransaction = 5;
        public static final int ktrusted = 4;
        public static final String[] text = new String[7];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int keySize() {
            return this.key_ != null ? this.key_.size() : 0;
        }

        public final OnestoreEntity.Reference getKey(int i) {
            assert (i >= 0 && i < (this.key_ != null ? this.key_.size() : 0));
            return this.key_.get(i);
        }

        public DeleteRequest clearKey() {
            if (this.key_ != null) {
                this.key_.clear();
            }
            return this;
        }

        public OnestoreEntity.Reference getMutableKey(int i) {
            assert (i >= 0 && this.key_ != null && i < this.key_.size());
            return this.key_.get(i);
        }

        public OnestoreEntity.Reference addKey() {
            OnestoreEntity.Reference v = new OnestoreEntity.Reference();
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(v);
            return v;
        }

        public OnestoreEntity.Reference addKey(OnestoreEntity.Reference v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(v);
            return v;
        }

        public OnestoreEntity.Reference insertKey(int i, OnestoreEntity.Reference v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(i, v);
            return v;
        }

        public OnestoreEntity.Reference removeKey(int i) {
            return this.key_.remove(i);
        }

        public final Iterator<OnestoreEntity.Reference> keyIterator() {
            if (this.key_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.key_.iterator();
        }

        public final List<OnestoreEntity.Reference> keys() {
            return ProtocolSupport.unmodifiableList(this.key_);
        }

        public final List<OnestoreEntity.Reference> mutableKeys() {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            return this.key_;
        }

        public final Transaction getTransaction() {
            if (this.transaction_ == null) {
                return Transaction.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.transaction_;
        }

        public final boolean hasTransaction() {
            return (this.optional_0_ & 1) != 0;
        }

        public DeleteRequest clearTransaction() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            return this;
        }

        public DeleteRequest setTransaction(Transaction x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.transaction_ = x;
            return this;
        }

        public Transaction getMutableTransaction() {
            this.optional_0_ |= 1;
            if (this.transaction_ == null) {
                this.transaction_ = new Transaction();
            }
            return this.transaction_;
        }

        public final boolean isTrusted() {
            return this.trusted_;
        }

        public final boolean hasTrusted() {
            return (this.optional_0_ & 2) != 0;
        }

        public DeleteRequest clearTrusted() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.trusted_ = false;
            return this;
        }

        public DeleteRequest setTrusted(boolean x) {
            this.optional_0_ |= 2;
            this.trusted_ = x;
            return this;
        }

        @Override
        public DeleteRequest mergeFrom(DeleteRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.key_ != null) {
                for (OnestoreEntity.Reference v : that.key_) {
                    this.addKey().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Transaction v = this.transaction_;
                if (v == null) {
                    this.transaction_ = v = new Transaction();
                }
                v.mergeFrom(that.transaction_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.trusted_ = that.trusted_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(DeleteRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(DeleteRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(DeleteRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                return false;
            }
            int n = this.key_ != null ? this.key_.size() : 0;
            if (n != (that.key_ != null ? that.key_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.key_.get(i).equals(that.key_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.transaction_.equals(that.transaction_, ignoreUninterpreted)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.trusted_ != that.trusted_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof DeleteRequest && this.equals((DeleteRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -59827476;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 2) != 0 ? (this.trusted_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.transaction_.hashCode() : -113);
            hash *= 31;
            int n2 = n = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.key_.get(i).hashCode();
            }
            if ((this_t0 & 4) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0;
            if (this.key_ != null) {
                for (OnestoreEntity.Reference v : this.key_) {
                    String e2 = v.findInitializationError();
                    if (e2 == null) continue;
                    return e2;
                }
            }
            if (((this_t0 = this.optional_0_) & 1) != 0 && (e = this.transaction_.findInitializationError()) != null) {
                return e;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.key_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 0) {
                if ((this_t0 & 1) != 0) {
                    n += 1 + Protocol.stringSize(this.transaction_.encodingSize());
                }
                if ((this_t0 & 2) != 0) {
                    n += 2;
                }
            }
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 2;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.key_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.transaction_.maxEncodingSize();
            }
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 4;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.key_ != null) {
                this.key_.clear();
            }
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            this.trusted_ = false;
            this.uninterpreted = null;
        }

        @Override
        public DeleteRequest newInstance() {
            return new DeleteRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)32);
                sink.putBoolean(this.trusted_);
            }
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)42);
                sink.putForeign(this.transaction_);
            }
            int n = m = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.Reference v = this.key_.get(i);
                sink.putByte((byte)50);
                sink.putForeign(v);
            }
            if ((this_t0 & 4) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block6: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block6;
                    }
                    case 32: {
                        this.trusted_ = source.getBoolean();
                        this_t0 |= 2;
                        continue block6;
                    }
                    case 42: {
                        source.push(source.getVarInt());
                        Transaction v5 = this.transaction_;
                        if (v5 == null) {
                            this.transaction_ = v5 = new Transaction();
                        }
                        if (!v5.merge(source)) {
                            result = false;
                            break block6;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block6;
                    }
                    case 50: {
                        source.push(source.getVarInt());
                        if (!this.addKey().merge(source)) {
                            result = false;
                            break block6;
                        }
                        source.pop();
                        continue block6;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 4;
                        continue block6;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public DeleteRequest freeze() {
            this.key_ = ProtocolSupport.freezeMessages(this.key_);
            if (this.transaction_ != null) {
                this.transaction_.freeze();
            }
            return this;
        }

        @Override
        public DeleteRequest unfreeze() {
            this.key_ = ProtocolSupport.unfreezeMessages(this.key_);
            if (this.transaction_ != null) {
                this.transaction_.unfreeze();
            }
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.key_) || this.transaction_ != null && this.transaction_.isFrozen();
        }

        static {
            DeleteRequest.text[0] = "ErrorCode";
            DeleteRequest.text[4] = "trusted";
            DeleteRequest.text[5] = "transaction";
            DeleteRequest.text[6] = "key";
            types = new int[7];
            Arrays.fill(types, 6);
            DeleteRequest.types[0] = 0;
            DeleteRequest.types[4] = 0;
            DeleteRequest.types[5] = 2;
            DeleteRequest.types[6] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(DeleteRequest.class, "Z'apphosting/datastore/datastore_v3.proto\n%apphosting_datastore_v3.DeleteRequest\u0013\u001a\u0003key \u0006(\u00020\u000b8\u0003J\u001dstorage_onestore_v3.Reference\u0014\u0013\u001a\u000btransaction \u0005(\u00020\u000b8\u0001J#apphosting_datastore_v3.Transaction\u0014\u0013\u001a\u0007trusted \u0004(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014", new ProtocolType.FieldType("key", "key", 6, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.Reference.class), new ProtocolType.FieldType("transaction", "transaction", 5, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Transaction.class), new ProtocolType.FieldType("trusted", "trusted", 4, 1, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutResponse
    extends ProtocolMessage<PutResponse> {
        private static final long serialVersionUID = 1L;
        private List<OnestoreEntity.Reference> key_ = null;
        private Cost cost_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final PutResponse IMMUTABLE_DEFAULT_INSTANCE = new PutResponse(){
            private static final long serialVersionUID = 1L;

            public PutResponse clearKey() {
                return this;
            }

            public OnestoreEntity.Reference getMutableKey(int i) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference addKey() {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference addKey(OnestoreEntity.Reference v) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference insertKey(int i, OnestoreEntity.Reference v) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference removeKey(int i) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public PutResponse clearCost() {
                return this;
            }

            public PutResponse setCost(Cost x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost getMutableCost() {
                return (Cost)ProtocolSupport.unsupportedOperation();
            }

            public PutResponse mergeFrom(PutResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public PutResponse freeze() {
                return this;
            }

            public PutResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kkey = 1;
        public static final int kcost = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int keySize() {
            return this.key_ != null ? this.key_.size() : 0;
        }

        public final OnestoreEntity.Reference getKey(int i) {
            assert (i >= 0 && i < (this.key_ != null ? this.key_.size() : 0));
            return this.key_.get(i);
        }

        public PutResponse clearKey() {
            if (this.key_ != null) {
                this.key_.clear();
            }
            return this;
        }

        public OnestoreEntity.Reference getMutableKey(int i) {
            assert (i >= 0 && this.key_ != null && i < this.key_.size());
            return this.key_.get(i);
        }

        public OnestoreEntity.Reference addKey() {
            OnestoreEntity.Reference v = new OnestoreEntity.Reference();
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(v);
            return v;
        }

        public OnestoreEntity.Reference addKey(OnestoreEntity.Reference v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(v);
            return v;
        }

        public OnestoreEntity.Reference insertKey(int i, OnestoreEntity.Reference v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(i, v);
            return v;
        }

        public OnestoreEntity.Reference removeKey(int i) {
            return this.key_.remove(i);
        }

        public final Iterator<OnestoreEntity.Reference> keyIterator() {
            if (this.key_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.key_.iterator();
        }

        public final List<OnestoreEntity.Reference> keys() {
            return ProtocolSupport.unmodifiableList(this.key_);
        }

        public final List<OnestoreEntity.Reference> mutableKeys() {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            return this.key_;
        }

        public final Cost getCost() {
            if (this.cost_ == null) {
                return Cost.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.cost_;
        }

        public final boolean hasCost() {
            return (this.optional_0_ & 1) != 0;
        }

        public PutResponse clearCost() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.cost_ != null) {
                this.cost_.clear();
            }
            return this;
        }

        public PutResponse setCost(Cost x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.cost_ = x;
            return this;
        }

        public Cost getMutableCost() {
            this.optional_0_ |= 1;
            if (this.cost_ == null) {
                this.cost_ = new Cost();
            }
            return this.cost_;
        }

        @Override
        public PutResponse mergeFrom(PutResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.key_ != null) {
                for (OnestoreEntity.Reference v : that.key_) {
                    this.addKey().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Cost v = this.cost_;
                if (v == null) {
                    this.cost_ = v = new Cost();
                }
                v.mergeFrom(that.cost_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(PutResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(PutResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(PutResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            int n = this.key_ != null ? this.key_.size() : 0;
            if (n != (that.key_ != null ? that.key_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.key_.get(i).equals(that.key_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.cost_.equals(that.cost_, ignoreUninterpreted)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof PutResponse && this.equals((PutResponse)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -1158486768;
            hash *= 31;
            int n2 = n = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.key_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.cost_.hashCode() : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0;
            if (this.key_ != null) {
                for (OnestoreEntity.Reference v : this.key_) {
                    String e2 = v.findInitializationError();
                    if (e2 == null) continue;
                    return e2;
                }
            }
            if (((this_t0 = this.optional_0_) & 1) != 0 && (e = this.cost_.findInitializationError()) != null) {
                return e;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.key_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.cost_.encodingSize());
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.key_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.cost_.maxEncodingSize();
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.key_ != null) {
                this.key_.clear();
            }
            if (this.cost_ != null) {
                this.cost_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public PutResponse newInstance() {
            return new PutResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.Reference v = this.key_.get(i);
                sink.putByte((byte)10);
                sink.putForeign(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)18);
                sink.putForeign(this.cost_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.addKey().merge(source)) {
                            result = false;
                            break block5;
                        }
                        source.pop();
                        continue block5;
                    }
                    case 18: {
                        source.push(source.getVarInt());
                        Cost v2 = this.cost_;
                        if (v2 == null) {
                            this.cost_ = v2 = new Cost();
                        }
                        if (!v2.merge(source)) {
                            result = false;
                            break block5;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public PutResponse freeze() {
            this.key_ = ProtocolSupport.freezeMessages(this.key_);
            if (this.cost_ != null) {
                this.cost_.freeze();
            }
            return this;
        }

        @Override
        public PutResponse unfreeze() {
            this.key_ = ProtocolSupport.unfreezeMessages(this.key_);
            if (this.cost_ != null) {
                this.cost_.unfreeze();
            }
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.key_) || this.cost_ != null && this.cost_.isFrozen();
        }

        static {
            PutResponse.text[0] = "ErrorCode";
            PutResponse.text[1] = "key";
            PutResponse.text[2] = "cost";
            types = new int[3];
            Arrays.fill(types, 6);
            PutResponse.types[0] = 0;
            PutResponse.types[1] = 2;
            PutResponse.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(PutResponse.class, "Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.PutResponse\u0013\u001a\u0003key \u0001(\u00020\u000b8\u0003J\u001dstorage_onestore_v3.Reference\u0014\u0013\u001a\u0004cost \u0002(\u00020\u000b8\u0001J\u001capphosting_datastore_v3.Cost\u0014", new ProtocolType.FieldType("key", "key", 1, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.Reference.class), new ProtocolType.FieldType("cost", "cost", 2, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Cost.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PutRequest
    extends ProtocolMessage<PutRequest> {
        private static final long serialVersionUID = 1L;
        private List<OnestoreEntity.EntityProto> entity_ = null;
        private Transaction transaction_ = null;
        private List<OnestoreEntity.CompositeIndex> composite_index_ = null;
        private boolean trusted_ = false;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final PutRequest IMMUTABLE_DEFAULT_INSTANCE = new PutRequest(){
            private static final long serialVersionUID = 1L;

            public PutRequest clearEntity() {
                return this;
            }

            public OnestoreEntity.EntityProto getMutableEntity(int i) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto addEntity() {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto addEntity(OnestoreEntity.EntityProto v) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto insertEntity(int i, OnestoreEntity.EntityProto v) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.EntityProto removeEntity(int i) {
                return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
            }

            public PutRequest clearTransaction() {
                return this;
            }

            public PutRequest setTransaction(Transaction x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Transaction getMutableTransaction() {
                return (Transaction)ProtocolSupport.unsupportedOperation();
            }

            public PutRequest clearCompositeIndex() {
                return this;
            }

            public OnestoreEntity.CompositeIndex getMutableCompositeIndex(int i) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex addCompositeIndex() {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex addCompositeIndex(OnestoreEntity.CompositeIndex v) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex insertCompositeIndex(int i, OnestoreEntity.CompositeIndex v) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex removeCompositeIndex(int i) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public PutRequest clearTrusted() {
                return this;
            }

            public PutRequest setTrusted(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PutRequest mergeFrom(PutRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public PutRequest freeze() {
                return this;
            }

            public PutRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kentity = 1;
        public static final int ktransaction = 2;
        public static final int kcomposite_index = 3;
        public static final int ktrusted = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int entitySize() {
            return this.entity_ != null ? this.entity_.size() : 0;
        }

        public final OnestoreEntity.EntityProto getEntity(int i) {
            assert (i >= 0 && i < (this.entity_ != null ? this.entity_.size() : 0));
            return this.entity_.get(i);
        }

        public PutRequest clearEntity() {
            if (this.entity_ != null) {
                this.entity_.clear();
            }
            return this;
        }

        public OnestoreEntity.EntityProto getMutableEntity(int i) {
            assert (i >= 0 && this.entity_ != null && i < this.entity_.size());
            return this.entity_.get(i);
        }

        public OnestoreEntity.EntityProto addEntity() {
            OnestoreEntity.EntityProto v = new OnestoreEntity.EntityProto();
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.entity_.add(v);
            return v;
        }

        public OnestoreEntity.EntityProto addEntity(OnestoreEntity.EntityProto v) {
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.entity_.add(v);
            return v;
        }

        public OnestoreEntity.EntityProto insertEntity(int i, OnestoreEntity.EntityProto v) {
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            this.entity_.add(i, v);
            return v;
        }

        public OnestoreEntity.EntityProto removeEntity(int i) {
            return this.entity_.remove(i);
        }

        public final Iterator<OnestoreEntity.EntityProto> entityIterator() {
            if (this.entity_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.entity_.iterator();
        }

        public final List<OnestoreEntity.EntityProto> entitys() {
            return ProtocolSupport.unmodifiableList(this.entity_);
        }

        public final List<OnestoreEntity.EntityProto> mutableEntitys() {
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<OnestoreEntity.EntityProto>(4);
            }
            return this.entity_;
        }

        public final Transaction getTransaction() {
            if (this.transaction_ == null) {
                return Transaction.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.transaction_;
        }

        public final boolean hasTransaction() {
            return (this.optional_0_ & 1) != 0;
        }

        public PutRequest clearTransaction() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            return this;
        }

        public PutRequest setTransaction(Transaction x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.transaction_ = x;
            return this;
        }

        public Transaction getMutableTransaction() {
            this.optional_0_ |= 1;
            if (this.transaction_ == null) {
                this.transaction_ = new Transaction();
            }
            return this.transaction_;
        }

        public final int compositeIndexSize() {
            return this.composite_index_ != null ? this.composite_index_.size() : 0;
        }

        public final OnestoreEntity.CompositeIndex getCompositeIndex(int i) {
            assert (i >= 0 && i < (this.composite_index_ != null ? this.composite_index_.size() : 0));
            return this.composite_index_.get(i);
        }

        public PutRequest clearCompositeIndex() {
            if (this.composite_index_ != null) {
                this.composite_index_.clear();
            }
            return this;
        }

        public OnestoreEntity.CompositeIndex getMutableCompositeIndex(int i) {
            assert (i >= 0 && this.composite_index_ != null && i < this.composite_index_.size());
            return this.composite_index_.get(i);
        }

        public OnestoreEntity.CompositeIndex addCompositeIndex() {
            OnestoreEntity.CompositeIndex v = new OnestoreEntity.CompositeIndex();
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.composite_index_.add(v);
            return v;
        }

        public OnestoreEntity.CompositeIndex addCompositeIndex(OnestoreEntity.CompositeIndex v) {
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.composite_index_.add(v);
            return v;
        }

        public OnestoreEntity.CompositeIndex insertCompositeIndex(int i, OnestoreEntity.CompositeIndex v) {
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.composite_index_.add(i, v);
            return v;
        }

        public OnestoreEntity.CompositeIndex removeCompositeIndex(int i) {
            return this.composite_index_.remove(i);
        }

        public final Iterator<OnestoreEntity.CompositeIndex> compositeIndexIterator() {
            if (this.composite_index_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.composite_index_.iterator();
        }

        public final List<OnestoreEntity.CompositeIndex> compositeIndexs() {
            return ProtocolSupport.unmodifiableList(this.composite_index_);
        }

        public final List<OnestoreEntity.CompositeIndex> mutableCompositeIndexs() {
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            return this.composite_index_;
        }

        public final boolean isTrusted() {
            return this.trusted_;
        }

        public final boolean hasTrusted() {
            return (this.optional_0_ & 2) != 0;
        }

        public PutRequest clearTrusted() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.trusted_ = false;
            return this;
        }

        public PutRequest setTrusted(boolean x) {
            this.optional_0_ |= 2;
            this.trusted_ = x;
            return this;
        }

        @Override
        public PutRequest mergeFrom(PutRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.entity_ != null) {
                for (OnestoreEntity.EntityProto entityProto : that.entity_) {
                    this.addEntity().mergeFrom(entityProto);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Transaction v = this.transaction_;
                if (v == null) {
                    this.transaction_ = v = new Transaction();
                }
                v.mergeFrom(that.transaction_);
            }
            if (that.composite_index_ != null) {
                for (OnestoreEntity.CompositeIndex compositeIndex : that.composite_index_) {
                    this.addCompositeIndex().mergeFrom(compositeIndex);
                }
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.trusted_ = that.trusted_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(PutRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(PutRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(PutRequest that, boolean ignoreUninterpreted) {
            int i;
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                return false;
            }
            int n = this.entity_ != null ? this.entity_.size() : 0;
            if (n != (that.entity_ != null ? that.entity_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.entity_.get(i).equals(that.entity_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.transaction_.equals(that.transaction_, ignoreUninterpreted)) {
                return false;
            }
            n = this.composite_index_ != null ? this.composite_index_.size() : 0;
            if (n != (that.composite_index_ != null ? that.composite_index_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.composite_index_.get(i).equals(that.composite_index_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 2) != 0 && this.trusted_ != that.trusted_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof PutRequest && this.equals((PutRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int n2;
            int hash = -2089263550;
            hash *= 31;
            int n3 = n2 = this.entity_ != null ? this.entity_.size() : 0;
            for (int i = 0; i < n2; ++i) {
                hash = hash * 31 + this.entity_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.transaction_.hashCode() : -113);
            hash *= 31;
            int n4 = n = this.composite_index_ != null ? this.composite_index_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.composite_index_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 2) != 0 ? (this.trusted_ ? 1231 : 1237) : -113);
            if ((this_t0 & 4) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0;
            if (this.entity_ != null) {
                for (OnestoreEntity.EntityProto v : this.entity_) {
                    String e2 = v.findInitializationError();
                    if (e2 == null) continue;
                    return e2;
                }
            }
            if (((this_t0 = this.optional_0_) & 1) != 0 && (e = this.transaction_.findInitializationError()) != null) {
                return e;
            }
            if (this.composite_index_ != null) {
                for (OnestoreEntity.CompositeIndex v : this.composite_index_) {
                    String e3 = v.findInitializationError();
                    if (e3 == null) continue;
                    return e3;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int i;
            int n = 0;
            int m = this.entity_ != null ? this.entity_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.entity_.get(i).encodingSize());
            }
            m = this.composite_index_ != null ? this.composite_index_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.composite_index_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 3) != 0) {
                if ((this_t0 & 1) != 0) {
                    n += 1 + Protocol.stringSize(this.transaction_.encodingSize());
                }
                if ((this_t0 & 2) != 0) {
                    n += 2;
                }
            }
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int i;
            int n = 2;
            int m = this.entity_ != null ? this.entity_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.entity_.get(i).maxEncodingSize();
            }
            m = this.composite_index_ != null ? this.composite_index_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.composite_index_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.transaction_.maxEncodingSize();
            }
            return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 4;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.entity_ != null) {
                this.entity_.clear();
            }
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            if (this.composite_index_ != null) {
                this.composite_index_.clear();
            }
            this.trusted_ = false;
            this.uninterpreted = null;
        }

        @Override
        public PutRequest newInstance() {
            return new PutRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int m2;
            int n = m2 = this.entity_ != null ? this.entity_.size() : 0;
            for (int i = 0; i < m2; ++i) {
                OnestoreEntity.EntityProto v = this.entity_.get(i);
                sink.putByte((byte)10);
                sink.putForeign(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)18);
                sink.putForeign(this.transaction_);
            }
            int n2 = m = this.composite_index_ != null ? this.composite_index_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.CompositeIndex v = this.composite_index_.get(i);
                sink.putByte((byte)26);
                sink.putForeign(v);
            }
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)32);
                sink.putBoolean(this.trusted_);
            }
            if ((this_t0 & 4) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block7: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block7;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.addEntity().merge(source)) {
                            result = false;
                            break block7;
                        }
                        source.pop();
                        continue block7;
                    }
                    case 18: {
                        source.push(source.getVarInt());
                        Transaction v2 = this.transaction_;
                        if (v2 == null) {
                            this.transaction_ = v2 = new Transaction();
                        }
                        if (!v2.merge(source)) {
                            result = false;
                            break block7;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block7;
                    }
                    case 26: {
                        source.push(source.getVarInt());
                        if (!this.addCompositeIndex().merge(source)) {
                            result = false;
                            break block7;
                        }
                        source.pop();
                        continue block7;
                    }
                    case 32: {
                        this.trusted_ = source.getBoolean();
                        this_t0 |= 2;
                        continue block7;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 4;
                        continue block7;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public PutRequest freeze() {
            this.entity_ = ProtocolSupport.freezeMessages(this.entity_);
            if (this.transaction_ != null) {
                this.transaction_.freeze();
            }
            this.composite_index_ = ProtocolSupport.freezeMessages(this.composite_index_);
            return this;
        }

        @Override
        public PutRequest unfreeze() {
            this.entity_ = ProtocolSupport.unfreezeMessages(this.entity_);
            if (this.transaction_ != null) {
                this.transaction_.unfreeze();
            }
            this.composite_index_ = ProtocolSupport.unfreezeMessages(this.composite_index_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.entity_) || this.transaction_ != null && this.transaction_.isFrozen() || ProtocolSupport.isFrozenMessages(this.composite_index_);
        }

        static {
            PutRequest.text[0] = "ErrorCode";
            PutRequest.text[1] = "entity";
            PutRequest.text[2] = "transaction";
            PutRequest.text[3] = "composite_index";
            PutRequest.text[4] = "trusted";
            types = new int[5];
            Arrays.fill(types, 6);
            PutRequest.types[0] = 0;
            PutRequest.types[1] = 2;
            PutRequest.types[2] = 2;
            PutRequest.types[3] = 2;
            PutRequest.types[4] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(PutRequest.class, "Z'apphosting/datastore/datastore_v3.proto\n\"apphosting_datastore_v3.PutRequest\u0013\u001a\u0006entity \u0001(\u00020\u000b8\u0003J\u001fstorage_onestore_v3.EntityProto\u0014\u0013\u001a\u000btransaction \u0002(\u00020\u000b8\u0001J#apphosting_datastore_v3.Transaction\u0014\u0013\u001a\u000fcomposite_index \u0003(\u00020\u000b8\u0003J\"storage_onestore_v3.CompositeIndex\u0014\u0013\u001a\u0007trusted \u0004(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014", new ProtocolType.FieldType("entity", "entity", 1, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.EntityProto.class), new ProtocolType.FieldType("transaction", "transaction", 2, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Transaction.class), new ProtocolType.FieldType("composite_index", "composite_index", 3, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.CompositeIndex.class), new ProtocolType.FieldType("trusted", "trusted", 4, 1, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetResponse
    extends ProtocolMessage<GetResponse> {
        private static final long serialVersionUID = 1L;
        private List<Entity> entity_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final GetResponse IMMUTABLE_DEFAULT_INSTANCE = new GetResponse(){
            private static final long serialVersionUID = 1L;

            public GetResponse clearEntity() {
                return this;
            }

            public Entity getMutableEntity(int i) {
                return (Entity)ProtocolSupport.unsupportedOperation();
            }

            public Entity addEntity() {
                return (Entity)ProtocolSupport.unsupportedOperation();
            }

            public Entity addEntity(Entity v) {
                return (Entity)ProtocolSupport.unsupportedOperation();
            }

            public Entity insertEntity(int i, Entity v) {
                return (Entity)ProtocolSupport.unsupportedOperation();
            }

            public Entity removeEntity(int i) {
                return (Entity)ProtocolSupport.unsupportedOperation();
            }

            public GetResponse mergeFrom(GetResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public GetResponse freeze() {
                return this;
            }

            public GetResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kEntityGroup = 1;
        public static final int kEntityentity = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int entitySize() {
            return this.entity_ != null ? this.entity_.size() : 0;
        }

        public final Entity getEntity(int i) {
            assert (i >= 0 && i < (this.entity_ != null ? this.entity_.size() : 0));
            return this.entity_.get(i);
        }

        public GetResponse clearEntity() {
            if (this.entity_ != null) {
                this.entity_.clear();
            }
            return this;
        }

        public Entity getMutableEntity(int i) {
            assert (i >= 0 && this.entity_ != null && i < this.entity_.size());
            return this.entity_.get(i);
        }

        public Entity addEntity() {
            Entity v = new Entity();
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<Entity>(4);
            }
            this.entity_.add(v);
            return v;
        }

        public Entity addEntity(Entity v) {
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<Entity>(4);
            }
            this.entity_.add(v);
            return v;
        }

        public Entity insertEntity(int i, Entity v) {
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<Entity>(4);
            }
            this.entity_.add(i, v);
            return v;
        }

        public Entity removeEntity(int i) {
            return this.entity_.remove(i);
        }

        public final Iterator<Entity> entityIterator() {
            if (this.entity_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.entity_.iterator();
        }

        public final List<Entity> entitys() {
            return ProtocolSupport.unmodifiableList(this.entity_);
        }

        public final List<Entity> mutableEntitys() {
            if (this.entity_ == null) {
                this.entity_ = new ArrayList<Entity>(4);
            }
            return this.entity_;
        }

        @Override
        public GetResponse mergeFrom(GetResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.entity_ != null) {
                for (Entity v : that.entity_) {
                    this.addEntity().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(GetResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(GetResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(GetResponse that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            int n = this.entity_ != null ? this.entity_.size() : 0;
            if (n != (that.entity_ != null ? that.entity_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.entity_.get(i).equals(that.entity_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof GetResponse && this.equals((GetResponse)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -1978281171;
            hash *= 31;
            int n2 = n = this.entity_ != null ? this.entity_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.entity_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.entity_ != null) {
                for (Entity v : this.entity_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.entity_ != null ? this.entity_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.entity_.get(i).encodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.entity_ != null ? this.entity_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += this.entity_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.entity_ != null) {
                this.entity_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public GetResponse newInstance() {
            return new GetResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.entity_ != null ? this.entity_.size() : 0;
            for (int i = 0; i < m; ++i) {
                Entity v = this.entity_.get(i);
                sink.putByte((byte)11);
                v.outputTo(sink);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 11: {
                        if (this.addEntity().merge(source)) continue block4;
                        result = false;
                        break block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public GetResponse freeze() {
            this.entity_ = ProtocolSupport.freezeMessages(this.entity_);
            return this;
        }

        @Override
        public GetResponse unfreeze() {
            this.entity_ = ProtocolSupport.unfreezeMessages(this.entity_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.entity_);
        }

        static {
            GetResponse.text[0] = "ErrorCode";
            GetResponse.text[1] = "Entity";
            GetResponse.text[2] = "entity";
            types = new int[3];
            Arrays.fill(types, 6);
            GetResponse.types[0] = 0;
            GetResponse.types[1] = 3;
            GetResponse.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(GetResponse.class, "Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.GetResponse\u0013\u001a\u0006Entity \u0001(\u00030\n8\u0003\u0014\u0013\u001a\rEntity.entity \u0002(\u00020\u000b8\u0001J\u001fstorage_onestore_v3.EntityProto`\u0000\u0014", new ProtocolType.FieldType("Entity", "entity", 1, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Entity.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Entity
        extends ProtocolMessage<Entity> {
            private static final long serialVersionUID = 1L;
            private OnestoreEntity.EntityProto entity_ = null;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Entity IMMUTABLE_DEFAULT_INSTANCE = new Entity(){
                private static final long serialVersionUID = 1L;

                public Entity clearEntity() {
                    return this;
                }

                public Entity setEntity(OnestoreEntity.EntityProto x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public OnestoreEntity.EntityProto getMutableEntity() {
                    return (OnestoreEntity.EntityProto)ProtocolSupport.unsupportedOperation();
                }

                public Entity mergeFrom(Entity that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Entity freeze() {
                    return this;
                }

                public Entity unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final OnestoreEntity.EntityProto getEntity() {
                if (this.entity_ == null) {
                    return OnestoreEntity.EntityProto.IMMUTABLE_DEFAULT_INSTANCE;
                }
                return this.entity_;
            }

            public final boolean hasEntity() {
                return (this.optional_0_ & 1) != 0;
            }

            public Entity clearEntity() {
                this.optional_0_ &= 0xFFFFFFFE;
                if (this.entity_ != null) {
                    this.entity_.clear();
                }
                return this;
            }

            public Entity setEntity(OnestoreEntity.EntityProto x) {
                if (x == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.entity_ = x;
                return this;
            }

            public OnestoreEntity.EntityProto getMutableEntity() {
                this.optional_0_ |= 1;
                if (this.entity_ == null) {
                    this.entity_ = new OnestoreEntity.EntityProto();
                }
                return this.entity_;
            }

            @Override
            public Entity mergeFrom(Entity that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    OnestoreEntity.EntityProto v = this.entity_;
                    if (v == null) {
                        this.entity_ = v = new OnestoreEntity.EntityProto();
                    }
                    v.mergeFrom(that.entity_);
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Entity that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Entity that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Entity that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !this.entity_.equals(that.entity_, ignoreUninterpreted)) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Entity && this.equals((Entity)that);
            }

            @Override
            public int hashCode() {
                int hash = -1979940775;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? this.entity_.hashCode() : -113);
                if ((this_t0 & 2) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                String e;
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 0 && (e = this.entity_.findInitializationError()) != null) {
                    return e;
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 1;
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 0) {
                    n += 1 + Protocol.stringSize(this.entity_.encodingSize());
                }
                return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 1;
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 0) {
                    n += 6 + this.entity_.maxEncodingSize();
                }
                return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 2;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                if (this.entity_ != null) {
                    this.entity_.clear();
                }
                this.uninterpreted = null;
            }

            @Override
            public Entity newInstance() {
                return new Entity();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 0) {
                    sink.putByte((byte)18);
                    sink.putForeign(this.entity_);
                }
                if ((this_t0 & 2) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)12);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block5: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 12: {
                            break block5;
                        }
                        case 0: {
                            result = false;
                            break block5;
                        }
                        case 18: {
                            source.push(source.getVarInt());
                            OnestoreEntity.EntityProto v2 = this.entity_;
                            if (v2 == null) {
                                this.entity_ = v2 = new OnestoreEntity.EntityProto();
                            }
                            if (!v2.merge(source)) {
                                result = false;
                                break block5;
                            }
                            source.pop();
                            this_t0 |= 1;
                            continue block5;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 2;
                            continue block5;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Entity freeze() {
                if (this.entity_ != null) {
                    this.entity_.freeze();
                }
                return this;
            }

            @Override
            public Entity unfreeze() {
                if (this.entity_ != null) {
                    this.entity_.unfreeze();
                }
                return this;
            }

            @Override
            public boolean isFrozen() {
                return this.entity_ != null && this.entity_.isFrozen();
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Entity.class, null, new ProtocolType.FieldType("entity", "entity", 2, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, OnestoreEntity.EntityProto.class));

                private StaticHolder() {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetRequest
    extends ProtocolMessage<GetRequest> {
        private static final long serialVersionUID = 1L;
        private List<OnestoreEntity.Reference> key_ = null;
        private Transaction transaction_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final GetRequest IMMUTABLE_DEFAULT_INSTANCE = new GetRequest(){
            private static final long serialVersionUID = 1L;

            public GetRequest clearKey() {
                return this;
            }

            public OnestoreEntity.Reference getMutableKey(int i) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference addKey() {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference addKey(OnestoreEntity.Reference v) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference insertKey(int i, OnestoreEntity.Reference v) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Reference removeKey(int i) {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public GetRequest clearTransaction() {
                return this;
            }

            public GetRequest setTransaction(Transaction x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Transaction getMutableTransaction() {
                return (Transaction)ProtocolSupport.unsupportedOperation();
            }

            public GetRequest mergeFrom(GetRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public GetRequest freeze() {
                return this;
            }

            public GetRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kkey = 1;
        public static final int ktransaction = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int keySize() {
            return this.key_ != null ? this.key_.size() : 0;
        }

        public final OnestoreEntity.Reference getKey(int i) {
            assert (i >= 0 && i < (this.key_ != null ? this.key_.size() : 0));
            return this.key_.get(i);
        }

        public GetRequest clearKey() {
            if (this.key_ != null) {
                this.key_.clear();
            }
            return this;
        }

        public OnestoreEntity.Reference getMutableKey(int i) {
            assert (i >= 0 && this.key_ != null && i < this.key_.size());
            return this.key_.get(i);
        }

        public OnestoreEntity.Reference addKey() {
            OnestoreEntity.Reference v = new OnestoreEntity.Reference();
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(v);
            return v;
        }

        public OnestoreEntity.Reference addKey(OnestoreEntity.Reference v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(v);
            return v;
        }

        public OnestoreEntity.Reference insertKey(int i, OnestoreEntity.Reference v) {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            this.key_.add(i, v);
            return v;
        }

        public OnestoreEntity.Reference removeKey(int i) {
            return this.key_.remove(i);
        }

        public final Iterator<OnestoreEntity.Reference> keyIterator() {
            if (this.key_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.key_.iterator();
        }

        public final List<OnestoreEntity.Reference> keys() {
            return ProtocolSupport.unmodifiableList(this.key_);
        }

        public final List<OnestoreEntity.Reference> mutableKeys() {
            if (this.key_ == null) {
                this.key_ = new ArrayList<OnestoreEntity.Reference>(4);
            }
            return this.key_;
        }

        public final Transaction getTransaction() {
            if (this.transaction_ == null) {
                return Transaction.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.transaction_;
        }

        public final boolean hasTransaction() {
            return (this.optional_0_ & 1) != 0;
        }

        public GetRequest clearTransaction() {
            this.optional_0_ &= 0xFFFFFFFE;
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            return this;
        }

        public GetRequest setTransaction(Transaction x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.transaction_ = x;
            return this;
        }

        public Transaction getMutableTransaction() {
            this.optional_0_ |= 1;
            if (this.transaction_ == null) {
                this.transaction_ = new Transaction();
            }
            return this.transaction_;
        }

        @Override
        public GetRequest mergeFrom(GetRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.key_ != null) {
                for (OnestoreEntity.Reference v : that.key_) {
                    this.addKey().mergeFrom(v);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                Transaction v = this.transaction_;
                if (v == null) {
                    this.transaction_ = v = new Transaction();
                }
                v.mergeFrom(that.transaction_);
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(GetRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(GetRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(GetRequest that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            int n = this.key_ != null ? this.key_.size() : 0;
            if (n != (that.key_ != null ? that.key_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.key_.get(i).equals(that.key_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !this.transaction_.equals(that.transaction_, ignoreUninterpreted)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof GetRequest && this.equals((GetRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = 2060036071;
            hash *= 31;
            int n2 = n = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.key_.get(i).hashCode();
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.transaction_.hashCode() : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            int this_t0;
            if (this.key_ != null) {
                for (OnestoreEntity.Reference v : this.key_) {
                    String e2 = v.findInitializationError();
                    if (e2 == null) continue;
                    return e2;
                }
            }
            if (((this_t0 = this.optional_0_) & 1) != 0 && (e = this.transaction_.findInitializationError()) != null) {
                return e;
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.key_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.stringSize(this.transaction_.encodingSize());
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int m = this.key_ != null ? this.key_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.key_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                n += 6 + this.transaction_.maxEncodingSize();
            }
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.key_ != null) {
                this.key_.clear();
            }
            if (this.transaction_ != null) {
                this.transaction_.clear();
            }
            this.uninterpreted = null;
        }

        @Override
        public GetRequest newInstance() {
            return new GetRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.key_ != null ? this.key_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.Reference v = this.key_.get(i);
                sink.putByte((byte)10);
                sink.putForeign(v);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)18);
                sink.putForeign(this.transaction_);
            }
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        source.push(source.getVarInt());
                        if (!this.addKey().merge(source)) {
                            result = false;
                            break block5;
                        }
                        source.pop();
                        continue block5;
                    }
                    case 18: {
                        source.push(source.getVarInt());
                        Transaction v2 = this.transaction_;
                        if (v2 == null) {
                            this.transaction_ = v2 = new Transaction();
                        }
                        if (!v2.merge(source)) {
                            result = false;
                            break block5;
                        }
                        source.pop();
                        this_t0 |= 1;
                        continue block5;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public GetRequest freeze() {
            this.key_ = ProtocolSupport.freezeMessages(this.key_);
            if (this.transaction_ != null) {
                this.transaction_.freeze();
            }
            return this;
        }

        @Override
        public GetRequest unfreeze() {
            this.key_ = ProtocolSupport.unfreezeMessages(this.key_);
            if (this.transaction_ != null) {
                this.transaction_.unfreeze();
            }
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.key_) || this.transaction_ != null && this.transaction_.isFrozen();
        }

        static {
            GetRequest.text[0] = "ErrorCode";
            GetRequest.text[1] = "key";
            GetRequest.text[2] = "transaction";
            types = new int[3];
            Arrays.fill(types, 6);
            GetRequest.types[0] = 0;
            GetRequest.types[1] = 2;
            GetRequest.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(GetRequest.class, "Z'apphosting/datastore/datastore_v3.proto\n\"apphosting_datastore_v3.GetRequest\u0013\u001a\u0003key \u0001(\u00020\u000b8\u0003J\u001dstorage_onestore_v3.Reference\u0014\u0013\u001a\u000btransaction \u0002(\u00020\u000b8\u0001J#apphosting_datastore_v3.Transaction\u0014", new ProtocolType.FieldType("key", "key", 1, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.Reference.class), new ProtocolType.FieldType("transaction", "transaction", 2, 0, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Transaction.class));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cost
    extends ProtocolMessage<Cost> {
        private static final long serialVersionUID = 1L;
        private int index_writes_ = 0;
        private int index_write_bytes_ = 0;
        private int entity_writes_ = 0;
        private int entity_write_bytes_ = 0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Cost IMMUTABLE_DEFAULT_INSTANCE = new Cost(){
            private static final long serialVersionUID = 1L;

            public Cost clearIndexWrites() {
                return this;
            }

            public Cost setIndexWrites(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost clearIndexWriteBytes() {
                return this;
            }

            public Cost setIndexWriteBytes(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost clearEntityWrites() {
                return this;
            }

            public Cost setEntityWrites(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost clearEntityWriteBytes() {
                return this;
            }

            public Cost setEntityWriteBytes(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cost mergeFrom(Cost that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Cost freeze() {
                return this;
            }

            public Cost unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kindex_writes = 1;
        public static final int kindex_write_bytes = 2;
        public static final int kentity_writes = 3;
        public static final int kentity_write_bytes = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int getIndexWrites() {
            return this.index_writes_;
        }

        public final boolean hasIndexWrites() {
            return (this.optional_0_ & 1) != 0;
        }

        public Cost clearIndexWrites() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.index_writes_ = 0;
            return this;
        }

        public Cost setIndexWrites(int x) {
            this.optional_0_ |= 1;
            this.index_writes_ = x;
            return this;
        }

        public final int getIndexWriteBytes() {
            return this.index_write_bytes_;
        }

        public final boolean hasIndexWriteBytes() {
            return (this.optional_0_ & 2) != 0;
        }

        public Cost clearIndexWriteBytes() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.index_write_bytes_ = 0;
            return this;
        }

        public Cost setIndexWriteBytes(int x) {
            this.optional_0_ |= 2;
            this.index_write_bytes_ = x;
            return this;
        }

        public final int getEntityWrites() {
            return this.entity_writes_;
        }

        public final boolean hasEntityWrites() {
            return (this.optional_0_ & 4) != 0;
        }

        public Cost clearEntityWrites() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.entity_writes_ = 0;
            return this;
        }

        public Cost setEntityWrites(int x) {
            this.optional_0_ |= 4;
            this.entity_writes_ = x;
            return this;
        }

        public final int getEntityWriteBytes() {
            return this.entity_write_bytes_;
        }

        public final boolean hasEntityWriteBytes() {
            return (this.optional_0_ & 8) != 0;
        }

        public Cost clearEntityWriteBytes() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.entity_write_bytes_ = 0;
            return this;
        }

        public Cost setEntityWriteBytes(int x) {
            this.optional_0_ |= 8;
            this.entity_write_bytes_ = x;
            return this;
        }

        @Override
        public Cost mergeFrom(Cost that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.index_writes_ = that.index_writes_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.index_write_bytes_ = that.index_write_bytes_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.entity_writes_ = that.entity_writes_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.entity_write_bytes_ = that.entity_write_bytes_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Cost that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Cost that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Cost that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFEF) != (that_t0 & 0xFFFFFFEF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.index_writes_ != that.index_writes_) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.index_write_bytes_ != that.index_write_bytes_) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.entity_writes_ != that.entity_writes_) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.entity_write_bytes_ != that.entity_write_bytes_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x10) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Cost && this.equals((Cost)that);
        }

        @Override
        public int hashCode() {
            int hash = -160304242;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? this.index_writes_ : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.index_write_bytes_ : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? this.entity_writes_ : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? this.entity_write_bytes_ : -113);
            if ((this_t0 & 0x10) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xF) != 0) {
                if ((this_t0 & 1) != 0) {
                    n += 1 + Protocol.varLongSize(this.index_writes_);
                }
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.varLongSize(this.index_write_bytes_);
                }
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.varLongSize(this.entity_writes_);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.varLongSize(this.entity_write_bytes_);
                }
            }
            return (this_t0 & 0x10) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 44;
            int this_t0 = this.optional_0_;
            return (this_t0 & 0x10) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x10;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.index_writes_ = 0;
            this.index_write_bytes_ = 0;
            this.entity_writes_ = 0;
            this.entity_write_bytes_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public Cost newInstance() {
            return new Cost();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)8);
                sink.putVarLong(this.index_writes_);
            }
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)16);
                sink.putVarLong(this.index_write_bytes_);
            }
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)24);
                sink.putVarLong(this.entity_writes_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)32);
                sink.putVarLong(this.entity_write_bytes_);
            }
            if ((this_t0 & 0x10) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block7: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block7;
                    }
                    case 8: {
                        this.index_writes_ = source.getVarInt();
                        this_t0 |= 1;
                        continue block7;
                    }
                    case 16: {
                        this.index_write_bytes_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block7;
                    }
                    case 24: {
                        this.entity_writes_ = source.getVarInt();
                        this_t0 |= 4;
                        continue block7;
                    }
                    case 32: {
                        this.entity_write_bytes_ = source.getVarInt();
                        this_t0 |= 8;
                        continue block7;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x10;
                        continue block7;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            Cost.text[0] = "ErrorCode";
            Cost.text[1] = "index_writes";
            Cost.text[2] = "index_write_bytes";
            Cost.text[3] = "entity_writes";
            Cost.text[4] = "entity_write_bytes";
            types = new int[5];
            Arrays.fill(types, 6);
            Cost.types[0] = 0;
            Cost.types[1] = 0;
            Cost.types[2] = 0;
            Cost.types[3] = 0;
            Cost.types[4] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Cost.class, "Z'apphosting/datastore/datastore_v3.proto\n\u001capphosting_datastore_v3.Cost\u0013\u001a\findex_writes \u0001(\u00000\u00058\u0001\u0014\u0013\u001a\u0011index_write_bytes \u0002(\u00000\u00058\u0001\u0014\u0013\u001a\rentity_writes \u0003(\u00000\u00058\u0001\u0014\u0013\u001a\u0012entity_write_bytes \u0004(\u00000\u00058\u0001\u0014", new ProtocolType.FieldType("index_writes", "index_writes", 1, 0, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("index_write_bytes", "index_write_bytes", 2, 1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("entity_writes", "entity_writes", 3, 2, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("entity_write_bytes", "entity_write_bytes", 4, 3, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Error
    extends ProtocolMessage<Error> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Error IMMUTABLE_DEFAULT_INSTANCE = new Error(){
            private static final long serialVersionUID = 1L;

            public Error mergeFrom(Error that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Error freeze() {
                return this;
            }

            public Error unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public Error mergeFrom(Error that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Error that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Error that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Error that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFE) != (that_t0 & 0xFFFFFFFE)) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 1) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Error && this.equals((Error)that);
        }

        @Override
        public int hashCode() {
            int hash = -1068360440;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 1;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public Error newInstance() {
            return new Error();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 1;
                        continue block3;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            Error.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            Error.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Error.class, "Z'apphosting/datastore/datastore_v3.proto\n\u001dapphosting_datastore_v3.Errorsz\tErrorCode\u008b\u0001\u0092\u0001\u000bBAD_REQUEST\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u0016CONCURRENT_TRANSACTION\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u000eINTERNAL_ERROR\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\nNEED_INDEX\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0007TIMEOUT\u0098\u0001\u0005\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            BAD_REQUEST(1),
            CONCURRENT_TRANSACTION(2),
            INTERNAL_ERROR(3),
            NEED_INDEX(4),
            TIMEOUT(5);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 1: {
                        return BAD_REQUEST;
                    }
                    case 2: {
                        return CONCURRENT_TRANSACTION;
                    }
                    case 3: {
                        return INTERNAL_ERROR;
                    }
                    case 4: {
                        return NEED_INDEX;
                    }
                    case 5: {
                        return TIMEOUT;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = BAD_REQUEST;
                ErrorCode_MAX = TIMEOUT;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cursor
    extends ProtocolMessage<Cursor> {
        private static final long serialVersionUID = 1L;
        private long cursor_ = 0L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Cursor IMMUTABLE_DEFAULT_INSTANCE = new Cursor(){
            private static final long serialVersionUID = 1L;

            public Cursor clearCursor() {
                return this;
            }

            public Cursor setCursor(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Cursor mergeFrom(Cursor that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Cursor freeze() {
                return this;
            }

            public Cursor unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kcursor = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final long getCursor() {
            return this.cursor_;
        }

        public final boolean hasCursor() {
            return (this.optional_0_ & 1) != 0;
        }

        public Cursor clearCursor() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.cursor_ = 0L;
            return this;
        }

        public Cursor setCursor(long x) {
            this.optional_0_ |= 1;
            this.cursor_ = x;
            return this;
        }

        @Override
        public Cursor mergeFrom(Cursor that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.cursor_ = that.cursor_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Cursor that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Cursor that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Cursor that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.cursor_ != that.cursor_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Cursor && this.equals((Cursor)that);
        }

        @Override
        public int hashCode() {
            int hash = 234521377;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode(this.cursor_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 1) {
                return "missing field: cursor";
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 9;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 9;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.cursor_ = 0L;
            this.uninterpreted = null;
        }

        @Override
        public Cursor newInstance() {
            return new Cursor();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)9);
            sink.putLong(this.cursor_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 9: {
                        this.cursor_ = source.getLong();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            Cursor.text[0] = "ErrorCode";
            Cursor.text[1] = "cursor";
            types = new int[2];
            Arrays.fill(types, 6);
            Cursor.types[0] = 0;
            Cursor.types[1] = 1;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Cursor.class, "Z'apphosting/datastore/datastore_v3.proto\n\u001eapphosting_datastore_v3.Cursor\u0013\u001a\u0006cursor \u0001(\u00010\u00068\u0002\u0014", new ProtocolType.FieldType("cursor", "cursor", 1, 0, ProtocolType.FieldBaseType.FIXED64, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryExplanation
    extends ProtocolMessage<QueryExplanation> {
        private static final long serialVersionUID = 1L;
        private boolean native_ancestor_ = false;
        private List<OnestoreEntity.Index> native_index_ = null;
        private int native_offset_ = 0;
        private int native_limit_ = 0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final QueryExplanation IMMUTABLE_DEFAULT_INSTANCE = new QueryExplanation(){
            private static final long serialVersionUID = 1L;

            public QueryExplanation clearNativeAncestor() {
                return this;
            }

            public QueryExplanation setNativeAncestor(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public QueryExplanation clearNativeIndex() {
                return this;
            }

            public OnestoreEntity.Index getMutableNativeIndex(int i) {
                return (OnestoreEntity.Index)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Index addNativeIndex() {
                return (OnestoreEntity.Index)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Index addNativeIndex(OnestoreEntity.Index v) {
                return (OnestoreEntity.Index)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Index insertNativeIndex(int i, OnestoreEntity.Index v) {
                return (OnestoreEntity.Index)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.Index removeNativeIndex(int i) {
                return (OnestoreEntity.Index)ProtocolSupport.unsupportedOperation();
            }

            public QueryExplanation clearNativeOffset() {
                return this;
            }

            public QueryExplanation setNativeOffset(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public QueryExplanation clearNativeLimit() {
                return this;
            }

            public QueryExplanation setNativeLimit(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public QueryExplanation mergeFrom(QueryExplanation that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public QueryExplanation freeze() {
                return this;
            }

            public QueryExplanation unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int knative_ancestor = 1;
        public static final int knative_index = 2;
        public static final int knative_offset = 3;
        public static final int knative_limit = 4;
        public static final String[] text = new String[5];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final boolean isNativeAncestor() {
            return this.native_ancestor_;
        }

        public final boolean hasNativeAncestor() {
            return (this.optional_0_ & 1) != 0;
        }

        public QueryExplanation clearNativeAncestor() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.native_ancestor_ = false;
            return this;
        }

        public QueryExplanation setNativeAncestor(boolean x) {
            this.optional_0_ |= 1;
            this.native_ancestor_ = x;
            return this;
        }

        public final int nativeIndexSize() {
            return this.native_index_ != null ? this.native_index_.size() : 0;
        }

        public final OnestoreEntity.Index getNativeIndex(int i) {
            assert (i >= 0 && i < (this.native_index_ != null ? this.native_index_.size() : 0));
            return this.native_index_.get(i);
        }

        public QueryExplanation clearNativeIndex() {
            if (this.native_index_ != null) {
                this.native_index_.clear();
            }
            return this;
        }

        public OnestoreEntity.Index getMutableNativeIndex(int i) {
            assert (i >= 0 && this.native_index_ != null && i < this.native_index_.size());
            return this.native_index_.get(i);
        }

        public OnestoreEntity.Index addNativeIndex() {
            OnestoreEntity.Index v = new OnestoreEntity.Index();
            if (this.native_index_ == null) {
                this.native_index_ = new ArrayList<OnestoreEntity.Index>(4);
            }
            this.native_index_.add(v);
            return v;
        }

        public OnestoreEntity.Index addNativeIndex(OnestoreEntity.Index v) {
            if (this.native_index_ == null) {
                this.native_index_ = new ArrayList<OnestoreEntity.Index>(4);
            }
            this.native_index_.add(v);
            return v;
        }

        public OnestoreEntity.Index insertNativeIndex(int i, OnestoreEntity.Index v) {
            if (this.native_index_ == null) {
                this.native_index_ = new ArrayList<OnestoreEntity.Index>(4);
            }
            this.native_index_.add(i, v);
            return v;
        }

        public OnestoreEntity.Index removeNativeIndex(int i) {
            return this.native_index_.remove(i);
        }

        public final Iterator<OnestoreEntity.Index> nativeIndexIterator() {
            if (this.native_index_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.native_index_.iterator();
        }

        public final List<OnestoreEntity.Index> nativeIndexs() {
            return ProtocolSupport.unmodifiableList(this.native_index_);
        }

        public final List<OnestoreEntity.Index> mutableNativeIndexs() {
            if (this.native_index_ == null) {
                this.native_index_ = new ArrayList<OnestoreEntity.Index>(4);
            }
            return this.native_index_;
        }

        public final int getNativeOffset() {
            return this.native_offset_;
        }

        public final boolean hasNativeOffset() {
            return (this.optional_0_ & 2) != 0;
        }

        public QueryExplanation clearNativeOffset() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.native_offset_ = 0;
            return this;
        }

        public QueryExplanation setNativeOffset(int x) {
            this.optional_0_ |= 2;
            this.native_offset_ = x;
            return this;
        }

        public final int getNativeLimit() {
            return this.native_limit_;
        }

        public final boolean hasNativeLimit() {
            return (this.optional_0_ & 4) != 0;
        }

        public QueryExplanation clearNativeLimit() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.native_limit_ = 0;
            return this;
        }

        public QueryExplanation setNativeLimit(int x) {
            this.optional_0_ |= 4;
            this.native_limit_ = x;
            return this;
        }

        @Override
        public QueryExplanation mergeFrom(QueryExplanation that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.native_ancestor_ = that.native_ancestor_;
            }
            if (that.native_index_ != null) {
                for (OnestoreEntity.Index v : that.native_index_) {
                    this.addNativeIndex().mergeFrom(v);
                }
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.native_offset_ = that.native_offset_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.native_limit_ = that.native_limit_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(QueryExplanation that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(QueryExplanation that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(QueryExplanation that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFF7) != (that_t0 & 0xFFFFFFF7)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.native_ancestor_ != that.native_ancestor_) {
                return false;
            }
            int n = this.native_index_ != null ? this.native_index_.size() : 0;
            if (n != (that.native_index_ != null ? that.native_index_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.native_index_.get(i).equals(that.native_index_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 2) != 0 && this.native_offset_ != that.native_offset_) {
                return false;
            }
            if ((this_t0 & 4) != 0 && this.native_limit_ != that.native_limit_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 8) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof QueryExplanation && this.equals((QueryExplanation)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -285253701;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? (this.native_ancestor_ ? 1231 : 1237) : -113);
            hash *= 31;
            int n2 = n = this.native_index_ != null ? this.native_index_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.native_index_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.native_offset_ : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? this.native_limit_ : -113);
            if ((this_t0 & 8) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            if (this.native_index_ != null) {
                for (OnestoreEntity.Index v : this.native_index_) {
                    String e = v.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.native_index_ != null ? this.native_index_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.native_index_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 7) != 0) {
                if ((this_t0 & 1) != 0) {
                    n += 2;
                }
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.varLongSize(this.native_offset_);
                }
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.varLongSize(this.native_limit_);
                }
            }
            return (this_t0 & 8) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 24;
            int m = this.native_index_ != null ? this.native_index_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.native_index_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            return (this_t0 & 8) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 8;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.native_ancestor_ = false;
            if (this.native_index_ != null) {
                this.native_index_.clear();
            }
            this.native_offset_ = 0;
            this.native_limit_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public QueryExplanation newInstance() {
            return new QueryExplanation();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 0) {
                sink.putByte((byte)8);
                sink.putBoolean(this.native_ancestor_);
            }
            int n = m = this.native_index_ != null ? this.native_index_.size() : 0;
            for (int i = 0; i < m; ++i) {
                OnestoreEntity.Index v = this.native_index_.get(i);
                sink.putByte((byte)18);
                sink.putForeign(v);
            }
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)24);
                sink.putVarLong(this.native_offset_);
            }
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)32);
                sink.putVarLong(this.native_limit_);
            }
            if ((this_t0 & 8) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block7: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block7;
                    }
                    case 8: {
                        this.native_ancestor_ = source.getBoolean();
                        this_t0 |= 1;
                        continue block7;
                    }
                    case 18: {
                        source.push(source.getVarInt());
                        if (!this.addNativeIndex().merge(source)) {
                            result = false;
                            break block7;
                        }
                        source.pop();
                        continue block7;
                    }
                    case 24: {
                        this.native_offset_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block7;
                    }
                    case 32: {
                        this.native_limit_ = source.getVarInt();
                        this_t0 |= 4;
                        continue block7;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 8;
                        continue block7;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public QueryExplanation freeze() {
            this.native_index_ = ProtocolSupport.freezeMessages(this.native_index_);
            return this;
        }

        @Override
        public QueryExplanation unfreeze() {
            this.native_index_ = ProtocolSupport.unfreezeMessages(this.native_index_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenMessages(this.native_index_);
        }

        static {
            QueryExplanation.text[0] = "ErrorCode";
            QueryExplanation.text[1] = "native_ancestor";
            QueryExplanation.text[2] = "native_index";
            QueryExplanation.text[3] = "native_offset";
            QueryExplanation.text[4] = "native_limit";
            types = new int[5];
            Arrays.fill(types, 6);
            QueryExplanation.types[0] = 0;
            QueryExplanation.types[1] = 0;
            QueryExplanation.types[2] = 2;
            QueryExplanation.types[3] = 0;
            QueryExplanation.types[4] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(QueryExplanation.class, "Z'apphosting/datastore/datastore_v3.proto\n(apphosting_datastore_v3.QueryExplanation\u0013\u001a\u000fnative_ancestor \u0001(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014\u0013\u001a\fnative_index \u0002(\u00020\u000b8\u0003J\u0019storage_onestore_v3.Index\u0014\u0013\u001a\rnative_offset \u0003(\u00000\u00058\u0001\u0014\u0013\u001a\fnative_limit \u0004(\u00000\u00058\u0001\u0014", new ProtocolType.FieldType("native_ancestor", "native_ancestor", 1, 0, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("native_index", "native_index", 2, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.Index.class), new ProtocolType.FieldType("native_offset", "native_offset", 3, 1, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("native_limit", "native_limit", 4, 2, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Query
    extends ProtocolMessage<Query> {
        private static final long serialVersionUID = 1L;
        private byte[] app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] kind_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private OnestoreEntity.Reference ancestor_ = null;
        private List<Filter> filter_ = null;
        private byte[] search_query_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<Order> order_ = null;
        private int hint_ = 0;
        private int offset_ = 0;
        private int limit_ = 0;
        private List<OnestoreEntity.CompositeIndex> composite_index_ = null;
        private boolean require_perfect_plan_ = false;
        private boolean keys_only_ = false;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Query IMMUTABLE_DEFAULT_INSTANCE = new Query(){
            private static final long serialVersionUID = 1L;

            public Query clearApp() {
                return this;
            }

            public Query setAppAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query setApp(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query setApp(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearKind() {
                return this;
            }

            public Query setKindAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query setKind(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query setKind(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearAncestor() {
                return this;
            }

            public Query setAncestor(OnestoreEntity.Reference x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public OnestoreEntity.Reference getMutableAncestor() {
                return (OnestoreEntity.Reference)ProtocolSupport.unsupportedOperation();
            }

            public Query clearFilter() {
                return this;
            }

            public Filter getMutableFilter(int i) {
                return (Filter)ProtocolSupport.unsupportedOperation();
            }

            public Filter addFilter() {
                return (Filter)ProtocolSupport.unsupportedOperation();
            }

            public Filter addFilter(Filter v) {
                return (Filter)ProtocolSupport.unsupportedOperation();
            }

            public Filter insertFilter(int i, Filter v) {
                return (Filter)ProtocolSupport.unsupportedOperation();
            }

            public Filter removeFilter(int i) {
                return (Filter)ProtocolSupport.unsupportedOperation();
            }

            public Query clearSearchQuery() {
                return this;
            }

            public Query setSearchQueryAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query setSearchQuery(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query setSearchQuery(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearOrder() {
                return this;
            }

            public Order getMutableOrder(int i) {
                return (Order)ProtocolSupport.unsupportedOperation();
            }

            public Order addOrder() {
                return (Order)ProtocolSupport.unsupportedOperation();
            }

            public Order addOrder(Order v) {
                return (Order)ProtocolSupport.unsupportedOperation();
            }

            public Order insertOrder(int i, Order v) {
                return (Order)ProtocolSupport.unsupportedOperation();
            }

            public Order removeOrder(int i) {
                return (Order)ProtocolSupport.unsupportedOperation();
            }

            public Query clearHint() {
                return this;
            }

            public Query setHint(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearOffset() {
                return this;
            }

            public Query setOffset(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearLimit() {
                return this;
            }

            public Query setLimit(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearCompositeIndex() {
                return this;
            }

            public OnestoreEntity.CompositeIndex getMutableCompositeIndex(int i) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex addCompositeIndex() {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex addCompositeIndex(OnestoreEntity.CompositeIndex v) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex insertCompositeIndex(int i, OnestoreEntity.CompositeIndex v) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public OnestoreEntity.CompositeIndex removeCompositeIndex(int i) {
                return (OnestoreEntity.CompositeIndex)ProtocolSupport.unsupportedOperation();
            }

            public Query clearRequirePerfectPlan() {
                return this;
            }

            public Query setRequirePerfectPlan(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query clearKeysOnly() {
                return this;
            }

            public Query setKeysOnly(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Query mergeFrom(Query that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Query freeze() {
                return this;
            }

            public Query unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kapp = 1;
        public static final int kkind = 3;
        public static final int kancestor = 17;
        public static final int kFilterGroup = 4;
        public static final int kFilterop = 6;
        public static final int kFilterproperty = 14;
        public static final int ksearch_query = 8;
        public static final int kOrderGroup = 9;
        public static final int kOrderproperty = 10;
        public static final int kOrderdirection = 11;
        public static final int khint = 18;
        public static final int koffset = 12;
        public static final int klimit = 16;
        public static final int kcomposite_index = 19;
        public static final int krequire_perfect_plan = 20;
        public static final int kkeys_only = 21;
        public static final String[] text = new String[22];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getAppAsBytes() {
            return this.app_;
        }

        public final boolean hasApp() {
            return (this.optional_0_ & 1) != 0;
        }

        public Query clearApp() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Query setAppAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.app_ = x;
            return this;
        }

        public final String getApp() {
            return ProtocolSupport.toStringUtf8(this.app_);
        }

        public Query setApp(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getApp(Charset cs) {
            return ProtocolSupport.toString(this.app_, cs);
        }

        public Query setApp(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.app_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getKindAsBytes() {
            return this.kind_;
        }

        public final boolean hasKind() {
            return (this.optional_0_ & 2) != 0;
        }

        public Query clearKind() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.kind_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Query setKindAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.kind_ = x;
            return this;
        }

        public final String getKind() {
            return ProtocolSupport.toStringUtf8(this.kind_);
        }

        public Query setKind(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.kind_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getKind(Charset cs) {
            return ProtocolSupport.toString(this.kind_, cs);
        }

        public Query setKind(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.kind_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final OnestoreEntity.Reference getAncestor() {
            if (this.ancestor_ == null) {
                return OnestoreEntity.Reference.IMMUTABLE_DEFAULT_INSTANCE;
            }
            return this.ancestor_;
        }

        public final boolean hasAncestor() {
            return (this.optional_0_ & 4) != 0;
        }

        public Query clearAncestor() {
            this.optional_0_ &= 0xFFFFFFFB;
            if (this.ancestor_ != null) {
                this.ancestor_.clear();
            }
            return this;
        }

        public Query setAncestor(OnestoreEntity.Reference x) {
            if (x == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.ancestor_ = x;
            return this;
        }

        public OnestoreEntity.Reference getMutableAncestor() {
            this.optional_0_ |= 4;
            if (this.ancestor_ == null) {
                this.ancestor_ = new OnestoreEntity.Reference();
            }
            return this.ancestor_;
        }

        public final int filterSize() {
            return this.filter_ != null ? this.filter_.size() : 0;
        }

        public final Filter getFilter(int i) {
            assert (i >= 0 && i < (this.filter_ != null ? this.filter_.size() : 0));
            return this.filter_.get(i);
        }

        public Query clearFilter() {
            if (this.filter_ != null) {
                this.filter_.clear();
            }
            return this;
        }

        public Filter getMutableFilter(int i) {
            assert (i >= 0 && this.filter_ != null && i < this.filter_.size());
            return this.filter_.get(i);
        }

        public Filter addFilter() {
            Filter v = new Filter();
            if (this.filter_ == null) {
                this.filter_ = new ArrayList<Filter>(4);
            }
            this.filter_.add(v);
            return v;
        }

        public Filter addFilter(Filter v) {
            if (this.filter_ == null) {
                this.filter_ = new ArrayList<Filter>(4);
            }
            this.filter_.add(v);
            return v;
        }

        public Filter insertFilter(int i, Filter v) {
            if (this.filter_ == null) {
                this.filter_ = new ArrayList<Filter>(4);
            }
            this.filter_.add(i, v);
            return v;
        }

        public Filter removeFilter(int i) {
            return this.filter_.remove(i);
        }

        public final Iterator<Filter> filterIterator() {
            if (this.filter_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.filter_.iterator();
        }

        public final List<Filter> filters() {
            return ProtocolSupport.unmodifiableList(this.filter_);
        }

        public final List<Filter> mutableFilters() {
            if (this.filter_ == null) {
                this.filter_ = new ArrayList<Filter>(4);
            }
            return this.filter_;
        }

        public final byte[] getSearchQueryAsBytes() {
            return this.search_query_;
        }

        public final boolean hasSearchQuery() {
            return (this.optional_0_ & 8) != 0;
        }

        public Query clearSearchQuery() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.search_query_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public Query setSearchQueryAsBytes(byte[] x) {
            this.optional_0_ |= 8;
            this.search_query_ = x;
            return this;
        }

        public final String getSearchQuery() {
            return ProtocolSupport.toStringUtf8(this.search_query_);
        }

        public Query setSearchQuery(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.search_query_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getSearchQuery(Charset cs) {
            return ProtocolSupport.toString(this.search_query_, cs);
        }

        public Query setSearchQuery(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.search_query_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int orderSize() {
            return this.order_ != null ? this.order_.size() : 0;
        }

        public final Order getOrder(int i) {
            assert (i >= 0 && i < (this.order_ != null ? this.order_.size() : 0));
            return this.order_.get(i);
        }

        public Query clearOrder() {
            if (this.order_ != null) {
                this.order_.clear();
            }
            return this;
        }

        public Order getMutableOrder(int i) {
            assert (i >= 0 && this.order_ != null && i < this.order_.size());
            return this.order_.get(i);
        }

        public Order addOrder() {
            Order v = new Order();
            if (this.order_ == null) {
                this.order_ = new ArrayList<Order>(4);
            }
            this.order_.add(v);
            return v;
        }

        public Order addOrder(Order v) {
            if (this.order_ == null) {
                this.order_ = new ArrayList<Order>(4);
            }
            this.order_.add(v);
            return v;
        }

        public Order insertOrder(int i, Order v) {
            if (this.order_ == null) {
                this.order_ = new ArrayList<Order>(4);
            }
            this.order_.add(i, v);
            return v;
        }

        public Order removeOrder(int i) {
            return this.order_.remove(i);
        }

        public final Iterator<Order> orderIterator() {
            if (this.order_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.order_.iterator();
        }

        public final List<Order> orders() {
            return ProtocolSupport.unmodifiableList(this.order_);
        }

        public final List<Order> mutableOrders() {
            if (this.order_ == null) {
                this.order_ = new ArrayList<Order>(4);
            }
            return this.order_;
        }

        public final int getHint() {
            return this.hint_;
        }

        public Hint getHintEnum() {
            return Hint.valueOf(this.getHint());
        }

        public final boolean hasHint() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public Query clearHint() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.hint_ = 0;
            return this;
        }

        public Query setHint(int x) {
            this.optional_0_ |= 0x10;
            this.hint_ = x;
            return this;
        }

        public Query setHint(Hint x) {
            if (x == null) {
                this.optional_0_ &= 0xFFFFFFEF;
                this.hint_ = 0;
            } else {
                this.setHint(x.getValue());
            }
            return this;
        }

        public final int getOffset() {
            return this.offset_;
        }

        public final boolean hasOffset() {
            return (this.optional_0_ & 0x20) != 0;
        }

        public Query clearOffset() {
            this.optional_0_ &= 0xFFFFFFDF;
            this.offset_ = 0;
            return this;
        }

        public Query setOffset(int x) {
            this.optional_0_ |= 0x20;
            this.offset_ = x;
            return this;
        }

        public final int getLimit() {
            return this.limit_;
        }

        public final boolean hasLimit() {
            return (this.optional_0_ & 0x40) != 0;
        }

        public Query clearLimit() {
            this.optional_0_ &= 0xFFFFFFBF;
            this.limit_ = 0;
            return this;
        }

        public Query setLimit(int x) {
            this.optional_0_ |= 0x40;
            this.limit_ = x;
            return this;
        }

        public final int compositeIndexSize() {
            return this.composite_index_ != null ? this.composite_index_.size() : 0;
        }

        public final OnestoreEntity.CompositeIndex getCompositeIndex(int i) {
            assert (i >= 0 && i < (this.composite_index_ != null ? this.composite_index_.size() : 0));
            return this.composite_index_.get(i);
        }

        public Query clearCompositeIndex() {
            if (this.composite_index_ != null) {
                this.composite_index_.clear();
            }
            return this;
        }

        public OnestoreEntity.CompositeIndex getMutableCompositeIndex(int i) {
            assert (i >= 0 && this.composite_index_ != null && i < this.composite_index_.size());
            return this.composite_index_.get(i);
        }

        public OnestoreEntity.CompositeIndex addCompositeIndex() {
            OnestoreEntity.CompositeIndex v = new OnestoreEntity.CompositeIndex();
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.composite_index_.add(v);
            return v;
        }

        public OnestoreEntity.CompositeIndex addCompositeIndex(OnestoreEntity.CompositeIndex v) {
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.composite_index_.add(v);
            return v;
        }

        public OnestoreEntity.CompositeIndex insertCompositeIndex(int i, OnestoreEntity.CompositeIndex v) {
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            this.composite_index_.add(i, v);
            return v;
        }

        public OnestoreEntity.CompositeIndex removeCompositeIndex(int i) {
            return this.composite_index_.remove(i);
        }

        public final Iterator<OnestoreEntity.CompositeIndex> compositeIndexIterator() {
            if (this.composite_index_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.composite_index_.iterator();
        }

        public final List<OnestoreEntity.CompositeIndex> compositeIndexs() {
            return ProtocolSupport.unmodifiableList(this.composite_index_);
        }

        public final List<OnestoreEntity.CompositeIndex> mutableCompositeIndexs() {
            if (this.composite_index_ == null) {
                this.composite_index_ = new ArrayList<OnestoreEntity.CompositeIndex>(4);
            }
            return this.composite_index_;
        }

        public final boolean isRequirePerfectPlan() {
            return this.require_perfect_plan_;
        }

        public final boolean hasRequirePerfectPlan() {
            return (this.optional_0_ & 0x80) != 0;
        }

        public Query clearRequirePerfectPlan() {
            this.optional_0_ &= 0xFFFFFF7F;
            this.require_perfect_plan_ = false;
            return this;
        }

        public Query setRequirePerfectPlan(boolean x) {
            this.optional_0_ |= 0x80;
            this.require_perfect_plan_ = x;
            return this;
        }

        public final boolean isKeysOnly() {
            return this.keys_only_;
        }

        public final boolean hasKeysOnly() {
            return (this.optional_0_ & 0x100) != 0;
        }

        public Query clearKeysOnly() {
            this.optional_0_ &= 0xFFFFFEFF;
            this.keys_only_ = false;
            return this;
        }

        public Query setKeysOnly(boolean x) {
            this.optional_0_ |= 0x100;
            this.keys_only_ = x;
            return this;
        }

        @Override
        public Query mergeFrom(Query that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.app_ = that.app_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.kind_ = that.kind_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                OnestoreEntity.Reference v = this.ancestor_;
                if (v == null) {
                    this.ancestor_ = v = new OnestoreEntity.Reference();
                }
                v.mergeFrom(that.ancestor_);
            }
            if (that.filter_ != null) {
                for (Filter filter : that.filter_) {
                    this.addFilter().mergeFrom(filter);
                }
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.search_query_ = that.search_query_;
            }
            if (that.order_ != null) {
                for (Order order : that.order_) {
                    this.addOrder().mergeFrom(order);
                }
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.hint_ = that.hint_;
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                this.offset_ = that.offset_;
            }
            if ((that_t0 & 0x40) != 0) {
                this_t0 |= 0x40;
                this.limit_ = that.limit_;
            }
            if (that.composite_index_ != null) {
                for (OnestoreEntity.CompositeIndex compositeIndex : that.composite_index_) {
                    this.addCompositeIndex().mergeFrom(compositeIndex);
                }
            }
            if ((that_t0 & 0x80) != 0) {
                this_t0 |= 0x80;
                this.require_perfect_plan_ = that.require_perfect_plan_;
            }
            if ((that_t0 & 0x100) != 0) {
                this_t0 |= 0x100;
                this.keys_only_ = that.keys_only_;
            }
            if ((that_t0 & 0x200) != 0) {
                this_t0 |= 0x200;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Query that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Query that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Query that, boolean ignoreUninterpreted) {
            int i;
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFDFF) != (that_t0 & 0xFFFFFDFF)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.app_, that.app_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.kind_, that.kind_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && !this.ancestor_.equals(that.ancestor_, ignoreUninterpreted)) {
                return false;
            }
            int n = this.filter_ != null ? this.filter_.size() : 0;
            if (n != (that.filter_ != null ? that.filter_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.filter_.get(i).equals(that.filter_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 8) != 0 && !Arrays.equals(this.search_query_, that.search_query_)) {
                return false;
            }
            n = this.order_ != null ? this.order_.size() : 0;
            if (n != (that.order_ != null ? that.order_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.order_.get(i).equals(that.order_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 0x10) != 0 && this.hint_ != that.hint_) {
                return false;
            }
            if ((this_t0 & 0x20) != 0 && this.offset_ != that.offset_) {
                return false;
            }
            if ((this_t0 & 0x40) != 0 && this.limit_ != that.limit_) {
                return false;
            }
            n = this.composite_index_ != null ? this.composite_index_.size() : 0;
            if (n != (that.composite_index_ != null ? that.composite_index_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.composite_index_.get(i).equals(that.composite_index_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            if ((this_t0 & 0x80) != 0 && this.require_perfect_plan_ != that.require_perfect_plan_) {
                return false;
            }
            if ((this_t0 & 0x100) != 0 && this.keys_only_ != that.keys_only_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 0x200) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Query && this.equals((Query)that);
        }

        @Override
        public int hashCode() {
            int i;
            int n;
            int hash = 2075045219;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.app_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.kind_) : -113);
            hash *= 31;
            int n2 = n = this.filter_ != null ? this.filter_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + this.filter_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 8) != 0 ? Arrays.hashCode(this.search_query_) : -113);
            hash *= 31;
            int n3 = n = this.order_ != null ? this.order_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + this.order_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 0x20) != 0 ? this.offset_ : -113);
            hash = hash * 31 + ((this_t0 & 0x40) != 0 ? this.limit_ : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? this.ancestor_.hashCode() : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? this.hint_ : -113);
            hash *= 31;
            int n4 = n = this.composite_index_ != null ? this.composite_index_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + this.composite_index_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 0x80) != 0 ? (this.require_perfect_plan_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 0x100) != 0 ? (this.keys_only_ ? 1231 : 1237) : -113);
            if ((this_t0 & 0x200) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            String e;
            String e2;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 1) {
                return "missing field: app";
            }
            if ((this_t0 & 4) != 0 && (e2 = this.ancestor_.findInitializationError()) != null) {
                return e2;
            }
            if (this.filter_ != null) {
                for (Filter filter : this.filter_) {
                    e = filter.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            if (this.order_ != null) {
                for (Order order : this.order_) {
                    e = order.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            if (this.composite_index_ != null) {
                for (OnestoreEntity.CompositeIndex compositeIndex : this.composite_index_) {
                    e = compositeIndex.findInitializationError();
                    if (e == null) continue;
                    return e;
                }
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int i;
            int n = 1 + Protocol.stringSize(this.app_.length);
            int m = this.filter_ != null ? this.filter_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += this.filter_.get(i).encodingSize();
            }
            m = this.order_ != null ? this.order_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += this.order_.get(i).encodingSize();
            }
            m = this.composite_index_ != null ? this.composite_index_.size() : 0;
            n += 2 * m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.composite_index_.get(i).encodingSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1FE) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.stringSize(this.kind_.length);
                }
                if ((this_t0 & 4) != 0) {
                    n += 2 + Protocol.stringSize(this.ancestor_.encodingSize());
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.stringSize(this.search_query_.length);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 2 + Protocol.varLongSize(this.hint_);
                }
                if ((this_t0 & 0x20) != 0) {
                    n += 1 + Protocol.varLongSize(this.offset_);
                }
                if ((this_t0 & 0x40) != 0) {
                    n += 2 + Protocol.varLongSize(this.limit_);
                }
                if ((this_t0 & 0x80) != 0) {
                    n += 3;
                }
                if ((this_t0 & 0x100) != 0) {
                    n += 3;
                }
            }
            return (this_t0 & 0x200) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int i;
            int n = 47 + this.app_.length;
            int m = this.filter_ != null ? this.filter_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += this.filter_.get(i).maxEncodingSize();
            }
            m = this.order_ != null ? this.order_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += this.order_.get(i).maxEncodingSize();
            }
            m = this.composite_index_ != null ? this.composite_index_.size() : 0;
            n += 7 * m;
            for (i = 0; i < m; ++i) {
                n += this.composite_index_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xE) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 6 + this.kind_.length;
                }
                if ((this_t0 & 4) != 0) {
                    n += 7 + this.ancestor_.maxEncodingSize();
                }
                if ((this_t0 & 8) != 0) {
                    n += 6 + this.search_query_.length;
                }
            }
            return (this_t0 & 0x200) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 0x200;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.kind_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.ancestor_ != null) {
                this.ancestor_.clear();
            }
            if (this.filter_ != null) {
                this.filter_.clear();
            }
            this.search_query_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.order_ != null) {
                this.order_.clear();
            }
            this.hint_ = 0;
            this.offset_ = 0;
            this.limit_ = 0;
            if (this.composite_index_ != null) {
                this.composite_index_.clear();
            }
            this.require_perfect_plan_ = false;
            this.keys_only_ = false;
            this.uninterpreted = null;
        }

        @Override
        public Query newInstance() {
            return new Query();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            ProtocolMessage v;
            int i;
            int m;
            sink.putByte((byte)10);
            sink.putPrefixedData(this.app_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)26);
                sink.putPrefixedData(this.kind_);
            }
            int n = m = this.filter_ != null ? this.filter_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.filter_.get(i);
                sink.putByte((byte)35);
                ((Filter)v).outputTo(sink);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)66);
                sink.putPrefixedData(this.search_query_);
            }
            int n2 = m = this.order_ != null ? this.order_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.order_.get(i);
                sink.putByte((byte)75);
                ((Order)v).outputTo(sink);
            }
            if ((this_t0 & 0x20) != 0) {
                sink.putByte((byte)96);
                sink.putVarLong(this.offset_);
            }
            if ((this_t0 & 0x40) != 0) {
                sink.putByte((byte)-128);
                sink.putByte((byte)1);
                sink.putVarLong(this.limit_);
            }
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)-118);
                sink.putByte((byte)1);
                sink.putForeign(this.ancestor_);
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)-112);
                sink.putByte((byte)1);
                sink.putVarLong(this.hint_);
            }
            int n3 = m = this.composite_index_ != null ? this.composite_index_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.composite_index_.get(i);
                sink.putByte((byte)-102);
                sink.putByte((byte)1);
                sink.putForeign(v);
            }
            if ((this_t0 & 0x80) != 0) {
                sink.putByte((byte)-96);
                sink.putByte((byte)1);
                sink.putBoolean(this.require_perfect_plan_);
            }
            if ((this_t0 & 0x100) != 0) {
                sink.putByte((byte)-88);
                sink.putByte((byte)1);
                sink.putBoolean(this.keys_only_);
            }
            if ((this_t0 & 0x200) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block15: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block15;
                    }
                    case 10: {
                        this.app_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block15;
                    }
                    case 26: {
                        this.kind_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block15;
                    }
                    case 35: {
                        if (this.addFilter().merge(source)) continue block15;
                        result = false;
                        break block15;
                    }
                    case 66: {
                        this.search_query_ = source.getPrefixedData();
                        this_t0 |= 8;
                        continue block15;
                    }
                    case 75: {
                        if (this.addOrder().merge(source)) continue block15;
                        result = false;
                        break block15;
                    }
                    case 96: {
                        this.offset_ = source.getVarInt();
                        this_t0 |= 0x20;
                        continue block15;
                    }
                    case 128: {
                        this.limit_ = source.getVarInt();
                        this_t0 |= 0x40;
                        continue block15;
                    }
                    case 138: {
                        source.push(source.getVarInt());
                        OnestoreEntity.Reference v17 = this.ancestor_;
                        if (v17 == null) {
                            this.ancestor_ = v17 = new OnestoreEntity.Reference();
                        }
                        if (!v17.merge(source)) {
                            result = false;
                            break block15;
                        }
                        source.pop();
                        this_t0 |= 4;
                        continue block15;
                    }
                    case 144: {
                        this.hint_ = source.getVarInt();
                        this_t0 |= 0x10;
                        continue block15;
                    }
                    case 154: {
                        source.push(source.getVarInt());
                        if (!this.addCompositeIndex().merge(source)) {
                            result = false;
                            break block15;
                        }
                        source.pop();
                        continue block15;
                    }
                    case 160: {
                        this.require_perfect_plan_ = source.getBoolean();
                        this_t0 |= 0x80;
                        continue block15;
                    }
                    case 168: {
                        this.keys_only_ = source.getBoolean();
                        this_t0 |= 0x100;
                        continue block15;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 0x200;
                        continue block15;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public Query freeze() {
            this.app_ = ProtocolSupport.freezeString(this.app_);
            this.kind_ = ProtocolSupport.freezeString(this.kind_);
            if (this.ancestor_ != null) {
                this.ancestor_.freeze();
            }
            this.filter_ = ProtocolSupport.freezeMessages(this.filter_);
            this.search_query_ = ProtocolSupport.freezeString(this.search_query_);
            this.order_ = ProtocolSupport.freezeMessages(this.order_);
            this.composite_index_ = ProtocolSupport.freezeMessages(this.composite_index_);
            return this;
        }

        @Override
        public Query unfreeze() {
            if (this.ancestor_ != null) {
                this.ancestor_.unfreeze();
            }
            this.filter_ = ProtocolSupport.unfreezeMessages(this.filter_);
            this.order_ = ProtocolSupport.unfreezeMessages(this.order_);
            this.composite_index_ = ProtocolSupport.unfreezeMessages(this.composite_index_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.ancestor_ != null && this.ancestor_.isFrozen() || ProtocolSupport.isFrozenMessages(this.filter_) || ProtocolSupport.isFrozenMessages(this.order_) || ProtocolSupport.isFrozenMessages(this.composite_index_);
        }

        static {
            Query.text[0] = "ErrorCode";
            Query.text[1] = "app";
            Query.text[3] = "kind";
            Query.text[4] = "Filter";
            Query.text[6] = "op";
            Query.text[8] = "search_query";
            Query.text[9] = "Order";
            Query.text[10] = "property";
            Query.text[11] = "direction";
            Query.text[12] = "offset";
            Query.text[14] = "property";
            Query.text[16] = "limit";
            Query.text[17] = "ancestor";
            Query.text[18] = "hint";
            Query.text[19] = "composite_index";
            Query.text[20] = "require_perfect_plan";
            Query.text[21] = "keys_only";
            types = new int[22];
            Arrays.fill(types, 6);
            Query.types[0] = 0;
            Query.types[1] = 2;
            Query.types[3] = 2;
            Query.types[4] = 3;
            Query.types[6] = 0;
            Query.types[8] = 2;
            Query.types[9] = 3;
            Query.types[10] = 2;
            Query.types[11] = 0;
            Query.types[12] = 0;
            Query.types[14] = 2;
            Query.types[16] = 0;
            Query.types[17] = 2;
            Query.types[18] = 0;
            Query.types[19] = 2;
            Query.types[20] = 0;
            Query.types[21] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Query.class, "Z'apphosting/datastore/datastore_v3.proto\n\u001dapphosting_datastore_v3.Query\u0013\u001a\u0003app \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0004kind \u0003(\u00020\t8\u0001\u0014\u0013\u001a\bancestor \u0011(\u00020\u000b8\u0001J\u001dstorage_onestore_v3.Reference\u0014\u0013\u001a\u0006Filter \u0004(\u00030\n8\u0003\u0014\u0013\u001a\tFilter.op \u0006(\u00000\u00058\u0002`\u0003h\u0001\u0014\u0013\u001a\u000fFilter.property \u000e(\u00020\u000b8\u0003J\u001cstorage_onestore_v3.Property`\u0003\u0014\u0013\u001a\fsearch_query \b(\u00020\t8\u0001\u0014\u0013\u001a\u0005Order \t(\u00030\n8\u0003\u0014\u0013\u001a\u000eOrder.property \n(\u00020\t8\u0002`\u0007\u0014\u0013\u001a\u000fOrder.direction \u000b(\u00000\u00058\u0001B\u00011`\u0007h\u0002\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\tASCENDING\u00a4\u0001\u0014\u0013\u001a\u0004hint \u0012(\u00000\u00058\u0001h\u0000\u0014\u0013\u001a\u0006offset \f(\u00000\u00058\u0001B\u00010\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u00010\u00a4\u0001\u0014\u0013\u001a\u0005limit \u0010(\u00000\u00058\u0001\u0014\u0013\u001a\u000fcomposite_index \u0013(\u00020\u000b8\u0003J\"storage_onestore_v3.CompositeIndex\u0014\u0013\u001a\u0014require_perfect_plan \u0014(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014\u0013\u001a\tkeys_only \u0015(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014sz\u0004Hint\u008b\u0001\u0092\u0001\u000bORDER_FIRST\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000eANCESTOR_FIRST\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\fFILTER_FIRST\u0098\u0001\u0003\u008c\u0001tsz\bOperator\u0080\u0001\u0003\u008b\u0001\u0092\u0001\tLESS_THAN\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u0012LESS_THAN_OR_EQUAL\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\fGREATER_THAN\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0015GREATER_THAN_OR_EQUAL\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0005EQUAL\u0098\u0001\u0005\u008c\u0001\u008b\u0001\u0092\u0001\u0002IN\u0098\u0001\u0006\u008c\u0001\u008b\u0001\u0092\u0001\u0006EXISTS\u0098\u0001\u0007\u008c\u0001tsz\tDirection\u0080\u0001\u0007\u008b\u0001\u0092\u0001\tASCENDING\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\nDESCENDING\u0098\u0001\u0002\u008c\u0001t", new ProtocolType.FieldType("app", "app", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("kind", "kind", 3, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("ancestor", "ancestor", 17, 2, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, OnestoreEntity.Reference.class), new ProtocolType.FieldType("Filter", "filter", 4, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Filter.class), new ProtocolType.FieldType("search_query", "search_query", 8, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Order", "order", 9, -1, ProtocolType.FieldBaseType.GROUP, ProtocolType.Presence.REPEATED, Order.class), new ProtocolType.FieldType("hint", "hint", 18, 4, ProtocolType.Presence.OPTIONAL, Hint.class), new ProtocolType.FieldType("offset", "offset", 12, 5, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("limit", "limit", 16, 6, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("composite_index", "composite_index", 19, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.CompositeIndex.class), new ProtocolType.FieldType("require_perfect_plan", "require_perfect_plan", 20, 7, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("keys_only", "keys_only", 21, 8, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Hint implements ProtocolMessageEnum
        {
            ORDER_FIRST(1),
            ANCESTOR_FIRST(2),
            FILTER_FIRST(3);

            public static final Hint Hint_MIN;
            public static final Hint Hint_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static Hint valueOf(int value) {
                switch (value) {
                    case 1: {
                        return ORDER_FIRST;
                    }
                    case 2: {
                        return ANCESTOR_FIRST;
                    }
                    case 3: {
                        return FILTER_FIRST;
                    }
                }
                return null;
            }

            private Hint(int v) {
                this.value = v;
            }

            static {
                Hint_MIN = ORDER_FIRST;
                Hint_MAX = FILTER_FIRST;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Order
        extends ProtocolMessage<Order> {
            private static final long serialVersionUID = 1L;
            private byte[] property_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            private int direction_ = 1;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Order IMMUTABLE_DEFAULT_INSTANCE = new Order(){
                private static final long serialVersionUID = 1L;

                public Order clearProperty() {
                    return this;
                }

                public Order setPropertyAsBytes(byte[] x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Order setProperty(String v) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Order setProperty(String v, Charset cs) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Order clearDirection() {
                    return this;
                }

                public Order setDirection(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Order mergeFrom(Order that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Order freeze() {
                    return this;
                }

                public Order unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final byte[] getPropertyAsBytes() {
                return this.property_;
            }

            public final boolean hasProperty() {
                return (this.optional_0_ & 1) != 0;
            }

            public Order clearProperty() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.property_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                return this;
            }

            public Order setPropertyAsBytes(byte[] x) {
                this.optional_0_ |= 1;
                this.property_ = x;
                return this;
            }

            public final String getProperty() {
                return ProtocolSupport.toStringUtf8(this.property_);
            }

            public Order setProperty(String v) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.property_ = ProtocolSupport.toBytesUtf8(v);
                return this;
            }

            public final String getProperty(Charset cs) {
                return ProtocolSupport.toString(this.property_, cs);
            }

            public Order setProperty(String v, Charset cs) {
                if (v == null) {
                    throw new NullPointerException();
                }
                this.optional_0_ |= 1;
                this.property_ = ProtocolSupport.toBytes(v, cs);
                return this;
            }

            public final int getDirection() {
                return this.direction_;
            }

            public Direction getDirectionEnum() {
                return Direction.valueOf(this.getDirection());
            }

            public final boolean hasDirection() {
                return (this.optional_0_ & 2) != 0;
            }

            public Order clearDirection() {
                this.optional_0_ &= 0xFFFFFFFD;
                this.direction_ = 1;
                return this;
            }

            public Order setDirection(int x) {
                this.optional_0_ |= 2;
                this.direction_ = x;
                return this;
            }

            public Order setDirection(Direction x) {
                if (x == null) {
                    this.optional_0_ &= 0xFFFFFFFD;
                    this.direction_ = 1;
                } else {
                    this.setDirection(x.getValue());
                }
                return this;
            }

            @Override
            public Order mergeFrom(Order that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.property_ = that.property_;
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    this.direction_ = that.direction_;
                }
                if ((that_t0 & 4) != 0) {
                    this_t0 |= 4;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Order that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Order that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Order that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFB) != (that_t0 & 0xFFFFFFFB)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && !Arrays.equals(this.property_, that.property_)) {
                    return false;
                }
                if ((this_t0 & 2) != 0 && this.direction_ != that.direction_) {
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 4) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Order && this.equals((Order)that);
            }

            @Override
            public int hashCode() {
                int hash = 1286285931;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.property_) : -113);
                hash = hash * 31 + ((this_t0 & 2) != 0 ? this.direction_ : -113);
                if ((this_t0 & 4) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 1) {
                    return "missing field: Order.property";
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 2 + Protocol.stringSize(this.property_.length);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.varLongSize(this.direction_);
                }
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 18 + this.property_.length;
                int this_t0 = this.optional_0_;
                return (this_t0 & 4) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 4;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.property_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
                this.direction_ = 1;
                this.uninterpreted = null;
            }

            @Override
            public Order newInstance() {
                return new Order();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                sink.putByte((byte)82);
                sink.putPrefixedData(this.property_);
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    sink.putByte((byte)88);
                    sink.putVarLong(this.direction_);
                }
                if ((this_t0 & 4) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)76);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 76: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 82: {
                            this.property_ = source.getPrefixedData();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 88: {
                            this.direction_ = source.getVarInt();
                            this_t0 |= 2;
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 4;
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Order freeze() {
                this.property_ = ProtocolSupport.freezeString(this.property_);
                return this;
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Order.class, null, new ProtocolType.FieldType("property", "property", 10, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("direction", "direction", 11, 1, ProtocolType.Presence.OPTIONAL, Direction.class));

                private StaticHolder() {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Direction implements ProtocolMessageEnum
            {
                ASCENDING(1),
                DESCENDING(2);

                public static final Direction Direction_MIN;
                public static final Direction Direction_MAX;
                private final int value;

                @Override
                public int getValue() {
                    return this.value;
                }

                public static Direction valueOf(int value) {
                    switch (value) {
                        case 1: {
                            return ASCENDING;
                        }
                        case 2: {
                            return DESCENDING;
                        }
                    }
                    return null;
                }

                private Direction(int v) {
                    this.value = v;
                }

                static {
                    Direction_MIN = ASCENDING;
                    Direction_MAX = DESCENDING;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Filter
        extends ProtocolMessage<Filter> {
            private static final long serialVersionUID = 1L;
            private int op_ = 0;
            private List<OnestoreEntity.Property> property_ = null;
            private UninterpretedTags uninterpreted;
            private int optional_0_;
            public static final Filter IMMUTABLE_DEFAULT_INSTANCE = new Filter(){
                private static final long serialVersionUID = 1L;

                public Filter clearOp() {
                    return this;
                }

                public Filter setOp(int x) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public Filter clearProperty() {
                    return this;
                }

                public OnestoreEntity.Property getMutableProperty(int i) {
                    return (OnestoreEntity.Property)ProtocolSupport.unsupportedOperation();
                }

                public OnestoreEntity.Property addProperty() {
                    return (OnestoreEntity.Property)ProtocolSupport.unsupportedOperation();
                }

                public OnestoreEntity.Property addProperty(OnestoreEntity.Property v) {
                    return (OnestoreEntity.Property)ProtocolSupport.unsupportedOperation();
                }

                public OnestoreEntity.Property insertProperty(int i, OnestoreEntity.Property v) {
                    return (OnestoreEntity.Property)ProtocolSupport.unsupportedOperation();
                }

                public OnestoreEntity.Property removeProperty(int i) {
                    return (OnestoreEntity.Property)ProtocolSupport.unsupportedOperation();
                }

                public Filter mergeFrom(Filter that) {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean merge(ProtocolSource source) {
                    ProtocolSupport.unsupportedOperation();
                    return false;
                }

                public Filter freeze() {
                    return this;
                }

                public Filter unfreeze() {
                    ProtocolSupport.unsupportedOperation();
                    return this;
                }

                public boolean isFrozen() {
                    return true;
                }
            };

            public final int getOp() {
                return this.op_;
            }

            public Operator getOpEnum() {
                return this.hasOp() ? Operator.valueOf(this.getOp()) : null;
            }

            public final boolean hasOp() {
                return (this.optional_0_ & 1) != 0;
            }

            public Filter clearOp() {
                this.optional_0_ &= 0xFFFFFFFE;
                this.op_ = 0;
                return this;
            }

            public Filter setOp(int x) {
                this.optional_0_ |= 1;
                this.op_ = x;
                return this;
            }

            public Filter setOp(Operator x) {
                if (x == null) {
                    this.optional_0_ &= 0xFFFFFFFE;
                    this.op_ = 0;
                } else {
                    this.setOp(x.getValue());
                }
                return this;
            }

            public final int propertySize() {
                return this.property_ != null ? this.property_.size() : 0;
            }

            public final OnestoreEntity.Property getProperty(int i) {
                assert (i >= 0 && i < (this.property_ != null ? this.property_.size() : 0));
                return this.property_.get(i);
            }

            public Filter clearProperty() {
                if (this.property_ != null) {
                    this.property_.clear();
                }
                return this;
            }

            public OnestoreEntity.Property getMutableProperty(int i) {
                assert (i >= 0 && this.property_ != null && i < this.property_.size());
                return this.property_.get(i);
            }

            public OnestoreEntity.Property addProperty() {
                OnestoreEntity.Property v = new OnestoreEntity.Property();
                if (this.property_ == null) {
                    this.property_ = new ArrayList<OnestoreEntity.Property>(4);
                }
                this.property_.add(v);
                return v;
            }

            public OnestoreEntity.Property addProperty(OnestoreEntity.Property v) {
                if (this.property_ == null) {
                    this.property_ = new ArrayList<OnestoreEntity.Property>(4);
                }
                this.property_.add(v);
                return v;
            }

            public OnestoreEntity.Property insertProperty(int i, OnestoreEntity.Property v) {
                if (this.property_ == null) {
                    this.property_ = new ArrayList<OnestoreEntity.Property>(4);
                }
                this.property_.add(i, v);
                return v;
            }

            public OnestoreEntity.Property removeProperty(int i) {
                return this.property_.remove(i);
            }

            public final Iterator<OnestoreEntity.Property> propertyIterator() {
                if (this.property_ == null) {
                    return ProtocolSupport.emptyIterator();
                }
                return this.property_.iterator();
            }

            public final List<OnestoreEntity.Property> propertys() {
                return ProtocolSupport.unmodifiableList(this.property_);
            }

            public final List<OnestoreEntity.Property> mutablePropertys() {
                if (this.property_ == null) {
                    this.property_ = new ArrayList<OnestoreEntity.Property>(4);
                }
                return this.property_;
            }

            @Override
            public Filter mergeFrom(Filter that) {
                assert (that != this);
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if ((that_t0 & 1) != 0) {
                    this_t0 |= 1;
                    this.op_ = that.op_;
                }
                if (that.property_ != null) {
                    for (OnestoreEntity.Property v : that.property_) {
                        this.addProperty().mergeFrom(v);
                    }
                }
                if ((that_t0 & 2) != 0) {
                    this_t0 |= 2;
                    if (this.uninterpreted == null) {
                        this.uninterpreted = new UninterpretedTags();
                    }
                    this.uninterpreted.putAll(that.uninterpreted);
                }
                this.optional_0_ = this_t0;
                return this;
            }

            @Override
            public boolean equalsIgnoreUninterpreted(Filter that) {
                return this.equals(that, true);
            }

            @Override
            public boolean equals(Filter that) {
                return this.equals(that, false);
            }

            @Override
            public boolean equals(Filter that, boolean ignoreUninterpreted) {
                if (that == this) {
                    return true;
                }
                int this_t0 = this.optional_0_;
                int that_t0 = that.optional_0_;
                if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                    return false;
                }
                if ((this_t0 & 1) != 0 && this.op_ != that.op_) {
                    return false;
                }
                int n = this.property_ != null ? this.property_.size() : 0;
                if (n != (that.property_ != null ? that.property_.size() : 0)) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (this.property_.get(i).equals(that.property_.get(i), ignoreUninterpreted)) continue;
                    return false;
                }
                return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
            }

            @Override
            public boolean equals(Object that) {
                return that instanceof Filter && this.equals((Filter)that);
            }

            @Override
            public int hashCode() {
                int n;
                int hash = -158325294;
                int this_t0 = this.optional_0_;
                hash = hash * 31 + ((this_t0 & 1) != 0 ? this.op_ : -113);
                hash *= 31;
                int n2 = n = this.property_ != null ? this.property_.size() : 0;
                for (int i = 0; i < n; ++i) {
                    hash = hash * 31 + this.property_.get(i).hashCode();
                }
                if ((this_t0 & 2) != 0) {
                    hash = hash * 31 + this.uninterpreted.hashCode();
                }
                return hash;
            }

            @Override
            public String findInitializationError() {
                int this_t0 = this.optional_0_;
                if ((this_t0 & 1) != 1) {
                    return "missing field: Filter.op";
                }
                if (this.property_ != null) {
                    for (OnestoreEntity.Property v : this.property_) {
                        String e = v.findInitializationError();
                        if (e == null) continue;
                        return e;
                    }
                }
                return null;
            }

            @Override
            public int encodingSize() {
                int n = 2 + Protocol.varLongSize(this.op_);
                int m = this.property_ != null ? this.property_.size() : 0;
                n += m;
                for (int i = 0; i < m; ++i) {
                    n += Protocol.stringSize(this.property_.get(i).encodingSize());
                }
                int this_t0 = this.optional_0_;
                return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
            }

            @Override
            public int maxEncodingSize() {
                int n = 12;
                int m = this.property_ != null ? this.property_.size() : 0;
                n += 6 * m;
                for (int i = 0; i < m; ++i) {
                    n += this.property_.get(i).maxEncodingSize();
                }
                int this_t0 = this.optional_0_;
                return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
            }

            @Override
            public MessageAppender getMessageAppender() {
                if (this.uninterpreted == null) {
                    this.optional_0_ |= 2;
                    this.uninterpreted = new UninterpretedTags();
                }
                return this.uninterpreted;
            }

            @Override
            public void clear() {
                this.optional_0_ = 0;
                this.op_ = 0;
                if (this.property_ != null) {
                    this.property_.clear();
                }
                this.uninterpreted = null;
            }

            @Override
            public Filter newInstance() {
                return new Filter();
            }

            @Override
            public ProtocolType getProtocolType() {
                return StaticHolder.protocolType;
            }

            @Override
            public void outputTo(ProtocolSink sink) {
                int m;
                sink.putByte((byte)48);
                sink.putVarLong(this.op_);
                int n = m = this.property_ != null ? this.property_.size() : 0;
                for (int i = 0; i < m; ++i) {
                    OnestoreEntity.Property v = this.property_.get(i);
                    sink.putByte((byte)114);
                    sink.putForeign(v);
                }
                int this_t0 = this.optional_0_;
                if ((this_t0 & 2) != 0) {
                    this.uninterpreted.put(sink);
                }
                sink.putByte((byte)36);
            }

            @Override
            public boolean merge(ProtocolSource source) {
                boolean result = true;
                int this_t0 = this.optional_0_;
                block6: while (true) {
                    int tt = source.getVarInt();
                    switch (tt) {
                        case 36: {
                            break block6;
                        }
                        case 0: {
                            result = false;
                            break block6;
                        }
                        case 48: {
                            this.op_ = source.getVarInt();
                            this_t0 |= 1;
                            continue block6;
                        }
                        case 114: {
                            source.push(source.getVarInt());
                            if (!this.addProperty().merge(source)) {
                                result = false;
                                break block6;
                            }
                            source.pop();
                            continue block6;
                        }
                        default: {
                            if (this.uninterpreted == null) {
                                this.uninterpreted = new UninterpretedTags();
                            }
                            this.uninterpreted.put(tt, source.getUninterpreted(tt));
                            this_t0 |= 2;
                            continue block6;
                        }
                    }
                    break;
                }
                this.optional_0_ = this_t0;
                return result;
            }

            @Override
            public Filter freeze() {
                this.property_ = ProtocolSupport.freezeMessages(this.property_);
                return this;
            }

            @Override
            public Filter unfreeze() {
                this.property_ = ProtocolSupport.unfreezeMessages(this.property_);
                return this;
            }

            @Override
            public boolean isFrozen() {
                return ProtocolSupport.isFrozenMessages(this.property_);
            }

            private static class StaticHolder {
                private static final ProtocolType protocolType = new ProtocolType(Filter.class, null, new ProtocolType.FieldType("op", "op", 6, 0, ProtocolType.Presence.REQUIRED, Operator.class), new ProtocolType.FieldType("property", "property", 14, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, OnestoreEntity.Property.class));

                private StaticHolder() {
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Operator implements ProtocolMessageEnum
            {
                LESS_THAN(1),
                LESS_THAN_OR_EQUAL(2),
                GREATER_THAN(3),
                GREATER_THAN_OR_EQUAL(4),
                EQUAL(5),
                IN(6),
                EXISTS(7);

                public static final Operator Operator_MIN;
                public static final Operator Operator_MAX;
                private final int value;

                @Override
                public int getValue() {
                    return this.value;
                }

                public static Operator valueOf(int value) {
                    switch (value) {
                        case 1: {
                            return LESS_THAN;
                        }
                        case 2: {
                            return LESS_THAN_OR_EQUAL;
                        }
                        case 3: {
                            return GREATER_THAN;
                        }
                        case 4: {
                            return GREATER_THAN_OR_EQUAL;
                        }
                        case 5: {
                            return EQUAL;
                        }
                        case 6: {
                            return IN;
                        }
                        case 7: {
                            return EXISTS;
                        }
                    }
                    return null;
                }

                private Operator(int v) {
                    this.value = v;
                }

                static {
                    Operator_MIN = LESS_THAN;
                    Operator_MAX = EXISTS;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Transaction
    extends ProtocolMessage<Transaction> {
        private static final long serialVersionUID = 1L;
        private long handle_ = 0L;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final Transaction IMMUTABLE_DEFAULT_INSTANCE = new Transaction(){
            private static final long serialVersionUID = 1L;

            public Transaction clearHandle() {
                return this;
            }

            public Transaction setHandle(long x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public Transaction mergeFrom(Transaction that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public Transaction freeze() {
                return this;
            }

            public Transaction unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int khandle = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final long getHandle() {
            return this.handle_;
        }

        public final boolean hasHandle() {
            return (this.optional_0_ & 1) != 0;
        }

        public Transaction clearHandle() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.handle_ = 0L;
            return this;
        }

        public Transaction setHandle(long x) {
            this.optional_0_ |= 1;
            this.handle_ = x;
            return this;
        }

        @Override
        public Transaction mergeFrom(Transaction that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.handle_ = that.handle_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                if (this.uninterpreted == null) {
                    this.uninterpreted = new UninterpretedTags();
                }
                this.uninterpreted.putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(Transaction that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(Transaction that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(Transaction that, boolean ignoreUninterpreted) {
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (!ignoreUninterpreted ? this_t0 != that_t0 : (this_t0 & 0xFFFFFFFD) != (that_t0 & 0xFFFFFFFD)) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.handle_ != that.handle_) {
                return false;
            }
            return ignoreUninterpreted || (this_t0 & 2) == 0 || this.uninterpreted.equals(that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof Transaction && this.equals((Transaction)that);
        }

        @Override
        public int hashCode() {
            int hash = 1433558001;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode(this.handle_) : -113);
            if ((this_t0 & 2) != 0) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public String findInitializationError() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 1) != 1) {
                return "missing field: handle";
            }
            return null;
        }

        @Override
        public int encodingSize() {
            int n = 9;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 9;
            int this_t0 = this.optional_0_;
            return (this_t0 & 2) != 0 ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            if (this.uninterpreted == null) {
                this.optional_0_ |= 2;
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.handle_ = 0L;
            this.uninterpreted = null;
        }

        @Override
        public Transaction newInstance() {
            return new Transaction();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)9);
            sink.putLong(this.handle_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 9: {
                        this.handle_ = source.getLong();
                        this_t0 |= 1;
                        continue block4;
                    }
                    default: {
                        if (this.uninterpreted == null) {
                            this.uninterpreted = new UninterpretedTags();
                        }
                        this.uninterpreted.put(tt, source.getUninterpreted(tt));
                        this_t0 |= 2;
                        continue block4;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        static {
            Transaction.text[0] = "ErrorCode";
            Transaction.text[1] = "handle";
            types = new int[2];
            Arrays.fill(types, 6);
            Transaction.types[0] = 0;
            Transaction.types[1] = 1;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(Transaction.class, "Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.Transaction\u0013\u001a\u0006handle \u0001(\u00010\u00068\u0002\u0014", new ProtocolType.FieldType("handle", "handle", 1, 0, ProtocolType.FieldBaseType.FIXED64, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }
}

