/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.StyledElement;
import java.awt.Dimension;
import java.awt.Point;
import org.mozilla.javascript.Undefined;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;

public class RenderedHtmlUnitDriverWebElement
extends HtmlUnitWebElement
implements RenderedWebElement {
    public RenderedHtmlUnitDriverWebElement(HtmlUnitDriver parent, HtmlElement element) {
        super(parent, element);
    }

    public void sendKeys(CharSequence ... value) {
        if (!this.isDisplayed()) {
            throw new UnsupportedOperationException("You may only sendKeys to visible elements");
        }
        super.sendKeys(value);
    }

    public boolean toggle() {
        if (!this.isDisplayed()) {
            throw new UnsupportedOperationException("You may only toggle visible elements");
        }
        return super.toggle();
    }

    public void click() {
        if (!this.isDisplayed()) {
            throw new UnsupportedOperationException("You may only click visible elements");
        }
        super.click();
    }

    public void setSelected() {
        if (!this.isDisplayed()) {
            throw new UnsupportedOperationException("You may only select visible elements");
        }
        super.setSelected();
    }

    public boolean isDisplayed() {
        if (this.element instanceof HtmlInput && ((HtmlInput)this.element).getTypeAttribute().equalsIgnoreCase("hidden")) {
            return false;
        }
        String display = "";
        String visible = "";
        HtmlElement node = this.element;
        while (node instanceof StyledElement && !"none".equals(display = this.getEffectiveStyle(node, "display")) && !"hidden".equals(visible = this.getEffectiveStyle(node, "visibility"))) {
            node = (HtmlElement)node.getParentNode();
        }
        return !"none".equals(display) && !"hidden".equals(visible);
    }

    public Point getLocation() {
        throw new UnsupportedOperationException("getLocation");
    }

    public Dimension getSize() {
        throw new UnsupportedOperationException("getSize");
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        throw new UnsupportedOperationException("dragAndDropBy");
    }

    public void dragAndDropOn(RenderedWebElement element) {
        throw new UnsupportedOperationException("dragAndDropOn");
    }

    public String getValueOfCssProperty(String propertyName) {
        return this.getEffectiveStyle(this.element, propertyName);
    }

    private String getEffectiveStyle(HtmlElement htmlElement, String propertyName) {
        if (!(htmlElement instanceof StyledElement)) {
            return "";
        }
        HtmlElement current = htmlElement;
        String value = "inherit";
        while (current instanceof StyledElement && "inherit".equals(value)) {
            Object result = this.parent.executeScript("if (window.getComputedStyle) {     return window.getComputedStyle(arguments[0], null)[arguments[1]]; } if (arguments[0].currentStyle) {     return arguments[0].currentStyle[arguments[1]]; } if (window.document.defaultView && window.document.defaultView.getComputedStyle) {     return window.document.defaultView.getComputedStyle(arguments[0], null)[arguments[1]]; } ", current, propertyName);
            if (!(result instanceof Undefined)) {
                value = String.valueOf(result);
            }
            current = (HtmlElement)current.getParentNode();
        }
        return value;
    }
}

