/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.NotConnectedException;
import org.openqa.selenium.firefox.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtensionConnection
implements ExtensionConnection {
    private Socket socket;
    protected SocketAddress address;
    private OutputStreamWriter out;
    private BufferedInputStream in;

    protected void setAddress(String host, int port) {
        InetAddress addr;
        if ("localhost".equals(host)) {
            addr = this.obtainLoopbackAddress();
        } else {
            try {
                addr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        this.address = new InetSocketAddress(addr, port);
    }

    private InetAddress obtainLoopbackAddress() {
        NetworkInterface firstInterface;
        InetAddress localIp4 = null;
        InetAddress localIp6 = null;
        try {
            Enumeration<NetworkInterface> allInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allInterfaces.hasMoreElements()) {
                NetworkInterface iface = allInterfaces.nextElement();
                Enumeration<InetAddress> allAddresses = iface.getInetAddresses();
                while (allAddresses.hasMoreElements()) {
                    InetAddress addr = allAddresses.nextElement();
                    if (!addr.isLoopbackAddress()) continue;
                    if (addr instanceof Inet4Address && localIp4 == null) {
                        localIp4 = addr;
                        continue;
                    }
                    if (!(addr instanceof Inet6Address) || localIp6 != null) continue;
                    localIp6 = addr;
                }
            }
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (localIp4 != null) {
            return localIp4;
        }
        if (localIp6 != null) {
            return localIp6;
        }
        try {
            firstInterface = NetworkInterface.getNetworkInterfaces().nextElement();
        }
        catch (SocketException e) {
            throw new WebDriverException((Throwable)e);
        }
        InetAddress firstAddress = null;
        if (firstInterface != null) {
            firstAddress = firstInterface.getInetAddresses().nextElement();
        }
        if (firstAddress != null) {
            return firstAddress;
        }
        throw new WebDriverException("Unable to find loopback address for localhost");
    }

    protected void connectToBrowser(long timeToWaitInMilliSeconds) throws IOException {
        long waitUntil = System.currentTimeMillis() + timeToWaitInMilliSeconds;
        while (!this.isConnected() && waitUntil > System.currentTimeMillis()) {
            try {
                this.connect();
            }
            catch (ConnectException e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ie) {
                    throw new WebDriverException((Throwable)ie);
                }
            }
        }
        if (!this.isConnected()) {
            throw new NotConnectedException(this.socket, timeToWaitInMilliSeconds);
        }
    }

    private void connect() throws IOException {
        this.socket = new Socket();
        this.socket.connect(this.address);
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8");
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public Response sendMessageAndWaitForResponse(Class<? extends RuntimeException> throwOnFailure, Command command) {
        String converted = this.convert(command);
        StringBuilder message = new StringBuilder("Length: ");
        message.append(converted.length()).append("\n\n");
        message.append(converted).append("\n");
        try {
            this.out.write(message.toString());
            this.out.flush();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        return this.waitForResponseFor(command.getCommandName());
    }

    private String convert(Command command) {
        JSONObject json = new JSONObject();
        try {
            json.put("commandName", (Object)command.getCommandName());
            json.put("context", (Object)String.valueOf(command.getContext()));
            json.put("elementId", (Object)command.getElementId());
            JSONArray params = new JSONArray();
            for (Object o : command.getParameters()) {
                params.put(o);
            }
            json.put("parameters", (Object)params);
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        try {
            byte[] bytes = json.toString().getBytes("UTF-8");
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot convert string to UTF-8");
        }
    }

    private Response waitForResponseFor(String command) {
        try {
            return this.readLoop(command);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Response readLoop(String command) throws IOException {
        Response response = this.nextResponse();
        if (command.equals(response.getCommand())) {
            return response;
        }
        throw new WebDriverException("Expected response to " + command + " but actually got: " + response.getCommand() + " (" + response.getCommand() + ")");
    }

    private Response nextResponse() throws IOException {
        String line = this.readLine();
        int count = 0;
        String[] parts = line.split(":", 2);
        if ("Length".equals(parts[0])) {
            count = Integer.parseInt(parts[1].trim());
        }
        while (line.length() != 0) {
            line = this.readLine();
        }
        byte[] remaining = new byte[count];
        for (int i = 0; i < count; ++i) {
            remaining[i] = (byte)this.in.read();
        }
        return new Response(new String(remaining, "UTF-8"));
    }

    private String readLine() throws IOException {
        int b;
        int size = 4096;
        int growBy = 1024;
        byte[] raw = new byte[size];
        int count = 0;
        while ((b = this.in.read()) != -1 && (char)b != '\n') {
            raw[count++] = (byte)b;
            if (count != size) continue;
            byte[] temp = new byte[size += growBy];
            System.arraycopy(raw, 0, temp, 0, count);
            raw = temp;
        }
        return new String(raw, 0, count, "UTF-8");
    }
}

