/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.expression;

import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.PrimaryExpressionIsClassLiteralException;
import org.datanucleus.query.symbol.Symbol;

public class DyadicExpression
extends Expression {
    public DyadicExpression(Expression.MonadicOperator op, Expression operand) {
        super(op, operand);
    }

    public DyadicExpression(Expression operand1, Expression.DyadicOperator op, Expression operand2) {
        super(operand1, op, operand2);
    }

    public Object evaluate(ExpressionEvaluator eval) {
        this.left.evaluate(eval);
        if (this.right != null) {
            this.right.evaluate(eval);
        }
        return super.evaluate(eval);
    }

    public Symbol bind() {
        try {
            this.left.bind();
        }
        catch (PrimaryExpressionIsClassLiteralException peil) {
            this.left = new Literal(peil.getLiteralClass());
            this.left.bind();
        }
        if (this.right != null) {
            try {
                this.right.bind();
            }
            catch (PrimaryExpressionIsClassLiteralException peil) {
                this.right = new Literal(peil.getLiteralClass());
                this.right.bind();
            }
        }
        return null;
    }

    public String toString() {
        return "DyadicExpression {" + this.getLeft() + " " + this.getOperator() + " " + this.getRight() + "}";
    }
}

