/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ThreadManager;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class WebWindowImpl
implements WebWindow {
    private WebClient webClient_;
    private Page enclosedPage_;
    private Object scriptObject_;
    private ThreadManager threadManager_ = new ThreadManager(this);
    private List<WebWindowImpl> childWindows_ = new ArrayList<WebWindowImpl>();
    private String name_ = "";

    @Deprecated
    protected WebWindowImpl() {
    }

    public WebWindowImpl(WebClient webClient) {
        WebAssert.notNull("webClient", webClient);
        this.webClient_ = webClient;
        this.performRegistration();
    }

    protected void performRegistration() {
        this.webClient_.registerWebWindow(this);
    }

    public WebClient getWebClient() {
        return this.webClient_;
    }

    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    public void setEnclosedPage(Page page) {
        if (page == this.enclosedPage_) {
            return;
        }
        this.destroyChildren();
        this.enclosedPage_ = page;
        if (this.isJavaScriptInitializationNeeded()) {
            this.webClient_.initialize(this);
        }
        this.webClient_.initialize(page);
    }

    protected abstract boolean isJavaScriptInitializationNeeded();

    public void setScriptObject(Object scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    public Object getScriptObject() {
        return this.scriptObject_;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager_;
    }

    public void addChildWindow(FrameWindow child) {
        this.childWindows_.add(child);
    }

    void destroyChildren() {
        this.getThreadManager().interruptAll();
        ListIterator<WebWindowImpl> iter = this.childWindows_.listIterator();
        while (iter.hasNext()) {
            iter.next().destroyChildren();
            iter.remove();
        }
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }
}

