/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitWrapFactory;
import com.gargoylesoftware.htmlunit.javascript.StrictErrorReporter;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.regexp.HtmlUnitRegExpProxy;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.debug.Debugger;

public class HtmlUnitContextFactory
extends ContextFactory
implements Serializable {
    private static final long serialVersionUID = -1282169475857079041L;
    private static final int INSTRUCTION_COUNT_THRESHOLD = 10000;
    private final BrowserVersion browserVersion_;
    private final Log log_;
    private long timeout_;
    private Debugger debugger_;
    private final ErrorReporter errorReporter_;
    private final WrapFactory wrapFactory_ = new HtmlUnitWrapFactory();

    public HtmlUnitContextFactory(BrowserVersion browserVersion, Log log) {
        WebAssert.notNull("browserVersion", browserVersion);
        WebAssert.notNull("log", log);
        this.browserVersion_ = browserVersion;
        this.log_ = log;
        this.errorReporter_ = new StrictErrorReporter(this.log_);
    }

    public void setTimeout(long timeout) {
        this.timeout_ = timeout;
    }

    public long getTimeout() {
        return this.timeout_;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger_ = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger_;
    }

    protected Context makeContext() {
        TimeoutContext cx = new TimeoutContext(this);
        cx.setOptimizationLevel(-1);
        cx.setInstructionObserverThreshold(10000);
        this.configureErrorReporter(cx);
        cx.setWrapFactory(this.wrapFactory_);
        if (this.debugger_ != null) {
            cx.setDebugger(this.debugger_, null);
        }
        ScriptRuntime.setRegExpProxy((Context)cx, (RegExpProxy)new HtmlUnitRegExpProxy(ScriptRuntime.getRegExpProxy((Context)cx)));
        return cx;
    }

    protected void configureErrorReporter(Context context) {
        context.setErrorReporter(this.errorReporter_);
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.terminateScriptIfNecessary();
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        TimeoutContext tcx = (TimeoutContext)cx;
        tcx.startClock();
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    protected boolean hasFeature(Context cx, int featureIndex) {
        if (3 == featureIndex) {
            return true;
        }
        if (5 == featureIndex) {
            return !this.browserVersion_.isIE();
        }
        return super.hasFeature(cx, featureIndex);
    }

    private class TimeoutContext
    extends Context {
        private long startTime_;

        protected TimeoutContext(ContextFactory factory) {
            super(factory);
        }

        public void startClock() {
            this.startTime_ = System.currentTimeMillis();
        }

        public void terminateScriptIfNecessary() {
            long currentTime;
            if (HtmlUnitContextFactory.this.timeout_ > 0L && (currentTime = System.currentTimeMillis()) - this.startTime_ > HtmlUnitContextFactory.this.timeout_) {
                throw new TimeoutError(HtmlUnitContextFactory.this.timeout_, currentTime - this.startTime_);
            }
        }
    }
}

