/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.ReferenceType;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingConcurrentMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceMap<K, V>
extends ForwardingConcurrentMap<K, V>
implements Serializable {
    private final ConcurrentMap<K, V> delegate;
    private static final long serialVersionUID = 0L;

    ReferenceMap(MapMaker maker, ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        ReferenceMap.configureStrengths(maker, keyReferenceType, valueReferenceType);
        this.delegate = maker.makeMap();
    }

    public ReferenceMap(ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        this(new MapMaker(), keyReferenceType, valueReferenceType);
    }

    static void configureStrengths(MapMaker maker, ReferenceType keyReferenceType, ReferenceType valueReferenceType) {
        switch (keyReferenceType) {
            case PHANTOM: {
                throw new IllegalArgumentException("Phantom references are not supported.");
            }
            case SOFT: {
                maker.softKeys();
                break;
            }
            case WEAK: {
                maker.weakKeys();
            }
        }
        switch (valueReferenceType) {
            case PHANTOM: {
                throw new IllegalArgumentException("Phantom references are not supported.");
            }
            case SOFT: {
                maker.softValues();
                break;
            }
            case WEAK: {
                maker.weakValues();
            }
        }
    }

    @Override
    protected ConcurrentMap<K, V> delegate() {
        return this.delegate;
    }
}

