/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.appengine.repackaged.com.google.common.base.StringUtil;

public final class ServerAddress {
    public final String host;
    public final int port;

    public ServerAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ServerAddress(String spec) {
        this(spec, "");
    }

    public ServerAddress(String spec, String defaultHost) {
        int colon = spec.indexOf(58);
        if (colon >= 0) {
            this.host = colon == 0 ? defaultHost : spec.substring(0, colon);
            if (this.host.length() == 0) {
                throw new IllegalArgumentException("no hostname: " + spec);
            }
            try {
                this.port = Integer.parseInt(spec.substring(colon + 1));
                return;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("badly formatted host:port pair " + spec);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress x = (ServerAddress)other;
            return x.port == this.port && x.host.equals(this.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public static ServerAddress[] parseServerAddresses(String spec) {
        String[] hostPortPairs = StringUtil.splitAndTrim(spec, ",");
        ServerAddress[] servAddrs = new ServerAddress[hostPortPairs.length];
        for (int i = 0; i < hostPortPairs.length; ++i) {
            servAddrs[i] = new ServerAddress(hostPortPairs[i]);
        }
        return servAddrs;
    }

    public static ServerAddress valueOf(String spec) {
        return new ServerAddress(spec);
    }
}

