/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimaps;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UninterpretedTags
extends ForwardingMultimap<Integer, byte[]>
implements Serializable {
    private final Multimap<Integer, byte[]> delegate = Multimaps.newListMultimap(new TreeMap(), ListFactory.INSTANCE);
    private static final long serialVersionUID = 0L;

    @Override
    protected Multimap<Integer, byte[]> delegate() {
        return this.delegate;
    }

    public final void put(ProtocolSink sink) {
        for (Map.Entry message : this.entries()) {
            sink.putVarInt((Integer)message.getKey());
            sink.putBytes((byte[])message.getValue());
        }
    }

    public final int encodingSize() {
        int result = 0;
        for (Map.Entry message : this.entries()) {
            Integer wireTag = (Integer)message.getKey();
            result += Protocol.varIntSize(wireTag) + ((byte[])message.getValue()).length;
        }
        return result;
    }

    public final int maxEncodingSize() {
        int result = 0;
        for (byte[] values : this.values()) {
            result += values.length;
        }
        return result += this.size() * 5;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UninterpretedTags that = (UninterpretedTags)o;
        return this.equals(that);
    }

    public boolean equals(UninterpretedTags that) {
        if (that == null || this.size() != that.size()) {
            return false;
        }
        for (Map.Entry thisEntry : this.asMap().entrySet()) {
            Integer this_wiretag = (Integer)thisEntry.getKey();
            List thisArrays = (List)thisEntry.getValue();
            List thatArrays = (List)that.get(this_wiretag);
            if (thatArrays == null || thisArrays.size() != thatArrays.size()) {
                return false;
            }
            for (int j = thisArrays.size() - 1; j >= 0; --j) {
                if (Arrays.equals((byte[])thisArrays.get(j), (byte[])thatArrays.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int hash = 2537462;
        for (Map.Entry message : this.entries()) {
            hash = hash * 31 + (Integer)message.getKey();
            hash = hash * 31 + Arrays.hashCode((byte[])message.getValue());
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListFactory implements Supplier<List<byte[]>>
    {
        INSTANCE;


        @Override
        public List<byte[]> get() {
            return new ArrayList<byte[]>();
        }
    }
}

