/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiProxyLocalImpl
implements ApiProxyLocal {
    private static final Logger logger = Logger.getLogger(ApiProxyLocalImpl.class.getName());
    private final Map<String, LocalRpcService> serviceCache = Maps.newConcurrentHashMap();
    private final Map<String, String> properties = Maps.newHashMap();
    private LocalServiceContext context;

    protected ApiProxyLocalImpl(File appDir) {
        this.context = new LocalServiceContextImpl(appDir);
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        logger.log(ApiProxyLocalImpl.toJavaLevel(record.getLevel()), "[" + record.getTimestamp() + "] " + record.getMessage());
    }

    public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] requestBytes) {
        LocalRpcService service = this.getService(packageName);
        if (service == null) {
            throw new ApiProxy.CallNotFoundException(packageName, methodName);
        }
        Method method = this.getDispatchMethod(service, packageName, methodName);
        LocalRpcService.Status status = new LocalRpcService.Status();
        try {
            Class<?> requestClass = method.getParameterTypes()[1];
            ProtocolMessage request = (ProtocolMessage)requestClass.newInstance();
            request.mergeFrom(requestBytes);
            ProtocolMessage responseBytes = (ProtocolMessage)method.invoke((Object)service, status, request);
            return responseBytes.toByteArray();
        }
        catch (IllegalAccessException e) {
            throw new ApiProxy.UnknownException(packageName, methodName, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ApiProxy.UnknownException(packageName, methodName, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ApiProxy.UnknownException(packageName, methodName, e.getCause());
        }
    }

    @Override
    public void setProperty(String property, String value) {
        this.properties.put(property, value);
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Override
    public void stop() {
        for (LocalRpcService service : this.serviceCache.values()) {
            service.stop();
        }
        this.serviceCache.clear();
    }

    private Method getDispatchMethod(LocalRpcService service, String packageName, String methodName) {
        String dispatchName = Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1);
        for (Method method : service.getClass().getMethods()) {
            if (!dispatchName.equals(method.getName())) continue;
            return method;
        }
        throw new ApiProxy.UnknownException("Could not find " + service.getClass().getName() + "." + dispatchName);
    }

    public final LocalRpcService getService(final String pkg) {
        LocalRpcService cachedService = this.serviceCache.get(pkg);
        if (cachedService != null) {
            return cachedService;
        }
        cachedService = this.serviceCache.get(pkg);
        if (cachedService != null) {
            return cachedService;
        }
        return AccessController.doPrivileged(new PrivilegedAction<LocalRpcService>(){

            @Override
            public LocalRpcService run() {
                Iterator services = Service.providers(LocalRpcService.class, (ClassLoader)ApiProxyLocalImpl.class.getClassLoader());
                while (services.hasNext()) {
                    LocalRpcService service = (LocalRpcService)services.next();
                    if (!service.getPackage().equals(pkg)) continue;
                    service.init(ApiProxyLocalImpl.this.context, ApiProxyLocalImpl.this.properties);
                    service.start();
                    ApiProxyLocalImpl.this.serviceCache.put(pkg, service);
                    return service;
                }
                return null;
            }
        });
    }

    private static Level toJavaLevel(ApiProxy.LogRecord.Level apiProxyLevel) {
        switch (apiProxyLevel) {
            case debug: {
                return Level.FINE;
            }
            case info: {
                return Level.INFO;
            }
            case warn: {
                return Level.WARNING;
            }
            case error: {
                return Level.SEVERE;
            }
            case fatal: {
                return Level.SEVERE;
            }
        }
        return Level.WARNING;
    }

    private class LocalServiceContextImpl
    implements LocalServiceContext {
        private File appDir;

        public LocalServiceContextImpl(File appDir) {
            this.appDir = appDir;
        }

        public File getAppDir() {
            return this.appDir;
        }
    }
}

