/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.users.dev.LoginCookieUtils;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.apphosting.utils.config.AppEngineWebXml;
import javax.servlet.http.HttpServletRequest;

class LocalHttpRequestEnvironment
extends LocalEnvironment {
    private static final String DEFAULT_NAMESPACE_HEADER = "X-AppEngine-Default-Namespace";
    private final LoginCookieUtils.CookieData loginCookieData;
    private String requestNamespace;

    public LocalHttpRequestEnvironment(AppEngineWebXml appEngineWebXml, HttpServletRequest request) {
        super(appEngineWebXml);
        this.loginCookieData = LoginCookieUtils.getCookieData((HttpServletRequest)request);
        this.requestNamespace = request.getHeader(DEFAULT_NAMESPACE_HEADER);
        if (this.requestNamespace == null) {
            this.requestNamespace = "";
        }
    }

    public boolean isLoggedIn() {
        return this.loginCookieData != null;
    }

    public String getEmail() {
        if (this.loginCookieData == null) {
            return null;
        }
        return this.loginCookieData.getEmail();
    }

    public boolean isAdmin() {
        if (this.loginCookieData == null) {
            return false;
        }
        return this.loginCookieData.isAdmin();
    }

    public String getRequestNamespace() {
        return this.requestNamespace;
    }
}

