/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ajp;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.ajp.Ajp13Generator;
import org.mortbay.jetty.ajp.Ajp13Parser;
import org.mortbay.jetty.ajp.Ajp13Request;

public class Ajp13Connection
extends HttpConnection {
    private boolean _sslSecure = false;

    public Ajp13Connection(Connector connector, EndPoint endPoint, Server server) {
        super(connector, endPoint, server);
        this._request = new Ajp13Request(this);
        this._generator = new Ajp13Generator(this._connector, this._endp, this._connector.getHeaderBufferSize(), this._connector.getResponseBufferSize());
        this._parser = new Ajp13Parser(this._connector, this._endp, new RequestHandler(), (Ajp13Generator)this._generator);
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    public boolean isConfidential(Request request) {
        return this._sslSecure;
    }

    public boolean isIntegral(Request request) {
        return this._sslSecure;
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new Ajp13Parser.Input((Ajp13Parser)this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    private class RequestHandler
    implements Ajp13Parser.EventHandler {
        boolean _delayedHandling = false;

        private RequestHandler() {
        }

        public void startForwardRequest() throws IOException {
            this._delayedHandling = false;
            Ajp13Connection.this._uri.clear();
            Ajp13Connection.this._sslSecure = false;
            Ajp13Connection.this._request.setTimeStamp(System.currentTimeMillis());
            Ajp13Connection.this._request.setUri(Ajp13Connection.this._uri);
        }

        public void parsedAuthorizationType(Buffer authType) throws IOException {
            Ajp13Connection.this._request.setAuthType(authType.toString());
        }

        public void parsedRemoteUser(Buffer remoteUser) throws IOException {
            ((Ajp13Request)Ajp13Connection.this._request).setRemoteUser(remoteUser.toString());
        }

        public void parsedServletPath(Buffer servletPath) throws IOException {
            Ajp13Connection.this._request.setServletPath(servletPath.toString());
        }

        public void parsedContextPath(Buffer context) throws IOException {
            Ajp13Connection.this._request.setContextPath(context.toString());
        }

        public void parsedSslCert(Buffer sslCert) throws IOException {
            Ajp13Connection.this._request.setAttribute("javax.servlet.request.X509Certificate", sslCert.toString());
        }

        public void parsedSslCipher(Buffer sslCipher) throws IOException {
            Ajp13Connection.this._request.setAttribute("javax.servlet.request.cipher_suite", sslCipher.toString());
        }

        public void parsedSslSession(Buffer sslSession) throws IOException {
            Ajp13Connection.this._request.setAttribute("javax.servlet.request.ssl_session", sslSession.toString());
        }

        public void parsedMethod(Buffer method) throws IOException {
            Ajp13Connection.this._request.setMethod(method.toString());
        }

        public void parsedUri(Buffer uri) throws IOException {
            Ajp13Connection.this._uri.parse(uri.toString());
        }

        public void parsedProtocol(Buffer protocol) throws IOException {
            if (protocol != null && protocol.length() > 0) {
                Ajp13Connection.this._request.setProtocol(protocol.toString());
            }
        }

        public void parsedRemoteAddr(Buffer addr) throws IOException {
            if (addr != null && addr.length() > 0) {
                ((Ajp13Request)Ajp13Connection.this._request).setRemoteAddr(addr.toString());
            }
        }

        public void parsedRemoteHost(Buffer name) throws IOException {
            if (name != null && name.length() > 0) {
                ((Ajp13Request)Ajp13Connection.this._request).setRemoteHost(name.toString());
            }
        }

        public void parsedServerName(Buffer name) throws IOException {
            if (name != null && name.length() > 0) {
                Ajp13Connection.this._request.setServerName(name.toString());
            }
        }

        public void parsedServerPort(int port) throws IOException {
            ((Ajp13Request)Ajp13Connection.this._request).setServerPort(port);
        }

        public void parsedSslSecure(boolean secure) throws IOException {
            Ajp13Connection.this._sslSecure = secure;
        }

        public void parsedQueryString(Buffer value) throws IOException {
            String u = Ajp13Connection.this._uri + "?" + value;
            Ajp13Connection.this._uri.parse(u);
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            Ajp13Connection.this._requestFields.add(name, value);
        }

        public void parsedRequestAttribute(String key, Buffer value) throws IOException {
            Ajp13Connection.this._request.setAttribute(key, value.toString());
        }

        public void parsedRequestAttribute(String key, int value) throws IOException {
            Ajp13Connection.this._request.setAttribute(key, Integer.toString(value));
        }

        public void headerComplete() throws IOException {
            if (((Ajp13Parser)Ajp13Connection.this._parser).getContentLength() <= 0L) {
                Ajp13Connection.this.handleRequest();
            } else {
                this._delayedHandling = true;
            }
        }

        public void messageComplete(long contextLength) throws IOException {
        }

        public void content(Buffer ref) throws IOException {
            if (this._delayedHandling) {
                this._delayedHandling = false;
                Ajp13Connection.this.handleRequest();
            }
        }
    }
}

