#!/usr/bin/ruby -Ke
#
# (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# $Id: FSMdummy.rb,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
#
# DummyFSM
#

require 'GalateaBase.rb'

$tk_thread_safe = TRUE
require 'tk'

class FSM < GalateaBase
  def initialize(modulename, debug)
    super
    @myslot["Run"] = "LIVE"
  end
  
  def add_text(str)
    day = Time.now
    ds = day.strftime("%M:%S")
    $syslog.insert 'end', format("%s %s", ds, str) 
    $syslog.yview 'end'
  end

  def do_prop(prop, arg)
    super

    # prop Speak.stat = AutoOutput
    add_text "prop #{prop} = #{arg}\n"
  end

  def do_set(slot, arg)
    super

    # set LipSync.pho = sil 340 w 60 a 55 t 65 a 65 sh 125 i 55 sil 340
    # set Speak = + 100
    if slot == "LipSync.pho" && @myprop["Speak.stat"] == "AutoOutput"
      print_rep "Speak.stat = PROCESSING"
      print_rep "Speak.stat = READY"

    elsif slot == "Speak" && @myprop["Speak.stat"] == "AutoOutput"
      print_rep "Speak.stat = SPEAKING"
      sleep 1.0
      print_rep "Speak.stat = IDLE"

    end

    if slot != "FaceExp" && slot != "EyeRot" && slot != "HeadRotAbs.1"
      add_text "set #{slot} = #{arg}\n"
    end

  end

end

Thread.start do
  FSM.new("FSM", true).run
end

# ---------------------------
# Tk is from here
# ---------------------------

$frame1 = TkFrame.new do
  pack('side' =>'top', 'fill'=>'both', 'expand'=>'true') 
end

$bar1 = TkScrollbar.new($frame1) do
  pack('side'=>'right', 'fill'=>'y')
  command proc { |args| $syslog.yview(*args) }
end

sleep 1.0

$syslog = TkText.new($frame1) do
  width  60
  height 10
  wrap 'none'
  pack('side'=>'left', 'fill'=>'both', 'expand'=>'true')
  yscrollcommand proc { |first, last| $bar1.set(first, last) }
end

Tk.root.title("FSM")
Tk.mainloop

# end of file
