/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: VoiceOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

//import galatea.main.*;
import galatea.dialog.RuntimeError;
import galatea.util.*;

public class VoiceOutItem extends OutItem
{
//	private Debug dbg = new Debug("OutItem", 0);
	
	private String with_ = "";
	private String tts_ = "";
	
	public void setWith(String s) 
	{
		with_ = s;
	}
	
	public String getWith() 
	{
		return with_;
	}
	
	public VoiceOutItem(String tts)
	{
		isInstant_ = false;
		tts_ = tts;
		with_ = "";
	}
	
	public VoiceOutItem(String tts, String with)
	{
		isInstant_ = false;
		tts_ = tts;
		with_ = with;
	}
	
	public VoiceOutItem(String tts, String with, boolean bargein)
	{
		isInstant_ = false;
		tts_ = tts;
		with_ = with;
		bargein_ = bargein;
	}
	
	public void doEvaluate() throws RuntimeError
	{
		String str = null;
		String script;
		if ( with_ != null && with_.length() > 0 ) {
			script = "with(" + with_ + "){" + tts_ + "}";
		} else {
			script = tts_;
		}
		str = ecmascript_.evaluate(script);
		arg_ = str;
	}
	
	
	public String toString()
	{
		String wt = Util.encodeXmlChars(with_);
		String str = Util.encodeXmlChars(tts_);
		
		String s = "<voice";
		if ( bargein_ == false ) {
			s += " bargein=\"false\"";
		}
		if ( wt.length() > 0 ) {
			s += " with=\"" + wt + "\"";
		}
		s += ">";
		s += str;
		s += "</voice>";
		return s;
	}
	
}
