/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>EventRECOGOUTRef</b> is generated from event.rng by Relaxer.
 *
 * @version event.rng (Thu Oct 02 00:02:11 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventRECOGOUTRef implements java.io.Serializable, Cloneable, IEventRECOGOUTChoice {
    // List<EventSHYPO>
    private java.util.List SHYPO_ = new java.util.ArrayList();

    /**
     * Creates a <code>EventRECOGOUTRef</code>.
     *
     */
    public EventRECOGOUTRef() {
    }

    /**
     * Creates a <code>EventRECOGOUTRef</code>.
     *
     * @param source
     */
    public EventRECOGOUTRef(EventRECOGOUTRef source) {
        setup(source);
    }

    /**
     * Creates a <code>EventRECOGOUTRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventRECOGOUTRef(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>EventRECOGOUTRef</code> by the EventRECOGOUTRef <code>source</code>.
     *
     * @param source
     */
    public void setup(EventRECOGOUTRef source) {
        int size;
        this.SHYPO_.clear();
        size = source.SHYPO_.size();
        for (int i = 0;i < size;i++) {
            addSHYPO((EventSHYPO)source.getSHYPO(i).clone());
        }
    }

    /**
     * Initializes the <code>EventRECOGOUTRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        SHYPO_.clear();
        while (true) {
            if (EventSHYPO.isMatch(stack)) {
                addSHYPO(new EventSHYPO(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventRECOGOUTRef((EventRECOGOUTRef)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        size = this.SHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventSHYPO value = (EventSHYPO)this.SHYPO_.get(i);
            value.makeElement(element);
        }
    }

    /**
     * Gets the EventSHYPO property <b>SHYPO</b>.
     *
     * @return EventSHYPO[]
     */
    public EventSHYPO[] getSHYPO() {
        EventSHYPO[] array = new EventSHYPO[SHYPO_.size()];
        return ((EventSHYPO[])SHYPO_.toArray(array));
    }

    /**
     * Sets the EventSHYPO property <b>SHYPO</b>.
     *
     * @param SHYPO
     */
    public void setSHYPO(EventSHYPO[] SHYPO) {
        this.SHYPO_.clear();
        for (int i = 0;i < SHYPO.length;i++) {
            addSHYPO(SHYPO[i]);
        }
    }

    /**
     * Sets the EventSHYPO property <b>SHYPO</b>.
     *
     * @param SHYPO
     */
    public void setSHYPO(EventSHYPO SHYPO) {
        this.SHYPO_.clear();
        addSHYPO(SHYPO);
    }

    /**
     * Adds the EventSHYPO property <b>SHYPO</b>.
     *
     * @param SHYPO
     */
    public void addSHYPO(EventSHYPO SHYPO) {
        this.SHYPO_.add(SHYPO);
    }

    /**
     * Adds the EventSHYPO property <b>SHYPO</b>.
     *
     * @param SHYPO
     */
    public void addSHYPO(EventSHYPO[] SHYPO) {
        for (int i = 0;i < SHYPO.length;i++) {
            addSHYPO(SHYPO[i]);
        }
    }

    /**
     * Gets number of the EventSHYPO property <b>SHYPO</b>.
     *
     * @return int
     */
    public int sizeSHYPO() {
        return (SHYPO_.size());
    }

    /**
     * Gets the EventSHYPO property <b>SHYPO</b> by index.
     *
     * @param index
     * @return EventSHYPO
     */
    public EventSHYPO getSHYPO(int index) {
        return ((EventSHYPO)SHYPO_.get(index));
    }

    /**
     * Sets the EventSHYPO property <b>SHYPO</b> by index.
     *
     * @param index
     * @param SHYPO
     */
    public void setSHYPO(int index, EventSHYPO SHYPO) {
        this.SHYPO_.set(index, SHYPO);
    }

    /**
     * Adds the EventSHYPO property <b>SHYPO</b> by index.
     *
     * @param index
     * @param SHYPO
     */
    public void addSHYPO(int index, EventSHYPO SHYPO) {
        this.SHYPO_.add(index, SHYPO);
    }

    /**
     * Remove the EventSHYPO property <b>SHYPO</b> by index.
     *
     * @param index
     */
    public void removeSHYPO(int index) {
        this.SHYPO_.remove(index);
    }

    /**
     * Remove the EventSHYPO property <b>SHYPO</b> by object.
     *
     * @param SHYPO
     */
    public void removeSHYPO(EventSHYPO SHYPO) {
        this.SHYPO_.remove(SHYPO);
    }

    /**
     * Clear the EventSHYPO property <b>SHYPO</b>.
     *
     */
    public void clearSHYPO() {
        this.SHYPO_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        size = this.SHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventSHYPO value = (EventSHYPO)this.SHYPO_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        size = this.SHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventSHYPO value = (EventSHYPO)this.SHYPO_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        size = this.SHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventSHYPO value = (EventSHYPO)this.SHYPO_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventRECOGOUTRef</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventRECOGOUTRef</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack.makeClone();
        boolean $match$ = false;
        Element element = target.peekElement();
        Element child;
        if (!EventSHYPO.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!EventSHYPO.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if ($match$) {
            stack.eat(target);
        }
        return ($match$);
    }
}
