/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlPhoneme</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="phoneme">
 *       <attribute name="ph">
 *         <text/>
 *       </attribute>
 *       <optional>
 *         <attribute name="alphabet">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <text/>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="phoneme"&gt;
 *       &lt;attribute name="ph"&gt;
 *         &lt;text/&gt;
 *       &lt;/attribute&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="alphabet"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;text/&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Thu Oct 02 00:02:04 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlPhoneme implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlPITCHMixed, IVxmlPITCHMixedChoice, IVxmlParagraphMixed, IVxmlParagraphMixedChoice, IVxmlEmphasisMixed, IVxmlEmphasisMixedChoice, IVxmlLANGMixed, IVxmlLANGMixedChoice, IVxmlSMixed, IVxmlSMixedChoice, IVxmlPRONMixed, IVxmlPRONMixedChoice, IVxmlPMixed, IVxmlPMixedChoice, IVxmlRATEMixed, IVxmlRATEMixedChoice, IVxmlSentenceMixed, IVxmlSentenceMixedChoice, IVxmlPARTOFSPMixed, IVxmlPARTOFSPMixedChoice, IVxmlVOLUMEMixed, IVxmlVOLUMEMixedChoice, IVxmlEnumerateMixed, IVxmlEnumerateMixedChoice, IVxmlSPELLMixed, IVxmlSPELLMixedChoice, IVxmlSPEECHMixed, IVxmlSPEECHMixedChoice, IVxmlEMPHMixed, IVxmlEMPHMixedChoice, IVxmlCONTEXTMixed, IVxmlCONTEXTMixedChoice, IVxmlJVOICEMixed, IVxmlJVOICEMixedChoice, IVxmlEmotionMixed, IVxmlEmotionMixedChoice, IVxmlVoiceMixed, IVxmlVoiceMixedChoice, IVxmlAudioMixed, IVxmlAudioMixedChoice, IVxmlProsodyMixed, IVxmlProsodyMixedChoice, IVxmlChoiceMixed, IVxmlChoiceMixedChoice, IVxmlPromptMixed, IVxmlPromptMixedChoice, IVxmlMediaMixedMixed, IVxmlMediaMixedMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String content_;
    private String ph_;
    private String alphabet_;
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlPhoneme</code>.
     *
     */
    public VxmlPhoneme() {
        ph_ = "";
    }

    /**
     * Creates a <code>VxmlPhoneme</code>.
     *
     * @param source
     */
    public VxmlPhoneme(VxmlPhoneme source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlPhoneme(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlPhoneme(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlPhoneme(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPhoneme(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlPhoneme</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPhoneme(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPhoneme(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPhoneme(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPhoneme(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlPhoneme</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlPhoneme(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the VxmlPhoneme <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlPhoneme source) {
        int size;
        content_ = source.content_;
        ph_ = source.ph_;
        alphabet_ = source.alphabet_;
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        content_ = URelaxer.getElementPropertyAsString(element);
        ph_ = URelaxer.getAttributePropertyAsString(element, "ph");
        alphabet_ = URelaxer.getAttributePropertyAsString(element, "alphabet");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlPhoneme((VxmlPhoneme)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "phoneme");
        rNSContext_.setupNamespace(element);
        URelaxer.setElementPropertyByString(element, this.content_);
        int size;
        if (this.ph_ != null) {
            URelaxer.setAttributePropertyByString(element, "ph", this.ph_);
        }
        if (this.alphabet_ != null) {
            URelaxer.setAttributePropertyByString(element, "alphabet", this.alphabet_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlPhoneme</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlPhoneme</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>content</b>.
     *
     * @return String
     */
    public String getContent() {
        return (content_);
    }

    /**
     * Sets the String property <b>content</b>.
     *
     * @param content
     */
    public void setContent(String content) {
        this.content_ = content;
    }

    /**
     * Gets the String property <b>ph</b>.
     *
     * @return String
     */
    public String getPh() {
        return (ph_);
    }

    /**
     * Sets the String property <b>ph</b>.
     *
     * @param ph
     */
    public void setPh(String ph) {
        this.ph_ = ph;
    }

    /**
     * Gets the String property <b>alphabet</b>.
     *
     * @return String
     */
    public String getAlphabet() {
        return (alphabet_);
    }

    /**
     * Sets the String property <b>alphabet</b>.
     *
     * @param alphabet
     */
    public void setAlphabet(String alphabet) {
        this.alphabet_ = alphabet;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "phoneme", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (ph_ != null) {
            buffer.append(" ");
            buffer.append("ph");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getPh())));
            buffer.append("\"");
        }
        if (alphabet_ != null) {
            buffer.append(" ");
            buffer.append("alphabet");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getAlphabet())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.append("</");
        URelaxer.makeQName(prefix, "phoneme", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "phoneme", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (ph_ != null) {
            buffer.write(" ");
            buffer.write("ph");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getPh())));
            buffer.write("\"");
        }
        if (alphabet_ != null) {
            buffer.write(" ");
            buffer.write("alphabet");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getAlphabet())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.write("</");
        URelaxer.makeQName(prefix, "phoneme", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "phoneme", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (ph_ != null) {
            buffer.print(" ");
            buffer.print("ph");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getPh())));
            buffer.print("\"");
        }
        if (alphabet_ != null) {
            buffer.print(" ");
            buffer.print("alphabet");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getAlphabet())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getContent())));
        buffer.print("</");
        URelaxer.makeQName(prefix, "phoneme", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getContentAsString() {
        return (URelaxer.getString(getContent()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPhAsString() {
        return (URelaxer.getString(getPh()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getAlphabetAsString() {
        return (URelaxer.getString(getAlphabet()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setContentByString(String string) {
        setContent(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPhByString(String string) {
        setPh(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setAlphabetByString(String string) {
        setAlphabet(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlPhoneme</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "phoneme")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "ph")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlPhoneme</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlPhoneme</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
