#!/usr/bin/env ruby -Ku
# coding: utf-8
# installer of /usr/local/galatea-engine
# $Id: setup_engine.rb,v 1.4 2009/06/04 00:31:10 nishimoto Exp $
# usage:
# $ cd galatea-engine-yyyymmdd
# $ sudo checkinstall ruby path/to/setup_engine.rb path/to/galatea-engine
# making deb package (using checkinstall)
# - http://d.hatena.ne.jp/nishimotz/20090218/1234967818

require 'fileutils'

EXIT_SUCCESS = 0
EXIT_FAILURE = -1
CHECK_TARGET = "/usr/local/galatea-engine"

dir = File.expand_path(ARGV.first)
unless dir
  puts "setup_engine.rb path/to/galatea-engine"
  exit
end

files = []
%w[ 00README.utf8.txt AM DM1 FSM SRM SSM TM ].each do |f|
  files << "#{dir}/#{f}"
end

if FileTest.exist?(CHECK_TARGET)
  puts "#{CHECK_TARGET} is already installed" 
  exit EXIT_SUCCESS
end

FileUtils.mkdir_p CHECK_TARGET
FileUtils.cp_r files, CHECK_TARGET, :preserve => true

if FileTest.exist?(CHECK_TARGET)
  puts "#{CHECK_TARGET} is succssfully installed" 
  exit EXIT_SUCCESS
end

puts "Error: #{CHECK_TARGET} cannot be installed" 
exit EXIT_FAILURE
