/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import ow.messaging.MessagingAddress;
import ow.messaging.util.MessagingUtility;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class InetMessagingAddress
implements MessagingAddress,
Externalizable {
    private InetSocketAddress addr;
    private volatile String cachedHostname = null;

    public InetMessagingAddress(int port) {
        this.addr = new InetSocketAddress(port);
        this.init();
    }

    public InetMessagingAddress(InetAddress addr, int port) {
        this.addr = new InetSocketAddress(addr, port);
        this.init();
    }

    public InetMessagingAddress(InetSocketAddress addr) {
        assert (addr != null);
        this.addr = addr;
        this.init();
    }

    public InetMessagingAddress(String hostAndPort, int defaultPort) throws UnknownHostException {
        this.addr = MessagingUtility.parseHostnameAndPort(hostAndPort, defaultPort).getInetSocketAddress();
        this.init();
    }

    public InetMessagingAddress(String hostAndPort) throws UnknownHostException {
        this.addr = MessagingUtility.parseHostnameAndPort(hostAndPort).getInetSocketAddress();
        this.init();
    }

    private void init() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread th = Thread.currentThread();
                String origName = th.getName();
                InetAddress inetAddr = InetMessagingAddress.this.addr.getAddress();
                th.setName("Resolving hostname for " + inetAddr.getHostAddress());
                try {
                    String hostname = inetAddr.getHostName();
                    if (hostname != null && hostname.length() > 0) {
                        InetMessagingAddress.this.cachedHostname = hostname;
                    }
                }
                finally {
                    th.setName(origName);
                }
            }
        };
        GlobalThreadPoolExecutors.getThreadPool(false, false, true).submit(r);
    }

    public String getHostAddress() {
        return this.addr.getAddress().getHostAddress();
    }

    public String getHostname() {
        String hostname = this.cachedHostname;
        if (hostname != null) {
            return hostname;
        }
        return "(not resolved)";
    }

    public String getHostnameOrHostAddress() {
        String hostname = this.cachedHostname;
        if (hostname != null) {
            return hostname;
        }
        return this.getHostAddress();
    }

    public void setInetAddress(InetAddress addr) {
        this.cachedHostname = null;
        int port = this.addr.getPort();
        this.addr = new InetSocketAddress(addr, port);
        this.init();
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public int hashCode() {
        return this.addr.hashCode();
    }

    public boolean equals(Object o) {
        InetMessagingAddress other;
        try {
            other = (InetMessagingAddress)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        try {
            return this.addr.equals(other.addr);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int verboseLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHostname());
        sb.append("/");
        sb.append(this.getHostAddress());
        if (verboseLevel >= 0) {
            sb.append(":");
            sb.append(this.addr.getPort());
        }
        return sb.toString();
    }

    public InetMessagingAddress() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] address = this.addr.getAddress().getAddress();
        int port = this.addr.getPort();
        int len = address.length;
        if (len < 255) {
            out.writeByte(len);
        } else {
            out.writeByte(255);
            out.writeInt(len);
        }
        out.write(address);
        out.writeChar(port);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readByte() & 0xFF;
        if (len == 255) {
            len = in.readInt();
        }
        byte[] address = new byte[len];
        in.readFully(address);
        char port = in.readChar();
        InetAddress inetAddr = InetAddress.getByAddress(address);
        this.addr = new InetSocketAddress(inetAddr, (int)port);
        this.init();
    }
}

