/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.udp;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.IDAddressPair;
import ow.messaging.ExtendedMessageHandler;
import ow.messaging.InetMessagingAddress;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Signature;
import ow.messaging.Tag;
import ow.messaging.udp.SocketPool;
import ow.messaging.udp.UDPMessageSender;
import ow.messaging.udp.UDPMessagingConfiguration;
import ow.messaging.udp.UDPMessagingMessageFactory;
import ow.messaging.udp.UDPMessagingProvider;
import ow.messaging.upnp.Mapping;
import ow.messaging.util.UPnPAddressPortMapper;
import ow.stat.MessagingReporter;
import ow.stat.StatConfiguration;
import ow.stat.StatFactory;
import ow.util.concurrent.GlobalThreadPoolExecutors;

public final class UDPMessageReceiver
implements MessageReceiver,
Runnable {
    private static final Logger logger = Logger.getLogger("messaging");
    private InetMessagingAddress selfAddr;
    protected DatagramChannel sock;
    protected UDPMessagingConfiguration config;
    protected UDPMessagingProvider provider;
    private UDPMessageSender sender;
    protected SocketPool sockPool;
    private Thread receiverThread;
    private Set<Thread> handlerThreads = Collections.synchronizedSet(new HashSet());
    private List<MessageHandler> handlerList = new ArrayList<MessageHandler>();
    protected boolean extMessageHandlerRegistered = false;
    private final MessagingReporter msgReporter;
    private static boolean oomPrinted = false;
    private Thread holePunchingDaemon = null;
    private final boolean doHolePunching;
    private int punchingRetry;
    private boolean firstPunchingDone = false;
    private boolean firstPunchingOnGoing = false;
    private Object firstPunchingLock = new Object();
    protected InetMessagingAddress lastSendDest = null;
    private long lastSendTime = 0L;
    private Object punchingLock = new Object();
    private volatile boolean punchReplyReceived;

    protected UDPMessageReceiver(InetAddress selfInetAddr, int port, int portRange, UDPMessagingConfiguration config, UDPMessagingProvider provider) throws IOException {
        InetMessagingAddress boundAddr;
        this.config = config;
        this.provider = provider;
        this.sock = DatagramChannel.open();
        if (selfInetAddr == null) {
            selfInetAddr = InetAddress.getLocalHost();
        }
        DatagramSocket s = this.sock.socket();
        this.selfAddr = this.bind(s, selfInetAddr, port, portRange);
        if (this.selfAddr == null && !selfInetAddr.equals(InetAddress.getLocalHost()) && (boundAddr = this.bind(s, InetAddress.getLocalHost(), port, portRange)) != null) {
            boundAddr.setInetAddress(selfInetAddr);
            this.selfAddr = boundAddr;
        }
        if (this.selfAddr == null) {
            String addrPort = selfInetAddr.getHostAddress() + ":" + port + "-" + (port + portRange - 1);
            logger.log(Level.SEVERE, "Could not bind to " + addrPort + "." + " Specify self hostname with -s option.");
            throw new IOException("Bind failed: " + addrPort);
        }
        this.sockPool = new SocketPool(config.getSocketPoolSize());
        StatConfiguration conf = StatFactory.getDefaultConfiguration();
        this.msgReporter = StatFactory.getMessagingReporter(conf, provider, this.getSender());
        this.sender = (UDPMessageSender)this.getSender(true);
        this.doHolePunching = this.config.getDoUDPHolePunching();
        this.punchingRetry = this.config.getPunchingRetry();
        if (this.config.getDoUPnPNATTraversal()) {
            String internalAddress = this.selfAddr.getHostAddress();
            UPnPAddressPortMapper.start(internalAddress, port, Mapping.Protocol.UDP, "Overlay Weaver", this.provider, config.getUPnPTimeout());
        }
    }

    private InetMessagingAddress bind(DatagramSocket sock, InetAddress inetAddr, int port, int range) {
        InetMessagingAddress addr = null;
        boolean bound = false;
        if (range <= 0) {
            range = 1;
        }
        for (int i = 0; i < range; ++i) {
            addr = new InetMessagingAddress(inetAddr, port + i);
            try {
                sock.bind(addr.getInetSocketAddress());
                port += i;
                bound = true;
                break;
            }
            catch (IOException e) {
                continue;
            }
        }
        if (!bound) {
            addr = null;
        }
        return addr;
    }

    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    public void setSelfAddress(String hostOrIP) {
        try {
            this.selfAddr = this.provider.getMessagingAddress(hostOrIP, this.selfAddr.getPort());
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "Could not resolve a hostname: " + hostOrIP);
        }
    }

    public int getPort() {
        return this.selfAddr.getPort();
    }

    public MessagingReporter getMessagingReporter() {
        return this.msgReporter;
    }

    public MessageSender getSender() {
        return this.getSender(false);
    }

    private MessageSender getSender(boolean forReceiver) {
        return new UDPMessageSender(this, forReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            if (this.receiverThread == null) {
                this.receiverThread = new Thread(this);
                this.receiverThread.setDaemon(true);
                this.receiverThread.setName("UDPMessageReceiver");
                this.receiverThread.setPriority(Thread.currentThread().getPriority() + this.config.getReceiverThreadPriority());
                this.receiverThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            if (this.receiverThread != null) {
                this.receiverThread.interrupt();
                this.receiverThread = null;
            }
        }
        Thread[] handlerArray = new Thread[this.handlerThreads.size()];
        this.handlerThreads.toArray(handlerArray);
        for (int i = 0; i < handlerArray.length; ++i) {
            handlerArray[i].interrupt();
        }
        this.handlerThreads.clear();
        UDPMessageReceiver uDPMessageReceiver2 = this;
        synchronized (uDPMessageReceiver2) {
            if (this.holePunchingDaemon != null) {
                this.holePunchingDaemon.interrupt();
                this.holePunchingDaemon = null;
            }
        }
        this.msgReporter.notifyStatCollectorOfDeletedNode(IDAddressPair.getIDAddressPair(null, (MessagingAddress)this.selfAddr), this.selfAddr, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(MessageHandler handler) {
        ArrayList<MessageHandler> newHandlerList = new ArrayList<MessageHandler>();
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            newHandlerList.addAll(this.handlerList);
            newHandlerList.add(handler);
            this.handlerList = newHandlerList;
        }
        if (handler instanceof ExtendedMessageHandler) {
            this.extMessageHandlerRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(MessageHandler handler) {
        ArrayList<MessageHandler> newHandlerList = new ArrayList<MessageHandler>();
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            newHandlerList.addAll(this.handlerList);
            newHandlerList.remove(handler);
            this.handlerList = newHandlerList;
        }
        boolean exists = false;
        for (MessageHandler h : newHandlerList) {
            if (!(h instanceof ExtendedMessageHandler)) continue;
            exists = true;
            break;
        }
        this.extMessageHandlerRegistered = exists;
    }

    public void run() {
        ByteBuffer buf = ByteBuffer.allocate(65536);
        InetSocketAddress srcAddr = null;
        while (true) {
            Message msg;
            buf.clear();
            try {
                srcAddr = (InetSocketAddress)this.sock.receive(buf);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "DatagramSocket#receive() threw an Exception and the receiver will die.");
                return;
            }
            buf.rewind();
            logger.log(Level.INFO, "Source address: " + srcAddr);
            try {
                msg = Message.decode(buf);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not decode the received message (corrupted ?).", e);
                continue;
            }
            byte[] acceptableSig = this.provider.getMessageSignature();
            byte[] sig = msg.getSignature();
            if (!Signature.match(sig, acceptableSig)) continue;
            UDPMessageHandler r = new UDPMessageHandler(srcAddr, msg);
            try {
                if (this.config.getUseThreadPool()) {
                    GlobalThreadPoolExecutors.getThreadPool(false, false, false).submit(r);
                    continue;
                }
                Thread thr = new Thread(r);
                thr.setDaemon(false);
                this.handlerThreads.add(thr);
                thr.start();
            }
            catch (OutOfMemoryError e) {
                logger.log(Level.SEVERE, "# of threads: " + Thread.activeCount(), e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message processMessage(Message msg) {
        List<MessageHandler> currentHandlerList;
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            currentHandlerList = this.handlerList;
        }
        Message ret = null;
        for (MessageHandler handler : currentHandlerList) {
            try {
                ret = handler.process(msg);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "A MessageHandler#process() threw an Exception.", e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postProcessMessage(Message msg) {
        List<MessageHandler> currentHandlerList;
        if (!this.extMessageHandlerRegistered) {
            return;
        }
        UDPMessageReceiver uDPMessageReceiver = this;
        synchronized (uDPMessageReceiver) {
            currentHandlerList = this.handlerList;
        }
        for (MessageHandler handler : currentHandlerList) {
            ExtendedMessageHandler extHandler;
            try {
                extHandler = (ExtendedMessageHandler)handler;
            }
            catch (ClassCastException e) {
                continue;
            }
            try {
                extHandler.postProcess(msg);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "A MessageHandler#postProcess() threw an Exception.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean isFirstPunchingDone() {
        Object object = this.firstPunchingLock;
        synchronized (object) {
            return this.firstPunchingDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beginFirstPunching() {
        Object object = this.firstPunchingLock;
        synchronized (object) {
            if (this.punchingRetry <= 0) {
                return false;
            }
            --this.punchingRetry;
            while (this.firstPunchingOnGoing) {
                try {
                    this.firstPunchingLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.firstPunchingDone) {
                return false;
            }
            this.firstPunchingOnGoing = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endFirstPunching(boolean success) {
        Object object = this.firstPunchingLock;
        synchronized (object) {
            this.firstPunchingOnGoing = false;
            this.firstPunchingDone = success;
            this.firstPunchingLock.notifyAll();
        }
    }

    protected void setLastSend(InetMessagingAddress dest) {
        this.lastSendDest = dest;
        if (this.isFirstPunchingDone()) {
            this.lastSendTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void punchHole() {
        long interval;
        if (!this.doHolePunching) {
            return;
        }
        if (this.lastSendDest == null) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (curTime < this.lastSendTime + (interval = this.config.getPunchingInterval())) {
            return;
        }
        Message reqMsg = UDPMessagingMessageFactory.getPunchHoleReqMessage(IDAddressPair.getIDAddressPair(null, (MessagingAddress)this.selfAddr));
        Object object = this.punchingLock;
        synchronized (object) {
            this.punchReplyReceived = false;
            try {
                this.sender.send(this.lastSendDest, reqMsg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not send an PUNCH_HOLE_REQ message for UDP hole punching: " + this.lastSendDest + " on " + this.selfAddr, e);
                return;
            }
            if (!this.punchReplyReceived) {
                try {
                    this.punchingLock.wait(this.config.getPunchingRepTimeout());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.endFirstPunching(this.punchReplyReceived);
            if (!this.punchReplyReceived) {
                logger.log(Level.WARNING, "Could not receive an PUNCH_HOLE_REP message for UDP hole punching: " + this.lastSendDest + " on " + this.selfAddr);
            }
        }
    }

    private class UDPHolePunchingDaemon
    implements Runnable {
        private UDPHolePunchingDaemon() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(UDPMessageReceiver.this.config.getPunchingCheckInterval());
                    if (!Thread.interrupted()) {
                        UDPMessageReceiver.this.punchHole();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "UDPHolePunchingDaemon interrupted and die.", e);
            }
        }
    }

    private class UDPMessageHandler
    implements Runnable {
        private InetSocketAddress srcAddr;
        private Message msg;

        UDPMessageHandler(InetSocketAddress srcAddress, Message message) {
            this.srcAddr = srcAddress;
            this.msg = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int tag;
            String origName;
            Thread th;
            block20: {
                Object src;
                th = Thread.currentThread();
                origName = th.getName();
                th.setName("UDPMessageHandler: " + this.srcAddr);
                tag = this.msg.getTag();
                Message ret = null;
                if (tag == Tag.PUNCH_HOLE_REQ.getNumber()) {
                    src = UDPMessageReceiver.this.provider.getMessagingAddress(this.srcAddr);
                    ret = UDPMessagingMessageFactory.getPunchHoleRepMessage(IDAddressPair.getIDAddressPair(null, (MessagingAddress)UDPMessageReceiver.this.selfAddr), (InetMessagingAddress)src);
                } else if (tag == Tag.PUNCH_HOLE_REP.getNumber()) {
                    src = UDPMessageReceiver.this.punchingLock;
                    synchronized (src) {
                        UDPMessageReceiver.this.punchReplyReceived = true;
                        UDPMessageReceiver.this.punchingLock.notifyAll();
                    }
                    if (UDPMessageReceiver.this.doHolePunching) {
                        Serializable[] contents = this.msg.getContents();
                        InetMessagingAddress selfExteriorAddress = (InetMessagingAddress)contents[0];
                        logger.log(Level.INFO, "UDP hole punching: self exterior address is " + selfExteriorAddress);
                        if (selfExteriorAddress.equals(UDPMessageReceiver.this.selfAddr)) {
                            logger.log(Level.INFO, "UDP hole punching was *not* required.");
                        } else {
                            UDPMessageReceiver.this.selfAddr = selfExteriorAddress;
                            UDPMessageReceiver uDPMessageReceiver = UDPMessageReceiver.this;
                            synchronized (uDPMessageReceiver) {
                                if (UDPMessageReceiver.this.holePunchingDaemon == null) {
                                    logger.log(Level.INFO, "UDP hole punching is required.");
                                    UDPHolePunchingDaemon r = new UDPHolePunchingDaemon();
                                    UDPMessageReceiver.this.holePunchingDaemon = new Thread(r);
                                    UDPMessageReceiver.this.holePunchingDaemon.setName("UDPHolePunchingDaemon");
                                    UDPMessageReceiver.this.holePunchingDaemon.setDaemon(true);
                                    UDPMessageReceiver.this.holePunchingDaemon.start();
                                }
                            }
                        }
                    }
                } else {
                    ret = UDPMessageReceiver.this.processMessage(this.msg);
                }
                if (ret != null) {
                    logger.log(Level.INFO, "Return a message.");
                    src = this.msg.getSource() != null ? this.msg.getSource().getAddress() : null;
                    try {
                        ByteBuffer buf = UDPMessageReceiver.this.sender.send(UDPMessageReceiver.this.sock, this.srcAddr, (MessagingAddress)src, ret, true);
                        if (src != null) {
                            UDPMessageReceiver.this.msgReporter.notifyStatCollectorOfMessageSent((MessagingAddress)src, ret, buf.remaining());
                        }
                        break block20;
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Could not return a message.");
                        if (src != null) {
                            UDPMessageReceiver.this.msgReporter.notifyStatCollectorOfDeletedNode(ret.getSource(), (MessagingAddress)src, ret.getTag());
                        }
                        break block20;
                    }
                }
                logger.log(Level.INFO, "Return no message.");
            }
            if (tag != Tag.PUNCH_HOLE_REQ.getNumber() && tag != Tag.PUNCH_HOLE_REP.getNumber()) {
                UDPMessageReceiver.this.postProcessMessage(this.msg);
            }
            UDPMessageReceiver.this.handlerThreads.remove(Thread.currentThread());
            th.setName(origName);
        }
    }
}

