/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGetCommand
implements Command<Memcached> {
    AbstractGetCommand() {
    }

    protected boolean get(ShellContext<Memcached> context, boolean returnCasUnique) {
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("ERROR\r\n");
            out.flush();
            return false;
        }
        ID[] keys = new ID[args.length];
        for (int i = 0; i < args.length; ++i) {
            keys[i] = IDUtility.parseID(args[i], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
        }
        Set<ValueInfo<V>>[] values = dht.get(keys);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (values[i] == null || values[i].isEmpty()) continue;
            for (ValueInfo v : values[i]) {
                Item item = (Item)v.getValue();
                sb.append("VALUE ").append(args[i]);
                sb.append(" ").append(item.getFlag());
                sb.append(" ").append(item.getData().length);
                if (returnCasUnique) {
                    long casUnique = item.hashCode();
                    if (casUnique < 0L) {
                        casUnique += 0x100000000L;
                    }
                    sb.append(" ").append(casUnique);
                }
                sb.append("\r\n");
                try {
                    sb.append(new String(item.getData(), "ASCII"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                sb.append("\r\n");
            }
        }
        sb.append("END").append("\r\n");
        out.print(sb);
        out.flush();
        return false;
    }
}

