/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import ow.util.Timer;

public final class AlarmClock
extends TimerTask {
    private static Timer timer = new Timer("Alarm Timer", true);
    private static Map<Thread, TimerTask> timerTable = new HashMap<Thread, TimerTask>();
    private Thread target;
    private boolean oneShot;

    private AlarmClock(Thread target, boolean oneShot) {
        this.target = target;
        this.oneShot = oneShot;
    }

    public static void setAlarm(long timeout) {
        AlarmClock.setAlarm(timeout, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAlarm(long timeout, long interval) {
        boolean oneShot = interval <= 0L;
        Thread curThread = Thread.currentThread();
        AlarmClock task = new AlarmClock(curThread, oneShot);
        Map<Thread, TimerTask> map = timerTable;
        synchronized (map) {
            timerTable.put(curThread, task);
        }
        long absoluteTimeout = System.currentTimeMillis() + timeout;
        if (oneShot) {
            timer.schedule(task, absoluteTimeout, true);
        } else {
            timer.scheduleAtFixedRate(task, absoluteTimeout, interval, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAlarm() throws InterruptedException, ClosedByInterruptException {
        TimerTask task = null;
        Map<Thread, TimerTask> map = timerTable;
        synchronized (map) {
            task = timerTable.remove(Thread.currentThread());
        }
        if (task != null) {
            timer.cancel(task);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException("Timer#clearTimer() detected current thread has been interrupted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.target.interrupt();
        Map<Thread, TimerTask> map = timerTable;
        synchronized (map) {
            if (this.oneShot) {
                timerTable.remove(this.target);
            }
        }
    }
}

