/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassModelSupport {
    public void addImportName(ClassModel classModel, Class<?> importClass) {
        String importedPackageName = ClassUtil.getPackageName(importClass);
        if (this.isImportTargetPackage(classModel, importedPackageName)) {
            classModel.addImportName(importClass.getName());
        }
    }

    public void addImportName(ClassModel classModel, String importClassName) {
        String importedPackageName = ClassUtil.splitPackageAndShortClassName((String)importClassName)[0];
        if (this.isImportTargetPackage(classModel, importedPackageName)) {
            classModel.addImportName(importClassName);
        }
    }

    protected boolean isImportTargetPackage(ClassModel classModel, String importPackageName) {
        if (importPackageName == null) {
            return false;
        }
        if (importPackageName.equals(classModel.getPackageName())) {
            return false;
        }
        return !importPackageName.equals("java.lang");
    }

    public void addStaticImportName(ClassModel classModel, Class<?> importClass) {
        String importedPackageName = ClassUtil.getPackageName(importClass);
        if (this.isStaticImportTargetPackage(classModel, importedPackageName)) {
            classModel.addStaticImportName(importClass.getName() + ".*");
        }
    }

    public void addStaticImportName(ClassModel classModel, String importClassName) {
        String importedPackageName = ClassUtil.splitPackageAndShortClassName((String)importClassName)[0];
        if (this.isStaticImportTargetPackage(classModel, importedPackageName)) {
            classModel.addStaticImportName(importClassName + ".*");
        }
    }

    protected boolean isStaticImportTargetPackage(ClassModel classModel, String importPackageName) {
        return importPackageName != null;
    }
}

