/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.annotation.Generated;
import org.junit.runner.RunWith;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JdbcManager;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.internal.model.ClassModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.EntityTestModel;
import org.seasar.extension.jdbc.gen.model.EntityTestModelFactory;
import org.seasar.extension.jdbc.gen.model.NamesModel;
import org.seasar.extension.jdbc.gen.model.NamesModelFactory;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.unit.Seasar2;
import org.seasar.framework.unit.TestContext;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTestModelFactoryImpl
implements EntityTestModelFactory {
    protected String configPath;
    protected String jdbcManagerName;
    protected String testClassNameSuffix;
    protected boolean useS2junit4;
    protected NamesModelFactory namesModelFactory;
    protected boolean useNamesClass;
    protected ClassModelSupport classModelSupport = new ClassModelSupport();
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public EntityTestModelFactoryImpl(String configPath, String jdbcManagerName, String testClassNameSuffix, NamesModelFactory namesModelFactory, boolean useNamesClass, boolean useS2junit4) {
        if (configPath == null) {
            throw new NullPointerException("configPath");
        }
        if (jdbcManagerName == null) {
            throw new NullPointerException("jdbcManagerName");
        }
        if (testClassNameSuffix == null) {
            throw new NullPointerException("testClassNameSuffix");
        }
        if (namesModelFactory == null) {
            throw new NullPointerException("namesModelFactory");
        }
        this.configPath = configPath;
        this.jdbcManagerName = jdbcManagerName;
        this.testClassNameSuffix = testClassNameSuffix;
        this.namesModelFactory = namesModelFactory;
        this.useNamesClass = useNamesClass;
        this.useS2junit4 = useS2junit4;
    }

    @Override
    public EntityTestModel getEntityTestModel(EntityMeta entityMeta) {
        EntityTestModel entityTestModel = new EntityTestModel();
        entityTestModel.setConfigPath(this.configPath);
        entityTestModel.setJdbcManagerName(this.jdbcManagerName);
        String packageName = ClassUtil.splitPackageAndShortClassName((String)entityMeta.getEntityClass().getName())[0];
        entityTestModel.setPackageName(packageName);
        entityTestModel.setShortClassName(entityMeta.getName() + this.testClassNameSuffix);
        entityTestModel.setShortEntityClassName(entityMeta.getName());
        entityTestModel.setUseS2junit4(this.useS2junit4);
        this.doIdValue(entityTestModel, entityMeta);
        this.doAssociationName(entityTestModel, entityMeta);
        this.doNamesModel(entityTestModel, entityMeta);
        this.doImportName(entityTestModel, entityMeta);
        this.doGeneratedInfo(entityTestModel, entityMeta);
        return entityTestModel;
    }

    protected void doIdValue(EntityTestModel entityTestModel, EntityMeta entityMeta) {
        for (PropertyMeta propertyMeta : entityMeta.getIdPropertyMetaList()) {
            Class propertyClass = propertyMeta.getPropertyClass();
            entityTestModel.addIdExpression(this.getExpression(propertyClass));
        }
    }

    protected String getExpression(Class<?> propertyClass) {
        Class clazz = ClassUtil.getPrimitiveClassIfWrapper(propertyClass);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "true";
            }
            if (clazz == Character.TYPE) {
                return "'a'";
            }
            if (clazz == Byte.TYPE) {
                return "(byte) 1";
            }
            if (clazz == Short.TYPE) {
                return "(short) 1";
            }
            if (clazz == Integer.TYPE) {
                return "1";
            }
            if (clazz == Long.TYPE) {
                return "1L";
            }
            if (clazz == Float.TYPE) {
                return "1f";
            }
            if (clazz == Double.TYPE) {
                return "1d";
            }
        }
        if (clazz == String.class) {
            return "\"aaa\"";
        }
        if (clazz == BigDecimal.class) {
            return "BigDecimal.ONE";
        }
        if (clazz == BigInteger.class) {
            return "BigInteger.ONE";
        }
        if (clazz == java.util.Date.class) {
            return "new Date()";
        }
        if (clazz == Calendar.class) {
            return "Calendar.getInstance()";
        }
        if (clazz == Date.class) {
            return "Date.valueOf(\"2008-01-01\")";
        }
        if (clazz == Timestamp.class) {
            return "Timestamp.valueOf(\"2008-01-01 12:00:00\")";
        }
        if (clazz == Time.class) {
            return "Time.valueOf(\"12:00:00\")";
        }
        throw new IllegalArgumentException("propertyClass");
    }

    protected void doAssociationName(EntityTestModel entityTestModel, EntityMeta entityMeta) {
        for (PropertyMeta propertyMeta : entityMeta.getAllPropertyMeta()) {
            if (!propertyMeta.isRelationship()) continue;
            entityTestModel.addAssociationName(propertyMeta.getName());
        }
    }

    protected void doNamesModel(EntityTestModel entityTestModel, EntityMeta entityMeta) {
        boolean relationshipExistent = false;
        for (PropertyMeta propertyMeta : entityMeta.getAllPropertyMeta()) {
            if (!propertyMeta.isRelationship()) continue;
            relationshipExistent = true;
            break;
        }
        if (relationshipExistent && this.useNamesClass) {
            NamesModel namesModel = this.namesModelFactory.getNamesModel(entityMeta);
            entityTestModel.setNamesModel(namesModel);
        }
    }

    protected void doImportName(EntityTestModel entityTestModel, EntityMeta entityMeta) {
        this.classModelSupport.addImportName((ClassModel)entityTestModel, JdbcManager.class);
        this.classModelSupport.addImportName((ClassModel)entityTestModel, Generated.class);
        if (this.useS2junit4) {
            this.classModelSupport.addImportName((ClassModel)entityTestModel, RunWith.class);
            this.classModelSupport.addImportName((ClassModel)entityTestModel, Seasar2.class);
            this.classModelSupport.addImportName((ClassModel)entityTestModel, TestContext.class);
        } else {
            this.classModelSupport.addImportName((ClassModel)entityTestModel, S2TestCase.class);
        }
        NamesModel namesModel = entityTestModel.getNamesModel();
        if (namesModel != null) {
            String namesClassName = ClassUtil.concatName((String)namesModel.getPackageName(), (String)namesModel.getShortClassName());
            this.classModelSupport.addStaticImportName((ClassModel)entityTestModel, namesClassName);
        }
        for (PropertyMeta propertyMeta : entityMeta.getIdPropertyMetaList()) {
            this.classModelSupport.addImportName((ClassModel)entityTestModel, propertyMeta.getPropertyClass());
        }
    }

    protected void doGeneratedInfo(EntityTestModel entityTestModel, EntityMeta entityMeta) {
        this.generatedModelSupport.fillGeneratedInfo(this, entityTestModel);
    }
}

