/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;

class LogBufferPool {
    private static final String DEBUG_NAME = LogBufferPool.class.getName();
    private EnvironmentImpl envImpl = null;
    private int logBufferSize;
    private LinkedList<LogBuffer> bufferPool;
    private LogBuffer currentWriteBuffer;
    private FileManager fileManager;
    private long nNotResident = 0L;
    private long nCacheMiss = 0L;
    private boolean runInMemory;
    private Latch bufferPoolLatch;

    LogBufferPool(FileManager fileManager, EnvironmentImpl envImpl) throws DatabaseException {
        this.fileManager = fileManager;
        this.envImpl = envImpl;
        this.bufferPoolLatch = new Latch(DEBUG_NAME + "_FullLatch");
        DbConfigManager configManager = envImpl.getConfigManager();
        this.runInMemory = envImpl.isMemOnly();
        this.reset(configManager);
        this.currentWriteBuffer = this.bufferPool.getFirst();
    }

    final int getLogBufferSize() {
        return this.logBufferSize;
    }

    void reset(DbConfigManager configManager) throws DatabaseException {
        if (this.runInMemory && this.bufferPool != null) {
            return;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long logBufferBudget = this.envImpl.getMemoryBudget().getLogBufferBudget();
        int newBufferSize = (int)logBufferBudget / numBuffers;
        LinkedList<LogBuffer> newPool = new LinkedList<LogBuffer>();
        if (this.runInMemory) {
            numBuffers = 1;
        }
        for (int i = 0; i < numBuffers; ++i) {
            newPool.add(new LogBuffer(newBufferSize, this.envImpl));
        }
        this.bufferPoolLatch.acquire();
        this.bufferPool = newPool;
        this.logBufferSize = newBufferSize;
        this.bufferPoolLatch.release();
    }

    LogBuffer getWriteBuffer(int sizeNeeded, boolean flippedFile) throws IOException, DatabaseException {
        if (!this.currentWriteBuffer.hasRoom(sizeNeeded) || flippedFile) {
            this.writeBufferToFile(sizeNeeded);
        }
        if (flippedFile && !this.runInMemory) {
            this.fileManager.syncLogEndAndFinishFile();
        }
        return this.currentWriteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeBufferToFile(int sizeNeeded) throws IOException, DatabaseException {
        int bufferSize = this.logBufferSize > sizeNeeded ? this.logBufferSize : sizeNeeded;
        this.currentWriteBuffer.latchForWrite();
        LogBuffer latchedBuffer = this.currentWriteBuffer;
        try {
            ByteBuffer currentByteBuffer = this.currentWriteBuffer.getDataBuffer();
            int savePosition = currentByteBuffer.position();
            int saveLimit = currentByteBuffer.limit();
            currentByteBuffer.flip();
            if (this.runInMemory) {
                latchedBuffer.release();
                latchedBuffer = null;
                this.bufferPoolLatch.acquire();
                this.currentWriteBuffer = new LogBuffer(bufferSize, this.envImpl);
                this.bufferPool.add(this.currentWriteBuffer);
                this.bufferPoolLatch.release();
            } else {
                try {
                    this.fileManager.writeLogBuffer(this.currentWriteBuffer);
                    this.currentWriteBuffer.getDataBuffer().rewind();
                    latchedBuffer.release();
                    latchedBuffer = null;
                    LogBuffer nextToUse = null;
                    try {
                        this.bufferPoolLatch.acquire();
                        Iterator iter = this.bufferPool.iterator();
                        nextToUse = (LogBuffer)iter.next();
                        boolean done = this.bufferPool.remove(nextToUse);
                        assert (done);
                        nextToUse.reinit();
                        this.bufferPool.add(nextToUse);
                        this.currentWriteBuffer = nextToUse;
                        Object var11_11 = null;
                        this.bufferPoolLatch.releaseIfOwner();
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        this.bufferPoolLatch.releaseIfOwner();
                        throw throwable;
                    }
                }
                catch (DatabaseException DE) {
                    currentByteBuffer.position(savePosition);
                    currentByteBuffer.limit(saveLimit);
                    throw DE;
                }
            }
            Object var13_14 = null;
            if (latchedBuffer == null) return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (latchedBuffer == null) throw throwable;
            latchedBuffer.release();
            throw throwable;
        }
        latchedBuffer.release();
    }

    void writeCompleted(long lsn, boolean flushRequired) throws DatabaseException, IOException {
        this.currentWriteBuffer.registerLsn(lsn);
        if (flushRequired) {
            this.writeBufferToFile(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogBuffer getReadBuffer(long lsn) throws DatabaseException {
        LogBuffer foundBuffer = null;
        this.bufferPoolLatch.acquire();
        try {
            ++this.nNotResident;
            for (LogBuffer l : this.bufferPool) {
                if (!l.containsLsn(lsn)) continue;
                foundBuffer = l;
                break;
            }
            if (foundBuffer == null && this.currentWriteBuffer.containsLsn(lsn)) {
                foundBuffer = this.currentWriteBuffer;
            }
            if (foundBuffer == null) {
                ++this.nCacheMiss;
            }
            Object var7_5 = null;
            this.bufferPoolLatch.releaseIfOwner();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.bufferPoolLatch.releaseIfOwner();
            throw throwable;
        }
        if (foundBuffer == null) {
            return null;
        }
        return foundBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStats(StatsConfig config, EnvironmentStats stats) throws DatabaseException {
        stats.setNCacheMiss(this.nCacheMiss);
        stats.setNNotResident(this.nNotResident);
        if (config.getClear()) {
            this.nCacheMiss = 0L;
            this.nNotResident = 0L;
        }
        this.bufferPoolLatch.acquire();
        long bufferBytes = 0L;
        int nLogBuffers = 0;
        try {
            for (LogBuffer l : this.bufferPool) {
                ++nLogBuffers;
                bufferBytes += (long)l.getCapacity();
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.bufferPoolLatch.release();
            throw throwable;
        }
        this.bufferPoolLatch.release();
        stats.setNLogBuffers(nLogBuffers);
        stats.setBufferBytes(bufferBytes);
    }
}

