/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.Txn;
import java.nio.ByteBuffer;

public final class NameLN
extends LN {
    private static final String BEGIN_TAG = "<nameLN>";
    private static final String END_TAG = "</nameLN>";
    private DatabaseId id;
    private boolean deleted;

    public NameLN(DatabaseId id, EnvironmentImpl envImpl, boolean replicate) {
        super(new byte[0], envImpl, replicate);
        this.id = id;
        this.deleted = false;
    }

    public NameLN() {
        this.id = new DatabaseId();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    void makeDeleted() {
        this.deleted = true;
    }

    public DatabaseId getId() {
        return this.id;
    }

    public void setId(DatabaseId id) {
        this.id = id;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<deleted val=\"").append(Boolean.toString(this.deleted));
        sb.append("\">");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<id val=\"").append(this.id);
        sb.append("\">");
        sb.append('\n');
        return sb.toString();
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_NAMELN_TRANSACTIONAL;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_NAMELN;
    }

    public int getLogSize() {
        return super.getLogSize() + this.id.getLogSize() + 1;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.id.writeToLog(logBuffer);
        byte booleans = (byte)(this.deleted ? 1 : 0);
        logBuffer.put(booleans);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        super.readFromLog(itemBuffer, entryVersion);
        this.id.readFromLog(itemBuffer, entryVersion);
        byte booleans = itemBuffer.get();
        this.deleted = (booleans & 1) != 0;
    }

    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof NameLN)) {
            return false;
        }
        NameLN otherLN = (NameLN)other;
        if (this.getNodeId() != otherLN.getNodeId()) {
            return false;
        }
        if (!this.id.equals(otherLN.id)) {
            return false;
        }
        return this.deleted == otherLN.deleted;
    }

    protected void dumpLogAdditional(StringBuffer sb, boolean verbose) {
        this.id.dumpLog(sb, true);
    }

    LNLogEntry createLogEntry(LogEntryType entryType, DatabaseImpl dbImpl, byte[] key, byte[] delDupKey, long logAbortLsn, boolean logAbortKnownDeleted, Txn logTxn, ReplicationContext repContext) {
        return new NameLNLogEntry(entryType, this, dbImpl.getId(), key, logAbortLsn, logAbortKnownDeleted, logTxn, repContext);
    }
}

