/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;
    private boolean _jvmBug0;
    private boolean _jvmBug1;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel channel, Object att) throws IOException {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) throws IOException {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean delaySelectKeyUpdate) {
        this._delaySelectKeyUpdate = delaySelectKeyUpdate;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                SelectSet set = sets[i];
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        Log.warn((Throwable)ex);
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private transient int _jvmBug;
        private volatile boolean _selecting;

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTimeout = new Timeout((Object)this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout((Object)this);
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object point) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(point);
                if (point instanceof SocketChannel) {
                    this._changes[this._change].add(null);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(SocketChannel channel, Object att) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(channel);
                this._changes[this._change].add(att);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doSelect() throws IOException {
            Iterator<SelectionKey> iterator;
            Selector new_selector;
            block59: {
                SelectionKey key = null;
                try {
                    try {
                        long now;
                        Selector selector;
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        List[] listArray = this._changes;
                                        // MONITORENTER : this._changes
                                        List changes = this._changes[this._change];
                                        this._change = this._change == 0 ? 1 : 0;
                                        this._selecting = true;
                                        selector = this._selector;
                                        // MONITOREXIT : listArray
                                        for (int i = 0; i < changes.size(); ++i) {
                                            try {
                                                AbstractSelectableChannel channel;
                                                Object o = changes.get(i);
                                                if (o instanceof EndPoint) {
                                                    SelectChannelEndPoint endpoint = (SelectChannelEndPoint)o;
                                                    endpoint.doUpdateKey();
                                                    continue;
                                                }
                                                if (o instanceof Runnable) {
                                                    SelectorManager.this.dispatch((Runnable)o);
                                                    continue;
                                                }
                                                if (o instanceof SocketChannel) {
                                                    channel = (SocketChannel)o;
                                                    Object att = changes.get(++i);
                                                    if (((SocketChannel)channel).isConnected()) {
                                                        key = channel.register(selector, 1, att);
                                                        SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint((SocketChannel)channel, this, key);
                                                        key.attach(endpoint);
                                                        endpoint.dispatch();
                                                        continue;
                                                    }
                                                    channel.register(selector, 8, att);
                                                    continue;
                                                }
                                                if (!(o instanceof ServerSocketChannel)) throw new IllegalArgumentException(o.toString());
                                                channel = (ServerSocketChannel)o;
                                                channel.register(this.getSelector(), 16);
                                                continue;
                                            }
                                            catch (CancelledKeyException e) {
                                                if (SelectorManager.this.isRunning()) {
                                                    Log.warn((Throwable)e);
                                                    continue;
                                                }
                                                Log.debug((Throwable)e);
                                            }
                                        }
                                        changes.clear();
                                        long idle_next = 0L;
                                        long retry_next = 0L;
                                        now = System.currentTimeMillis();
                                        SelectSet selectSet = this;
                                        // MONITORENTER : selectSet
                                        this._idleTimeout.setNow(now);
                                        this._retryTimeout.setNow(now);
                                        if (SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections) {
                                            this._idleTimeout.setDuration(SelectorManager.this._lowResourcesMaxIdleTime);
                                        } else {
                                            this._idleTimeout.setDuration(SelectorManager.this._maxIdleTime);
                                        }
                                        idle_next = this._idleTimeout.getTimeToNext();
                                        retry_next = this._retryTimeout.getTimeToNext();
                                        // MONITOREXIT : selectSet
                                        long wait = 1000L;
                                        if (idle_next >= 0L && wait > idle_next) {
                                            wait = idle_next;
                                        }
                                        if (wait > 0L && retry_next >= 0L && wait > retry_next) {
                                            wait = retry_next;
                                        }
                                        if (wait <= 10L) break block60;
                                        long before = now;
                                        int selected = selector.select(wait);
                                        now = System.currentTimeMillis();
                                        this._idleTimeout.setNow(now);
                                        this._retryTimeout.setNow(now);
                                        if (selected == 0 && wait > 0L && now - before < wait / 2L) {
                                            ++this._jvmBug;
                                            if (this._jvmBug > 16) {
                                                SelectSet selectSet2 = this;
                                                // MONITORENTER : selectSet2
                                                if (SelectorManager.this._jvmBug1) {
                                                    Log.debug((String)"seeing JVM BUG(s) - recreating selector");
                                                } else {
                                                    SelectorManager.this._jvmBug1 = true;
                                                    Log.info((String)"seeing JVM BUG(s) - recreating selector");
                                                }
                                                new_selector = Selector.open();
                                                iterator = this._selector.keys().iterator();
                                                break block59;
                                            }
                                            if (this._jvmBug > 8) {
                                                if (SelectorManager.this._jvmBug0) {
                                                    Log.debug((String)"seeing JVM BUG(s) - cancelling interestOps==0");
                                                } else {
                                                    SelectorManager.this._jvmBug0 = true;
                                                    Log.info((String)"seeing JVM BUG(s) - cancelling interestOps==0");
                                                }
                                                Iterator<SelectionKey> iter = selector.keys().iterator();
                                                while (iter.hasNext()) {
                                                    SelectionKey k = iter.next();
                                                    if (!k.isValid() || k.interestOps() != 0) continue;
                                                    k.cancel();
                                                }
                                                Object var26_35 = null;
                                                this._selecting = false;
                                                return;
                                            }
                                            break block61;
                                        } else {
                                            this._jvmBug = 0;
                                        }
                                        break block61;
                                    }
                                    selector.selectNow();
                                    this._jvmBug = 0;
                                }
                                if (this._selector == null) break block62;
                                if (selector.isOpen()) break block63;
                            }
                            Object var26_36 = null;
                            this._selecting = false;
                            return;
                        }
                        Iterator<SelectionKey> iter = selector.selectedKeys().iterator();
                        while (iter.hasNext()) {
                            key = iter.next();
                            try {
                                block65: {
                                    SocketChannel channel;
                                    Object att;
                                    block66: {
                                        block64: {
                                            if (!key.isValid()) {
                                                key.cancel();
                                                SelectChannelEndPoint endpoint = (SelectChannelEndPoint)key.attachment();
                                                if (endpoint == null) continue;
                                                endpoint.doUpdateKey();
                                                continue;
                                            }
                                            att = key.attachment();
                                            if (!(att instanceof SelectChannelEndPoint)) break block64;
                                            SelectChannelEndPoint endpoint = (SelectChannelEndPoint)att;
                                            endpoint.dispatch();
                                            break block65;
                                        }
                                        if (!key.isAcceptable()) break block66;
                                        channel = SelectorManager.this.acceptChannel(key);
                                        if (channel == null) continue;
                                        channel.configureBlocking(false);
                                        ++this._nextSet;
                                        this._nextSet %= SelectorManager.this._selectSet.length;
                                        if (this._nextSet == this._setID) {
                                            SelectionKey cKey = channel.register(SelectorManager.this._selectSet[this._nextSet].getSelector(), 1);
                                            SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint(channel, SelectorManager.this._selectSet[this._nextSet], cKey);
                                            cKey.attach(endpoint);
                                            if (endpoint != null) {
                                                endpoint.dispatch();
                                            }
                                            break block65;
                                        } else {
                                            SelectorManager.this._selectSet[this._nextSet].addChange(channel);
                                            SelectorManager.this._selectSet[this._nextSet].wakeup();
                                        }
                                        break block65;
                                    }
                                    if (key.isConnectable()) {
                                        SelectChannelEndPoint endpoint;
                                        Object var23_43;
                                        channel = (SocketChannel)key.channel();
                                        boolean connected = false;
                                        try {
                                            try {
                                                connected = channel.finishConnect();
                                            }
                                            catch (Exception e) {
                                                SelectorManager.this.connectionFailed(channel, e, att);
                                                var23_43 = null;
                                                if (connected) {
                                                    key.interestOps(1);
                                                    endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                                    key.attach(endpoint);
                                                    endpoint.dispatch();
                                                }
                                                key.cancel();
                                            }
                                            var23_43 = null;
                                            if (connected) {
                                                key.interestOps(1);
                                                endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                                key.attach(endpoint);
                                                endpoint.dispatch();
                                            }
                                            key.cancel();
                                        }
                                        catch (Throwable throwable) {
                                            var23_43 = null;
                                            if (connected) {
                                                key.interestOps(1);
                                                endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                                key.attach(endpoint);
                                                endpoint.dispatch();
                                                throw throwable;
                                            }
                                            key.cancel();
                                            throw throwable;
                                        }
                                    } else {
                                        channel = (SocketChannel)key.channel();
                                        SelectChannelEndPoint endpoint = SelectorManager.this.newEndPoint(channel, this, key);
                                        key.attach(endpoint);
                                        if (key.isReadable()) {
                                            endpoint.dispatch();
                                        }
                                    }
                                }
                                key = null;
                            }
                            catch (CancelledKeyException e) {
                                Log.ignore((Throwable)e);
                            }
                            catch (Exception e) {
                                if (SelectorManager.this.isRunning()) {
                                    Log.warn((Throwable)e);
                                } else {
                                    Log.ignore((Throwable)e);
                                }
                                if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                                key.interestOps(0);
                                key.cancel();
                            }
                        }
                        selector.selectedKeys().clear();
                        this._idleTimeout.tick(now);
                        this._retryTimeout.tick(now);
                    }
                    catch (CancelledKeyException e) {
                        Log.ignore((Throwable)e);
                        Object var26_38 = null;
                        this._selecting = false;
                        return;
                    }
                    Object var26_37 = null;
                    this._selecting = false;
                    return;
                }
                catch (Throwable throwable) {
                    Object var26_39 = null;
                    this._selecting = false;
                    throw throwable;
                }
            }
            while (true) {
                if (!iterator.hasNext()) {
                    this._selector.close();
                    this._selector = new_selector;
                    // MONITOREXIT : selectSet2
                    Object var26_34 = null;
                    this._selecting = false;
                    return;
                }
                SelectionKey k = iterator.next();
                SelectableChannel channel = k.channel();
                Object attachment = k.attachment();
                k.cancel();
                if (attachment == null) {
                    this.addChange(channel);
                    continue;
                }
                this.addChange(attachment);
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long timeout) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, timeout);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean selecting = true;
            while (selecting) {
                this.wakeup();
                selecting = this._selecting;
            }
            ArrayList<SelectionKey> keys = new ArrayList<SelectionKey>(this._selector.keys());
            Iterator<SelectionKey> iter = keys.iterator();
            while (iter.hasNext()) {
                EndPoint endpoint;
                SelectionKey key = iter.next();
                if (key == null || (endpoint = (EndPoint)key.attachment()) == null) continue;
                try {
                    endpoint.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                selecting = this._selecting;
                while (selecting) {
                    this.wakeup();
                    selecting = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
                this._selector = null;
            }
        }
    }
}

