/*
 * Decompiled with CFR 0.152.
 */
package mx4j.loading;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import mx4j.loading.MLetParseException;
import mx4j.loading.MLetTag;

public class MLetParser {
    public static final String OPEN_COMMENT = "<!--";
    public static final String CLOSE_COMMENT = "-->";
    public static final String OPEN_BRACKET = "<";
    public static final String CLOSE_BRACKET = ">";
    public static final String MLET_TAG = "MLET";
    public static final String CODE_ATTR = "CODE";
    public static final String OBJECT_ATTR = "OBJECT";
    public static final String ARCHIVE_ATTR = "ARCHIVE";
    public static final String CODEBASE_ATTR = "CODEBASE";
    public static final String NAME_ATTR = "NAME";
    public static final String VERSION_ATTR = "VERSION";
    public static final String ARG_TAG = "ARG";
    public static final String TYPE_ATTR = "TYPE";
    public static final String VALUE_ATTR = "VALUE";
    private MLet mlet;
    static /* synthetic */ Class class$java$lang$String;

    public MLetParser() {
    }

    public MLetParser(MLet mlet) {
        this.mlet = mlet;
    }

    public List parse(String content) throws MLetParseException {
        if (content == null) {
            throw new MLetParseException("MLet file content cannot be null");
        }
        content = this.stripComments(content.trim());
        ArrayList mlets = this.parseMLets(content = this.convertToUpperCase(content));
        if (mlets.size() < 1) {
            throw new MLetParseException("MLet file is empty");
        }
        ArrayList<MLetTag> mletTags = new ArrayList<MLetTag>();
        for (int i = 0; i < mlets.size(); ++i) {
            String mletTag = (String)mlets.get(i);
            MLetTag tag = this.parseMLet(mletTag);
            mletTags.add(tag);
        }
        return mletTags;
    }

    private MLetTag parseMLet(String content) throws MLetParseException {
        MLetTag tag = new MLetTag();
        this.parseMLetAttributes(tag, content);
        this.parseMLetArguments(tag, content);
        return tag;
    }

    private ArrayList parseMLets(String content) throws MLetParseException {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int current = -1;
        while ((current = this.findOpenTag(content, start, MLET_TAG)) >= 0) {
            int end = this.findCloseTag(content, current + 1, MLET_TAG, true);
            if (end < 0) {
                throw new MLetParseException("MLET tag not closed at index: " + current);
            }
            String mlet = content.substring(current, end);
            list.add(mlet);
            start = end + 1;
        }
        return list;
    }

    private void parseMLetArguments(MLetTag tag, String content) throws MLetParseException {
        int start = 0;
        int current = -1;
        while ((current = this.findOpenTag(content, start, ARG_TAG)) >= 0) {
            int end = this.findCloseTag(content, current + 1, ARG_TAG, false);
            if (end < 0) {
                throw new MLetParseException("ARG tag not closed");
            }
            String arg = content.substring(current, end);
            int type = arg.indexOf(TYPE_ATTR);
            if (type < 0) {
                throw new MLetParseException("Missing TYPE attribute");
            }
            int value = arg.indexOf(VALUE_ATTR);
            if (value < 0) {
                throw new MLetParseException("Missing VALUE attribute");
            }
            String className = this.findAttributeValue(arg, type, TYPE_ATTR);
            tag.addArg(className, this.convertToObject(className, this.findAttributeValue(arg, value, VALUE_ATTR)));
            start = end + 1;
        }
    }

    private void parseMLetAttributes(MLetTag tag, String content) throws MLetParseException {
        int version;
        int name;
        int end = content.indexOf(CLOSE_BRACKET);
        String attributes = content.substring(0, end);
        int archive = -1;
        int object = -1;
        int code = -1;
        archive = attributes.indexOf(ARCHIVE_ATTR);
        if (archive < 0) {
            throw new MLetParseException("Missing ARCHIVE attribute");
        }
        code = attributes.indexOf(CODE_ATTR);
        object = attributes.indexOf(OBJECT_ATTR);
        if (code < 0 && object < 0) {
            throw new MLetParseException("Missing CODE or OBJECT attribute");
        }
        if (code > 0 && object > 0) {
            throw new MLetParseException("CODE and OBJECT attributes cannot be both present");
        }
        if (code >= 0) {
            tag.setCode(this.findAttributeValue(attributes, code, CODE_ATTR));
        } else {
            tag.setObject(this.findAttributeValue(attributes, object, OBJECT_ATTR));
        }
        tag.setArchive(this.findAttributeValue(attributes, archive, ARCHIVE_ATTR));
        int codebase = attributes.indexOf(CODEBASE_ATTR);
        if (codebase >= 0) {
            tag.setCodeBase(this.findAttributeValue(attributes, codebase, CODEBASE_ATTR));
        }
        if ((name = attributes.indexOf(NAME_ATTR)) >= 0) {
            String objectName = this.findAttributeValue(attributes, name, NAME_ATTR);
            try {
                tag.setName(new ObjectName(objectName));
            }
            catch (MalformedObjectNameException x) {
                throw new MLetParseException("Invalid ObjectName: " + objectName);
            }
        }
        if ((version = attributes.indexOf(VERSION_ATTR)) >= 0) {
            tag.setVersion(this.findAttributeValue(attributes, version, VERSION_ATTR));
        }
    }

    private String findAttributeValue(String content, int start, String attribute) throws MLetParseException {
        int equal = content.indexOf(61, start);
        if (equal < 0) {
            throw new MLetParseException("Missing '=' for attribute");
        }
        if (!attribute.equals(content.substring(start, equal).trim())) {
            throw new MLetParseException("Invalid attribute");
        }
        int begin = content.indexOf(34, equal + 1);
        if (begin < 0) {
            throw new MLetParseException("Missing quotes for attribute value");
        }
        if (content.substring(equal + 1, begin).trim().length() != 0) {
            throw new MLetParseException("Invalid attribute value");
        }
        int end = content.indexOf(34, begin + 1);
        if (end < 0) {
            throw new MLetParseException("Missing quote for attribute value");
        }
        return content.substring(begin + 1, end).trim();
    }

    private int findOpenTag(String content, int start, String tag) {
        String opening = OPEN_BRACKET + tag;
        return content.indexOf(opening, start);
    }

    private int findCloseTag(String content, int start, String tag, boolean strictSyntax) {
        int count = 1;
        int close;
        while ((close = content.indexOf(CLOSE_BRACKET, start)) >= 0) {
            int open = content.indexOf(OPEN_BRACKET, start);
            if (open >= 0 && close > open) {
                ++count;
            } else if (--count == 0) {
                if (!strictSyntax || strictSyntax && content.charAt(close - 1) == '/') {
                    return close + 1;
                }
                String closing = OPEN_BRACKET + "/" + tag + CLOSE_BRACKET;
                close = content.indexOf(closing, start);
                if (close < 0) {
                    return -1;
                }
                return close + closing.length();
            }
            start = close + 1;
        }
        return -1;
    }

    private String stripComments(String content) throws MLetParseException {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int current = -1;
        while ((current = content.indexOf(OPEN_COMMENT, start)) >= 0) {
            int end = content.indexOf(CLOSE_COMMENT, current + 1);
            if (end < 0) {
                throw new MLetParseException("Missing close comment tag at index: " + current);
            }
            String stripped = content.substring(start, current);
            buffer.append(stripped);
            start = end + CLOSE_COMMENT.length();
        }
        String stripped = content.substring(start, content.length());
        buffer.append(stripped);
        return buffer.toString();
    }

    private String convertToUpperCase(String content) throws MLetParseException {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int current = -1;
        while ((current = content.indexOf("\"", start)) >= 0) {
            int end = content.indexOf("\"", current + 1);
            if (end < 0) {
                throw new MLetParseException("Missing closing quote at index: " + current);
            }
            String converted = content.substring(start, current).toUpperCase();
            buffer.append(converted);
            String quoted = content.substring(current, end + 1);
            buffer.append(quoted);
            start = end + 1;
        }
        String converted = content.substring(start, content.length()).toUpperCase();
        buffer.append(converted);
        return buffer.toString();
    }

    private Object convertToObject(String clsName, String value) throws MLetParseException {
        try {
            if (clsName.equals("boolean") || clsName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(value);
            }
            if (clsName.equals("byte") || clsName.equals("java.lang.Byte")) {
                return Byte.valueOf(value);
            }
            if (clsName.equals("char") || clsName.equals("java.lang.Character")) {
                char ch = '\u0000';
                if (value.length() > 0) {
                    ch = value.charAt(0);
                }
                return new Character(ch);
            }
            if (clsName.equals("short") || clsName.equals("java.lang.Short")) {
                return Short.valueOf(value);
            }
            if (clsName.equals("int") || clsName.equals("java.lang.Integer")) {
                return Integer.valueOf(value);
            }
            if (clsName.equals("long") || clsName.equals("java.lang.Long")) {
                return Long.valueOf(value);
            }
            if (clsName.equals("float") || clsName.equals("java.lang.Float")) {
                return Float.valueOf(value);
            }
            if (clsName.equals("double") || clsName.equals("java.lang.Double")) {
                return Double.valueOf(value);
            }
            if (clsName.equals("java.lang.String")) {
                return value;
            }
            if (this.mlet != null) {
                try {
                    Class<?> cls = this.mlet.loadClass(clsName);
                    Constructor<?> ctor = cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = MLetParser.class$("java.lang.String")) : class$java$lang$String);
                    return ctor.newInstance(value);
                }
                catch (Exception ignored) {}
            }
        }
        catch (NumberFormatException x) {
            throw new MLetParseException("Invalid value: " + value);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

