<?xml version="1.0"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.4 $
																																					-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="yes" encoding="UTF-8"/>

	<!-- array link generator -->
	<xsl:template name="array">

		<xsl:choose>
			<xsl:when test="@isnull='false'">
				<xsl:variable name="url">getattribute?objectname=<xsl:value-of select="../@objectname"/>&amp;attribute=<xsl:value-of select="@name"/>&amp;format=array&amp;template=viewarray</xsl:variable>
				<a href="{$url}">
					<xsl:call-template name="str">
						<xsl:with-param name="id">mbean_attributes.array.view</xsl:with-param>
					</xsl:call-template>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="str">
					<xsl:with-param name="id">mbean_attributes.array.null</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Collection link generator -->
	<xsl:template name="collection">

		<xsl:choose>
			<xsl:when test="@isnull='false'">
				<xsl:variable name="url">getattribute?objectname=<xsl:value-of select="../@objectname"/>&amp;attribute=<xsl:value-of select="@name"/>&amp;format=collection&amp;template=viewcollection</xsl:variable>
				<a href="{$url}">
					<xsl:call-template name="str">
						<xsl:with-param name="id">mbean_attributes.collection.view</xsl:with-param>
					</xsl:call-template>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="str">
					<xsl:with-param name="id">mbean_attributes.collection.null</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Map link generator -->
	<xsl:template name="map">

		<xsl:choose>
			<xsl:when test="@isnull='false'">
				<xsl:variable name="url">getattribute?objectname=<xsl:value-of select="../@objectname"/>&amp;attribute=<xsl:value-of select="@name"/>&amp;format=map&amp;template=viewmap</xsl:variable>
				<a href="{$url}">
					<xsl:call-template name="str">
						<xsl:with-param name="id">mbean_attributes.map.view</xsl:with-param>
					</xsl:call-template>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="str">
					<xsl:with-param name="id">mbean_attributes.map.null</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="raw-input">
		<xsl:param name="type"/>
		<xsl:param name="value"/>
		<xsl:param name="name"/>
		<xsl:param name="strinit"/>

		<xsl:variable name="result">none</xsl:variable>
		<xsl:choose>
			<xsl:when test="$type='java.lang.String'
				or $type='java.lang.Double'
				or $type='java.lang.Short'
				or $type='java.lang.Integer'
				or $type='java.lang.Long'
				or $type='java.lang.Float'
				or $type='java.lang.Byte'
				or $type='java.lang.Character'
				or $type='javax.management.ObjectName'
				or $type='int'
				or $type='short'
				or $type='byte'
				or $type='char'
				or $type='double'
				or $type='long'
				or $type='float'
				or $strinit='true'">
				<input type="text" name="{$name}" value="{$value}"/>
			</xsl:when>
			<xsl:when test="$type='java.lang.Boolean' or $type='boolean'">
			  <xsl:variable name="true">
			    <xsl:call-template name="str">
            <xsl:with-param name="id">mbean_attributes.boolean.true</xsl:with-param>
          </xsl:call-template>
			  </xsl:variable>
			  <xsl:variable name="false">
			    <xsl:call-template name="str">
            <xsl:with-param name="id">mbean_attributes.boolean.false</xsl:with-param>
          </xsl:call-template>
			  </xsl:variable>
			  
				<xsl:choose>
					<xsl:when test="$value='true'">
						<input name="{$name}" type="radio" checked="checked" value="true"><xsl:value-of select="$true"/> </input>
						<input name="{$name}" type="radio" value="false"><xsl:value-of select="$false"/> </input>
					</xsl:when>
					<xsl:when test="$value='false'">
						<input name="{$name}" type="radio" value="true"><xsl:value-of select="$true"/> </input>
						<input name="{$name}" type="radio" checked="checked" value="false"><xsl:value-of select="$false"/> </input>
					</xsl:when>
					<xsl:otherwise>
						<input name="{$name}" type="radio" value="true" checked="checked"><xsl:value-of select="$true"/> </input>
						<input name="{$name}" type="radio" value="false"><xsl:value-of select="$false"/> </input>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="Attribute[@type]" name="form">
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="@type='java.lang.String'
				or @type='java.lang.Double'
				or @type='java.lang.Short'
				or @type='java.lang.Integer'
				or @type='java.lang.Long'
				or @type='java.lang.Float'
				or @type='java.lang.Byte'
				or @type='java.lang.Boolean'
				or @type='java.lang.Character'
				or @type='javax.management.ObjectName'
				or @type='int'
				or @type='short'
				or @type='byte'
				or @type='double'
				or @type='boolean'
				or @type='long'
				or @type='char'
				or @type='float'">
				<xsl:variable name="name" select="@name"/>
						<xsl:call-template name="raw-input">
							<xsl:with-param name="type" select="@type"/>
							<xsl:with-param name="value" select="$value"/>
							<xsl:with-param name="name">value_<xsl:value-of select="@name"/></xsl:with-param>
							<xsl:with-param name="strinit">false</xsl:with-param>
						</xsl:call-template>&#160;
						<xsl:call-template name="submit">
							<xsl:with-param name="name" select="@name"/>
						</xsl:call-template>
			</xsl:when>
			<xsl:when test="@strinit='true'">
				<xsl:variable name="name" select="@name"/>
					<xsl:call-template name="raw-input">
						<xsl:with-param name="type" select="@type"/>
						<xsl:with-param name="value" select="$value"/>
						<xsl:with-param name="name">value_<xsl:value-of select="@name"/></xsl:with-param>
						<xsl:with-param name="strinit">true</xsl:with-param>
					</xsl:call-template>&#160;
					<xsl:call-template name="submit">
						<xsl:with-param name="name" select="@name"/>
					</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="str">
					<xsl:with-param name="id">mbean_attributes.form.unknowntype</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Makes the submit button for setting one attribute -->
	<xsl:template match="Attribute[@type]" name="submit">
		<xsl:param name="name"/>
		<xsl:if test="@type='java.lang.String'
			or @type='java.lang.Double'
			or @type='java.lang.Short'
			or @type='java.lang.Integer'
			or @type='java.lang.Long'
			or @type='java.lang.Float'
			or @type='java.lang.Byte'
			or @type='java.lang.Character'
			or @type='java.lang.Boolean'
			or @type='javax.management.ObjectName'
			or @type='int'
			or @type='short'
			or @type='boolean'
			or @type='byte'
			or @type='long'
			or @type='char'
			or @type='double'
			or @type='float'
			or @strinit='true'">
			<xsl:variable name="str.set">
				<xsl:call-template name="str">
					<xsl:with-param name="id">mbean_attributes.submit.set</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<input class="buttons" type="Submit" name="set_{$name}" value="{$str.set}"/>
		</xsl:if>
	</xsl:template>

	<xsl:template match="Attribute" name="WO">
		<xsl:param name="cellcolor" select="." />
		<td align="left" bgcolor="{$cellcolor}" width="10%">
			<xsl:call-template name="str">
				<xsl:with-param name="id">mbean_attributes.WO.readonly</xsl:with-param>
			</xsl:call-template>
		</td>
		<td align="left" bgcolor="{$cellcolor}">
			<xsl:call-template name="form"/></td>
	</xsl:template>

	<!-- Template for readwrite attributes -->
	<xsl:template match="Attribute" name="RW">
		<xsl:param name="cellcolor" select="." />
		<td align="left" bgcolor="{$cellcolor}" width="10%">
			<xsl:choose>
				<xsl:when test="@aggregation='collection'">
					<xsl:call-template name="collection"/>
				</xsl:when>
				<xsl:when test="@aggregation='map'">
					<xsl:call-template name="map"/>
				</xsl:when>
				<xsl:when test="starts-with(@type, '[L')">
					<xsl:call-template name="array"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@value"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td align="left" bgcolor="{$cellcolor}">
			<xsl:call-template name="form">
				<xsl:with-param name="value" select="@value"/>
			</xsl:call-template>
		</td>
	</xsl:template>

	<!-- Template for readonly attributes -->
	<xsl:template match="Attribute" name="RO">
		<xsl:param name="cellcolor" select="." />
		<td align="left" bgcolor="{$cellcolor}" width="10%">
			<xsl:choose>
				<xsl:when test="@aggregation='collection'">
					<xsl:call-template name="collection"/>
				</xsl:when>
				<xsl:when test="@aggregation='map'">
					<xsl:call-template name="map"/>
				</xsl:when>
				<xsl:when test="starts-with(@type, '[L')">
					<xsl:call-template name="array"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@value"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td align="left" bgcolor="{$cellcolor}">
			<xsl:call-template name="str">
				<xsl:with-param name="id">mbean_attributes.RO.readonly</xsl:with-param>
			</xsl:call-template>
		</td>
	</xsl:template>

	<!-- MBean's attributes template -->
	<xsl:template name="attribute">
	  
		  <table width="{$pageWidth}" cellpadding="0" cellspacing="0" border="0">
        <tr>
          <td>
            <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
          </td>
          <td align="left" bgcolor="#993399" nowrap="nowrap">
            <span class="Titre2">
              <font color="#FFFFFF">
                <b>
                  <xsl:call-template name="str">
								    <xsl:with-param name="id">mbean.mbean.attributes</xsl:with-param>
							    </xsl:call-template>
                </b>
              </font>
            </span>
          </td>
          <td>
            <img border="0" src="images/bkgd_onglet_tit.gif"/>
          </td>
          <td bgcolor="#660066" width="100%"/>
        </tr>
      </table>
      <table width="{$pageWidth}" cellpadding="2" cellspacing="0" border="0">
        <tr valign="top" align="left"> 
          <td bgcolor="#993399" class="Titre3black" width="15%">
            <img src="images/arrow_s_tit.gif" width="11" height="7"/>&#160;
            <font color="#FFFFFF"><b>
              <xsl:call-template name="str">
							  <xsl:with-param name="id">mbean_attributes.attribute.name</xsl:with-param>
						  </xsl:call-template>
            </b></font>
          </td>
          <td bgcolor="#993399" class="Titre3black" width="45%">
            <img src="images/arrow_s_tit.gif" width="11" height="7"/>&#160;
            <font color="#FFFFFF"><b>
              <xsl:call-template name="str">
							  <xsl:with-param name="id">mbean_attributes.attribute.description</xsl:with-param>
						  </xsl:call-template>
            </b></font>
          </td>
          <td bgcolor="#993399" class="Titre3black" width="10%">
            <img src="images/arrow_s_tit.gif" width="11" height="7"/>&#160;
            <font color="#FFFFFF"><b>
              <xsl:call-template name="str">
							  <xsl:with-param name="id">mbean_attributes.attribute.type</xsl:with-param>
						  </xsl:call-template>
            </b></font>
          </td>
          <td bgcolor="#993399" class="Titre3black" width="10%">
            <img src="images/arrow_s_tit.gif" width="11" height="7"/>&#160;
            <font color="#FFFFFF"><b>
              <xsl:call-template name="str">
							  <xsl:with-param name="id">mbean_attributes.attribute.value</xsl:with-param>
						  </xsl:call-template>
            </b></font>
          </td>
          <td bgcolor="#993399" class="Titre3black">
            <img src="images/arrow_s_tit.gif" width="11" height="7"/>&#160;
            <font color="#FFFFFF"><b>
              <xsl:call-template name="str">
							  <xsl:with-param name="id">mbean_attributes.attribute.newvalue</xsl:with-param>
						  </xsl:call-template>
            </b></font>
          </td>
        </tr>
			<form action="setattributes" method="get">
			<xsl:for-each select="Attribute">
				<xsl:sort data-type="text" order="ascending" select="@name"/>
				<xsl:variable name="cellcolor">
					<xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
					<xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
				</xsl:variable>
				<tr>
					<td bgcolor="{$cellcolor}" width="15%">
						<xsl:value-of select="@name"/>
					</td>
					<td bgcolor="{$cellcolor}" width="45%">
						<xsl:value-of select="@description"/>
					</td>
					<td bgcolor="{$cellcolor}" width="10%">
						<xsl:choose>
							<xsl:when test="starts-with(@type, '[L')">
								<xsl:call-template name="str">
									<xsl:with-param name="id">mbean_attributes.attribute.arrayof</xsl:with-param>
									<xsl:with-param name="p0"><xsl:value-of select="substring-before(substring-after(@type, '[L'), ';')"/></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
                  <xsl:when test="starts-with( @type, 'java.lang.' )">
                    <xsl:value-of select="substring-after( @type, 'java.lang.' )"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@type"/>
                  </xsl:otherwise>
                </xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<xsl:choose>
						<xsl:when test="@availability='RO'">
							<xsl:call-template name="RO">
							  <xsl:with-param name="cellcolor" select="$cellcolor"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="@availability='RW'">
							<xsl:call-template name="RW">
							  <xsl:with-param name="cellcolor" select="$cellcolor"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="@availability='WO'">
							<xsl:call-template name="WO">
							  <xsl:with-param name="cellcolor" select="$cellcolor"/>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</tr>
			</xsl:for-each>
			<xsl:choose>
			  <xsl:when test="Attribute">
			  <tr>
			    <td height="35" colspan="5" align="right">
				    <xsl:variable name="str.setall">
					    <xsl:call-template name="str">
						    <xsl:with-param name="id">mbean_attributes.attribute.setall</xsl:with-param>
					    </xsl:call-template>
				    </xsl:variable>
				    <input class="buttons" type="Submit" name="setall" value="{$str.setall}"/>&#160;&#160;
            <input type="hidden" name="objectname" value="{$request.objectname}"/>
			    </td>
			  </tr>
			  </xsl:when>
			  <xsl:otherwise>
			    <tr>
			      <td colspan="5" align="center">
			        <xsl:call-template name="str">
							  <xsl:with-param name="id">mbean_attributes.noattributes</xsl:with-param>
							</xsl:call-template><br/><br/>
						</td>
			    </tr>
			  </xsl:otherwise>
			</xsl:choose>
			</form>
		</table>
	</xsl:template>
</xsl:stylesheet>
